/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.datasource.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceMBean;
import com.buession.core.utils.ObjectUtils;
import com.buession.core.validator.Validate;
import com.buession.jdbc.datasource.Dbcp2DataSource;
import com.buession.jdbc.datasource.TomcatDataSource;
import com.buession.springboot.datasource.metadata.DataSourcePoolMetadata;
import com.buession.springboot.datasource.metadata.DataSourcePoolMetadataProvider;
import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceMXBean;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.CommonsDbcp2DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DruidDataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.HikariDataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.TomcatDataSourcePoolMetadata;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class DataSourcePoolMetadataProvidersConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={TomcatDataSource.class})
    static class TomcatDataSourcePoolMetadataProviderConfiguration
    extends AbstractPoolDataSourceMetadataProviderConfiguration<DataSourcePoolMetadataProvider.TomcatDataSourcePoolMetadataProvider> {
        TomcatDataSourcePoolMetadataProviderConfiguration() {
        }

        @Override
        @Bean
        public DataSourcePoolMetadataProvider.TomcatDataSourcePoolMetadataProvider poolDataSourceMetadataProvider() {
            return dataSource -> {
                DataSourcePoolMetadata dataSourcePoolMetadata = new DataSourcePoolMetadata();
                DataSource tomcatDataSource = (DataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)dataSource.getMaster(), ConnectionPoolMBean.class, DataSource.class);
                ObjectUtils.invokeIfAvailable((Object)tomcatDataSource, ds -> dataSourcePoolMetadata.setMaster((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new TomcatDataSourcePoolMetadata(ds)));
                if (Validate.isNotEmpty(dataSource.getSlaves())) {
                    dataSourcePoolMetadata.setSlaves(new ArrayList<org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata>(dataSource.getSlaves().size()));
                    for (javax.sql.DataSource datasource : dataSource.getSlaves()) {
                        tomcatDataSource = (DataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)datasource, ConnectionPoolMBean.class, DataSource.class);
                        ObjectUtils.invokeIfAvailable((Object)tomcatDataSource, ds -> dataSourcePoolMetadata.getSlaves().add((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new TomcatDataSourcePoolMetadata(ds)));
                    }
                }
                return dataSourcePoolMetadata;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={com.buession.jdbc.datasource.DruidDataSource.class})
    static class DruidPoolDataSourceMetadataProviderConfiguration
    extends AbstractPoolDataSourceMetadataProviderConfiguration<DataSourcePoolMetadataProvider.DruidDataSourcePoolMetadataProvider> {
        DruidPoolDataSourceMetadataProviderConfiguration() {
        }

        @Override
        @Bean
        public DataSourcePoolMetadataProvider.DruidDataSourcePoolMetadataProvider poolDataSourceMetadataProvider() {
            return dataSource -> {
                DataSourcePoolMetadata dataSourcePoolMetadata = new DataSourcePoolMetadata();
                DruidDataSource druidDataSource = (DruidDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)dataSource.getMaster(), DruidDataSourceMBean.class, DruidDataSource.class);
                ObjectUtils.invokeIfAvailable((Object)druidDataSource, ds -> dataSourcePoolMetadata.setMaster((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new DruidDataSourcePoolMetadata((DruidDataSource)ds)));
                if (Validate.isNotEmpty(dataSource.getSlaves())) {
                    dataSourcePoolMetadata.setSlaves(new ArrayList<org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata>(dataSource.getSlaves().size()));
                    for (javax.sql.DataSource datasource : dataSource.getSlaves()) {
                        druidDataSource = (DruidDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)datasource, DruidDataSourceMBean.class, DruidDataSource.class);
                        ObjectUtils.invokeIfAvailable((Object)druidDataSource, ds -> dataSourcePoolMetadata.getSlaves().add((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new DruidDataSourcePoolMetadata((DruidDataSource)ds)));
                    }
                }
                return dataSourcePoolMetadata;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Dbcp2DataSource.class})
    static class Dbcp2PoolDataSourceMetadataProviderConfiguration
    extends AbstractPoolDataSourceMetadataProviderConfiguration<DataSourcePoolMetadataProvider.Dbcp2DataSourcePoolMetadataProvider> {
        Dbcp2PoolDataSourceMetadataProviderConfiguration() {
        }

        @Override
        @Bean
        public DataSourcePoolMetadataProvider.Dbcp2DataSourcePoolMetadataProvider poolDataSourceMetadataProvider() {
            return dataSource -> {
                DataSourcePoolMetadata dataSourcePoolMetadata = new DataSourcePoolMetadata();
                BasicDataSource dbcp2DataSource = (BasicDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)dataSource.getMaster(), BasicDataSourceMXBean.class, BasicDataSource.class);
                ObjectUtils.invokeIfAvailable((Object)dbcp2DataSource, ds -> dataSourcePoolMetadata.setMaster((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new CommonsDbcp2DataSourcePoolMetadata(ds)));
                if (Validate.isNotEmpty(dataSource.getSlaves())) {
                    dataSourcePoolMetadata.setSlaves(new ArrayList<org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata>(dataSource.getSlaves().size()));
                    for (javax.sql.DataSource datasource : dataSource.getSlaves()) {
                        dbcp2DataSource = (BasicDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)datasource, BasicDataSourceMXBean.class, BasicDataSource.class);
                        ObjectUtils.invokeIfAvailable((Object)dbcp2DataSource, ds -> dataSourcePoolMetadata.getSlaves().add((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new CommonsDbcp2DataSourcePoolMetadata(ds)));
                    }
                }
                return dataSourcePoolMetadata;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={com.buession.jdbc.datasource.HikariDataSource.class})
    static class HikariPoolDataSourceMetadataProviderConfiguration
    extends AbstractPoolDataSourceMetadataProviderConfiguration<DataSourcePoolMetadataProvider.HikariDataSourcePoolMetadataProvider> {
        HikariPoolDataSourceMetadataProviderConfiguration() {
        }

        @Override
        @Bean
        public DataSourcePoolMetadataProvider.HikariDataSourcePoolMetadataProvider poolDataSourceMetadataProvider() {
            return dataSource -> {
                DataSourcePoolMetadata dataSourcePoolMetadata = new DataSourcePoolMetadata();
                HikariDataSource hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)dataSource.getMaster(), HikariConfigMXBean.class, HikariDataSource.class);
                ObjectUtils.invokeIfAvailable((Object)hikariDataSource, ds -> dataSourcePoolMetadata.setMaster((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new HikariDataSourcePoolMetadata(ds)));
                if (Validate.isNotEmpty(dataSource.getSlaves())) {
                    dataSourcePoolMetadata.setSlaves(new ArrayList<org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata>(dataSource.getSlaves().size()));
                    for (javax.sql.DataSource datasource : dataSource.getSlaves()) {
                        hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((javax.sql.DataSource)datasource, HikariConfigMXBean.class, HikariDataSource.class);
                        ObjectUtils.invokeIfAvailable((Object)hikariDataSource, ds -> dataSourcePoolMetadata.getSlaves().add((org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata)new HikariDataSourcePoolMetadata(ds)));
                    }
                }
                return dataSourcePoolMetadata;
            };
        }
    }

    static abstract class AbstractPoolDataSourceMetadataProviderConfiguration<PMP extends DataSourcePoolMetadataProvider<?>> {
        AbstractPoolDataSourceMetadataProviderConfiguration() {
        }

        abstract PMP poolDataSourceMetadataProvider();
    }
}

