/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.datasource.autoconfigure;

import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DatabaseDriver;

class DataSources {
    DataSources() {
    }

    protected static <T extends javax.sql.DataSource> T createDataSource(DataSourceProperties properties, Class<T> type) {
        return (T)properties.initializeDataSourceBuilder().type(type).build();
    }

    public static final class GenericDataSource
    extends com.buession.jdbc.datasource.GenericDataSource {
        private final DataSourceProperties properties;

        public GenericDataSource(DataSourceProperties properties) {
            super(properties.determineDriverClassName(), properties.determineUrl(), properties.determineUsername(), properties.determinePassword());
            this.properties = properties;
        }

        public javax.sql.DataSource createDataSource() {
            Object dataSource = DataSources.createDataSource(this.properties, null);
            this.initialize((javax.sql.DataSource)dataSource);
            return dataSource;
        }
    }

    public static final class TomcatDataSource
    extends com.buession.jdbc.datasource.TomcatDataSource {
        private final DataSourceProperties properties;

        public TomcatDataSource(DataSourceProperties properties) {
            super(properties.determineDriverClassName(), properties.determineUrl(), properties.determineUsername(), properties.determinePassword());
            this.properties = properties;
        }

        public DataSource createDataSource() {
            DataSource dataSource = DataSources.createDataSource(this.properties, DataSource.class);
            this.initialize((javax.sql.DataSource)dataSource);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl((String)this.properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }

    public static final class DruidDataSource
    extends com.buession.jdbc.datasource.DruidDataSource {
        private final DataSourceProperties properties;

        public DruidDataSource(DataSourceProperties properties) {
            super(properties.determineDriverClassName(), properties.determineUrl(), properties.determineUsername(), properties.determinePassword());
            this.properties = properties;
        }

        public com.alibaba.druid.pool.DruidDataSource createDataSource() {
            com.alibaba.druid.pool.DruidDataSource dataSource = DataSources.createDataSource(this.properties, com.alibaba.druid.pool.DruidDataSource.class);
            this.initialize((javax.sql.DataSource)dataSource);
            return dataSource;
        }
    }

    public static final class Dbcp2DataSource
    extends com.buession.jdbc.datasource.Dbcp2DataSource {
        private final DataSourceProperties properties;

        public Dbcp2DataSource(DataSourceProperties properties) {
            super(properties.determineDriverClassName(), properties.determineUrl(), properties.determineUsername(), properties.determinePassword());
            this.properties = properties;
        }

        public BasicDataSource createDataSource() {
            BasicDataSource dataSource = DataSources.createDataSource(this.properties, BasicDataSource.class);
            this.initialize((javax.sql.DataSource)dataSource);
            return dataSource;
        }
    }

    public static final class HikariDataSource
    extends com.buession.jdbc.datasource.HikariDataSource {
        private final DataSourceProperties properties;

        public HikariDataSource(DataSourceProperties properties) {
            super(properties.determineDriverClassName(), properties.determineUrl(), properties.determineUsername(), properties.determinePassword());
            this.properties = properties;
        }

        public com.zaxxer.hikari.HikariDataSource createDataSource() {
            com.zaxxer.hikari.HikariDataSource dataSource = DataSources.createDataSource(this.properties, com.zaxxer.hikari.HikariDataSource.class);
            this.initialize((javax.sql.DataSource)dataSource);
            return dataSource;
        }
    }
}

