/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.converter.mapper.PropertyMapper;
import com.buession.core.utils.ObjectUtils;
import com.buession.core.validator.Validate;
import com.buession.springboot.pac4j.autoconfigure.AbstractPac4jClientConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import com.buession.springboot.pac4j.config.Cas;
import java.util.List;
import java.util.stream.Collectors;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.client.direct.DirectCasClient;
import org.pac4j.cas.client.direct.DirectCasProxyClient;
import org.pac4j.cas.client.rest.CasRestBasicAuthClient;
import org.pac4j.cas.client.rest.CasRestFormClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
@ConditionalOnClass(value={CasConfiguration.class})
@ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(value={Pac4jConfiguration.class})
public class Pac4jCasConfiguration {
    private final Pac4jProperties properties;

    public Pac4jCasConfiguration(Pac4jProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"proxy.enabled"}, havingValue="true")
    public CasProxyReceptor casProxyReceptor() {
        CasProxyReceptor proxyReceptor = new CasProxyReceptor();
        proxyReceptor.setCallbackUrl(this.properties.getClient().getCas().getCallbackUrl());
        return proxyReceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public CasConfiguration casConfiguration(ObjectProvider<CasProxyReceptor> casProxyReceptor) {
        CasConfiguration casConfiguration = new CasConfiguration();
        Cas config = this.properties.getClient().getCas();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)config.getProtocol()).to(arg_0 -> ((CasConfiguration)casConfiguration).setProtocol(arg_0));
        propertyMapper.from((Object)config.getPrefixUrl()).to(arg_0 -> ((CasConfiguration)casConfiguration).setPrefixUrl(arg_0));
        propertyMapper.from((Object)config.getLoginUrl()).to(arg_0 -> ((CasConfiguration)casConfiguration).setLoginUrl(arg_0));
        propertyMapper.from((Object)config.getEncoding()).to(arg_0 -> ((CasConfiguration)casConfiguration).setEncoding(arg_0));
        propertyMapper.from((Object)config.getMethod()).to(arg_0 -> ((CasConfiguration)casConfiguration).setMethod(arg_0));
        propertyMapper.from((Object)config.getGateway()).to(arg_0 -> ((CasConfiguration)casConfiguration).setGateway(arg_0));
        propertyMapper.from((Object)config.getRenew()).to(arg_0 -> ((CasConfiguration)casConfiguration).setRenew(arg_0));
        propertyMapper.from((Object)config.getTimeTolerance()).to(arg_0 -> ((CasConfiguration)casConfiguration).setTimeTolerance(arg_0));
        propertyMapper.from((Object)config.getPostLogoutUrlParameter()).to(arg_0 -> ((CasConfiguration)casConfiguration).setPostLogoutUrlParameter(arg_0));
        propertyMapper.from(config.getCustomParameters()).to(arg_0 -> ((CasConfiguration)casConfiguration).setCustomParams(arg_0));
        casProxyReceptor.ifUnique(arg_0 -> ((CasConfiguration)casConfiguration).setProxyReceptor(arg_0));
        return casConfiguration;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={Pac4jProperties.class})
    static class Pac4jCasClientConfiguration
    extends AbstractPac4jClientConfiguration<Cas> {
        private final CasConfiguration casConfiguration;

        public Pac4jCasClientConfiguration(Pac4jProperties properties, ObjectProvider<CasConfiguration> casConfiguration) {
            super(properties, properties.getClient().getCas());
            this.casConfiguration = (CasConfiguration)casConfiguration.getIfAvailable();
        }

        @Bean(name={"casClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"general.enabled"}, havingValue="true")
        public CasClient casClient() {
            CasClient casClient = new CasClient(this.casConfiguration){

                protected void clientInit() {
                    super.clientInit();
                    this.doClientInit((BaseClient<TokenCredentials>)this);
                }
            };
            ObjectUtils.invokeIfAvailable((Object)((Cas)this.config).getCallbackUrl(), arg_0 -> ((CasClient)casClient).setCallbackUrl(arg_0));
            this.afterClientInitialized((BaseClient<Credentials>)casClient, ((Cas)this.config).getGeneral());
            return casClient;
        }

        @Bean(name={"casRestFormClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"rest-form.enabled"}, havingValue="true")
        public CasRestFormClient casRestFormClient() {
            CasRestFormClient casRestFormClient = new CasRestFormClient();
            casRestFormClient.setConfiguration(this.casConfiguration);
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from(((Cas)this.config).getRestForm()::getUsernameParameter).to(arg_0 -> ((CasRestFormClient)casRestFormClient).setUsernameParameter(arg_0));
            propertyMapper.from(((Cas)this.config).getRestForm()::getPasswordParameter).to(arg_0 -> ((CasRestFormClient)casRestFormClient).setPasswordParameter(arg_0));
            this.afterClientInitialized((BaseClient<Credentials>)casRestFormClient, ((Cas)this.config).getRestForm());
            return casRestFormClient;
        }

        @Bean(name={"directCasClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"direct.enabled"}, havingValue="true")
        public DirectCasClient directCasClient() {
            DirectCasClient directCasClient = new DirectCasClient(this.casConfiguration){

                protected void clientInit() {
                    super.clientInit();
                    this.doClientInit((BaseClient<TokenCredentials>)this);
                }
            };
            this.afterClientInitialized((BaseClient<Credentials>)directCasClient, ((Cas)this.config).getDirect());
            return directCasClient;
        }

        @Bean(name={"directCasProxyClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"direct-proxy.enabled"}, havingValue="true")
        public DirectCasProxyClient directCasProxyClient() {
            DirectCasProxyClient directCasProxyClient = new DirectCasProxyClient(this.casConfiguration, ((Cas)this.config).getPrefixUrl()){

                protected void clientInit() {
                    super.clientInit();
                    this.doClientInit((BaseClient<TokenCredentials>)this);
                }
            };
            this.afterClientInitialized((BaseClient<Credentials>)directCasProxyClient, ((Cas)this.config).getDirectProxy());
            return directCasProxyClient;
        }

        @Bean(name={"casRestBasicAuthClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.cas", name={"rest-basic-auth.enabled"}, havingValue="true")
        public CasRestBasicAuthClient casRestBasicAuthClient() {
            CasRestBasicAuthClient casRestBasicAuthClient = new CasRestBasicAuthClient();
            casRestBasicAuthClient.setConfiguration(this.casConfiguration);
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from(((Cas)this.config).getRestBasicAuth()::getHeaderName).to(arg_0 -> ((CasRestBasicAuthClient)casRestBasicAuthClient).setHeaderName(arg_0));
            propertyMapper.from(((Cas)this.config).getRestBasicAuth()::getPrefixHeader).to(arg_0 -> ((CasRestBasicAuthClient)casRestBasicAuthClient).setPrefixHeader(arg_0));
            this.afterClientInitialized((BaseClient<Credentials>)casRestBasicAuthClient, ((Cas)this.config).getRestBasicAuth());
            return casRestBasicAuthClient;
        }

        protected void doClientInit(BaseClient<TokenCredentials> client) {
            ObjectUtils.invokeIfAvailable(((Cas)this.config).getProfileDefinition(), profileDefinition -> ((CasAuthenticator)client.getAuthenticator()).setProfileDefinition((ProfileDefinition)BeanUtils.instantiateClass((Class)profileDefinition)));
            if (Validate.isNotEmpty(((Cas)this.config).getAuthorizationGenerator())) {
                List authorizationGenerators = ((Cas)this.config).getAuthorizationGenerator().stream().map(BeanUtils::instantiateClass).collect(Collectors.toList());
                client.setAuthorizationGenerators(authorizationGenerators);
            }
        }
    }
}

