/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.utils.ObjectUtils;
import com.buession.security.pac4j.spring.reactive.Pac4jWebFluxConfigurerAdapter;
import com.buession.security.pac4j.spring.servlet.Pac4jWebMvcConfigurerAdapter;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import java.util.List;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
public class Pac4jConfiguration {
    private final Pac4jProperties properties;

    public Pac4jConfiguration(Pac4jProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Clients clients(List<Client> clientList) {
        Clients clients = new Clients(clientList);
        ObjectUtils.invokeIfAvailable(this.properties.getAjaxRequestResolverClass(), ajaxRequestResolver -> clients.setAjaxRequestResolver((AjaxRequestResolver)BeanUtils.instantiateClass((Class)ajaxRequestResolver)));
        return clients;
    }

    @Bean
    @ConditionalOnMissingBean
    public Config config(Clients clients) {
        Config config = Config.INSTANCE;
        config.setClients(clients);
        ObjectUtils.invokeIfAvailable(this.properties.getHttpActionAdapterClass(), httpActionAdapter -> config.setHttpActionAdapter((HttpActionAdapter)BeanUtils.instantiateClass((Class)httpActionAdapter)));
        return config;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class WebFluxPac4jConfigurerAdapterConfiguration {
        private final ConfigurableApplicationContext context;

        public WebFluxPac4jConfigurerAdapterConfiguration(ObjectProvider<ConfigurableApplicationContext> context) {
            this.context = (ConfigurableApplicationContext)context.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean
        public Pac4jWebFluxConfigurerAdapter pac4jWebFluxConfigurerAdapter(@Qualifier(value="webFluxAdapterRegistry") ObjectProvider<ReactiveAdapterRegistry> reactiveAdapterRegistry) {
            return new Pac4jWebFluxConfigurerAdapter((ConfigurableBeanFactory)this.context.getBeanFactory(), (ReactiveAdapterRegistry)reactiveAdapterRegistry.getIfAvailable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletPac4jConfigurerAdapterConfiguration {
        ServletPac4jConfigurerAdapterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Pac4jWebMvcConfigurerAdapter pac4jWebMvcConfigurerAdapter() {
            return new Pac4jWebMvcConfigurerAdapter();
        }
    }
}

