/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.converter.mapper.PropertyMapper;
import com.buession.springboot.pac4j.autoconfigure.AbstractPac4jClientConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import com.buession.springboot.pac4j.config.BaseConfig;
import com.buession.springboot.pac4j.config.Http;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.http.client.indirect.IndirectBasicAuthClient;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
@ConditionalOnClass(value={FormClient.class})
@ConditionalOnProperty(prefix="spring.pac4j.client.http", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(value={Pac4jConfiguration.class})
public class Pac4jHttpConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={Pac4jProperties.class})
    static class Pac4JHttpClientConfiguration
    extends AbstractPac4jClientConfiguration<Http> {
        public Pac4JHttpClientConfiguration(Pac4jProperties properties) {
            super(properties, properties.getClient().getHttp());
        }

        @Bean(name={"formClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.http", name={"form.enabled"}, havingValue="true")
        public FormClient formClient() {
            SimpleTestUsernamePasswordAuthenticator usernamePasswordAuthenticator = new SimpleTestUsernamePasswordAuthenticator();
            FormClient formClient = new FormClient(((Http)this.config).getForm().getLoginUrl(), (Authenticator)usernamePasswordAuthenticator);
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from(((Http)this.config).getForm()::getUsernameParameter).to(arg_0 -> ((FormClient)formClient).setUsernameParameter(arg_0));
            propertyMapper.from(((Http)this.config).getForm()::getPasswordParameter).to(arg_0 -> ((FormClient)formClient).setPasswordParameter(arg_0));
            this.initHttpIndirectClient((IndirectClient<? extends Credentials>)formClient, ((Http)this.config).getForm(), propertyMapper);
            return formClient;
        }

        @Bean(name={"indirectBasicAuthClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.http", name={"indirect-basic-auth.enabled"}, havingValue="true")
        public IndirectBasicAuthClient indirectBasicAuthClient() {
            SimpleTestUsernamePasswordAuthenticator usernamePasswordAuthenticator = new SimpleTestUsernamePasswordAuthenticator();
            IndirectBasicAuthClient indirectBasicAuthClient = new IndirectBasicAuthClient((Authenticator)usernamePasswordAuthenticator);
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from(((Http)this.config).getIndirectBasicAuth()::getRealmName).to(arg_0 -> ((IndirectBasicAuthClient)indirectBasicAuthClient).setRealmName(arg_0));
            this.initHttpIndirectClient((IndirectClient<? extends Credentials>)indirectBasicAuthClient, ((Http)this.config).getIndirectBasicAuth(), propertyMapper);
            return indirectBasicAuthClient;
        }

        @Bean(name={"directBasicAuthClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.http", name={"direct-basic-auth.enabled"}, havingValue="true")
        public DirectBasicAuthClient directBasicAuthClient() {
            SimpleTestUsernamePasswordAuthenticator usernamePasswordAuthenticator = new SimpleTestUsernamePasswordAuthenticator();
            DirectBasicAuthClient directBasicAuthClient = new DirectBasicAuthClient((Authenticator)usernamePasswordAuthenticator);
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from(((Http)this.config).getDirectBasicAuth()::getRealmName).to(arg_0 -> ((DirectBasicAuthClient)directBasicAuthClient).setRealmName(arg_0));
            this.afterClientInitialized((BaseClient<Credentials>)directBasicAuthClient, ((Http)this.config).getDirectBasicAuth());
            return directBasicAuthClient;
        }

        protected void initHttpIndirectClient(IndirectClient<? extends Credentials> client, BaseConfig.BaseClientConfig config, PropertyMapper propertyMapper) {
            propertyMapper.from(((Http)this.config)::getCallbackUrl).to(arg_0 -> client.setCallbackUrl(arg_0));
            this.afterClientInitialized((BaseClient<? extends Credentials>)client, config);
        }
    }
}

