/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.utils.ObjectUtils;
import com.buession.core.utils.StringUtils;
import com.buession.springboot.pac4j.autoconfigure.AbstractPac4jClientConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import com.buession.springboot.pac4j.config.Jwt;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.http.client.direct.CookieClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.http.client.direct.ParameterClient;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.pac4j.jwt.profile.JwtGenerator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
@ConditionalOnClass(value={JwtAuthenticator.class, ParameterClient.class})
@ConditionalOnProperty(prefix="spring.pac4j.client.jwt", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(value={Pac4jConfiguration.class})
public class Pac4jJwtConfiguration {
    private static final int PAD_SIZE = 32;
    private final Pac4jProperties properties;

    public Pac4jJwtConfiguration(Pac4jProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretSignatureConfiguration secretSignatureConfiguration() {
        Jwt config = this.properties.getClient().getJwt();
        String jwtSecret = StringUtils.leftPad((String)config.getEncryptionKey(), (int)32, (String)config.getEncryptionKey());
        return new SecretSignatureConfiguration(jwtSecret, config.getSecretSignatureAlgorithm());
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretEncryptionConfiguration secretEncryptionConfiguration() {
        Jwt config = this.properties.getClient().getJwt();
        String jwtEncryptionKey = StringUtils.leftPad((String)config.getEncryptionKey(), (int)32, (String)config.getEncryptionKey());
        return new SecretEncryptionConfiguration(jwtEncryptionKey, config.getSecretEncryptionAlgorithm(), config.getEncryptionMethod());
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtGenerator<CommonProfile> jwtGenerator(ObjectProvider<SecretSignatureConfiguration> signatureConfiguration, ObjectProvider<SecretEncryptionConfiguration> secretEncryptionConfiguration) {
        return new JwtGenerator((SignatureConfiguration)signatureConfiguration.getIfAvailable(), (EncryptionConfiguration)secretEncryptionConfiguration.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtAuthenticator jwtAuthenticator(ObjectProvider<SecretSignatureConfiguration> signatureConfiguration, ObjectProvider<SecretEncryptionConfiguration> secretEncryptionConfiguration) {
        Jwt config = this.properties.getClient().getJwt();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator((SignatureConfiguration)signatureConfiguration.getIfAvailable(), (EncryptionConfiguration)secretEncryptionConfiguration.getIfAvailable());
        ObjectUtils.invokeIfAvailable(config.getIdentifierGenerator(), identifierGenerator -> jwtAuthenticator.setIdentifierGenerator((ValueGenerator)BeanUtils.instantiateClass((Class)identifierGenerator)));
        return jwtAuthenticator;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={Pac4jProperties.class})
    static class Pac4JJwtClientConfiguration
    extends AbstractPac4jClientConfiguration<Jwt> {
        private final JwtAuthenticator jwtAuthenticator;

        public Pac4JJwtClientConfiguration(Pac4jProperties properties, ObjectProvider<JwtAuthenticator> jwtAuthenticator) {
            super(properties, properties.getClient().getJwt());
            this.jwtAuthenticator = (JwtAuthenticator)jwtAuthenticator.getIfAvailable();
        }

        @Bean(name={"jwtParameterClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.jwt", name={"header.enabled"}, havingValue="true")
        public HeaderClient headerClient() {
            HeaderClient headerClient = new HeaderClient(((Jwt)this.config).getHeader().getHeaderName(), ((Jwt)this.config).getHeader().getPrefixHeader(), (Authenticator)this.jwtAuthenticator);
            this.afterClientInitialized((BaseClient<Credentials>)headerClient, ((Jwt)this.config).getHeader());
            return headerClient;
        }

        @Bean(name={"jwtCookieClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.jwt", name={"cookie.enabled"}, havingValue="true")
        public CookieClient cookieClient() {
            CookieClient cookieClient = new CookieClient(((Jwt)this.config).getCookie().getCookieName(), (Authenticator)this.jwtAuthenticator);
            this.afterClientInitialized((BaseClient<Credentials>)cookieClient, ((Jwt)this.config).getCookie());
            return cookieClient;
        }

        @Bean(name={"jwtParameterClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.jwt", name={"parameter.enabled"}, havingValue="true")
        public ParameterClient parameterClient() {
            ParameterClient parameterClient = new ParameterClient(((Jwt)this.config).getParameter().getParameterName(), (Authenticator)this.jwtAuthenticator);
            parameterClient.setSupportGetRequest(((Jwt)this.config).isSupportGetRequest());
            parameterClient.setSupportPostRequest(((Jwt)this.config).isSupportPostRequest());
            this.afterClientInitialized((BaseClient<Credentials>)parameterClient, ((Jwt)this.config).getParameter());
            return parameterClient;
        }
    }
}

