/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.converter.mapper.PropertyMapper;
import com.buession.core.utils.EnumUtils;
import com.buession.core.validator.Validate;
import com.buession.springboot.pac4j.autoconfigure.AbstractPac4jClientConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import com.buession.springboot.pac4j.config.OAuth;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.oauth.client.BitbucketClient;
import org.pac4j.oauth.client.CasOAuthWrapperClient;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FigShareClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.HiOrgServerClient;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.client.OkClient;
import org.pac4j.oauth.client.PayPalClient;
import org.pac4j.oauth.client.QQClient;
import org.pac4j.oauth.client.StravaClient;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.VkClient;
import org.pac4j.oauth.client.WechatClient;
import org.pac4j.oauth.client.WeiboClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.WordPressClient;
import org.pac4j.oauth.client.YahooClient;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
@ConditionalOnClass(value={OAuth10Client.class, OAuth20Client.class})
@ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(value={Pac4jConfiguration.class})
public class Pac4jOAuthConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={Pac4jProperties.class})
    static class Pac4JOAuthClientConfiguration
    extends AbstractPac4jClientConfiguration<OAuth> {
        public Pac4JOAuthClientConfiguration(Pac4jProperties properties) {
            super(properties, properties.getClient().getOAuth());
        }

        @Bean(name={"bitbucketClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"bitbucket.enabled"}, havingValue="true")
        public BitbucketClient bitbucketClient() {
            BitbucketClient bitbucketClient = new BitbucketClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth10Client((OAuth10Client)bitbucketClient, ((OAuth)this.config).getBitbucket(), propertyMapper);
            return bitbucketClient;
        }

        @Bean(name={"twitterClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"twitter.enabled"}, havingValue="true")
        public TwitterClient twitterClient() {
            TwitterClient twitterClient = new TwitterClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            twitterClient.setAlwaysConfirmAuthorization(((OAuth)this.config).getTwitter().isAlwaysConfirmAuthorization());
            twitterClient.setIncludeEmail(((OAuth)this.config).getTwitter().isIncludeEmail());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth10Client((OAuth10Client)twitterClient, ((OAuth)this.config).getTwitter(), propertyMapper);
            return twitterClient;
        }

        @Bean(name={"yahooClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"yahoo.enabled"}, havingValue="true")
        public YahooClient yahooClient() {
            YahooClient yahooClient = new YahooClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth10Client((OAuth10Client)yahooClient, ((OAuth)this.config).getYahoo(), propertyMapper);
            return yahooClient;
        }

        @Bean(name={"genericOAuth20Client"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"generic.enabled"}, havingValue="true")
        public GenericOAuth20Client genericOAuth20Client() {
            GenericOAuth20Client genericOAuth20Client = new GenericOAuth20Client();
            genericOAuth20Client.setKey(((OAuth)this.config).getKey());
            genericOAuth20Client.setSecret(((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getAuthUrl()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setAuthUrl(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getTokenUrl()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setTokenUrl(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getProfileUrl()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setProfileUrl(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getProfilePath()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setProfileNodePath(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getProfileId()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setProfileId(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getClientAuthenticationMethod()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setClientAuthenticationMethod(arg_0));
            propertyMapper.from((Object)((OAuth)this.config).getGeneric().getProfileVerb()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setProfileVerb(arg_0));
            propertyMapper.from(((OAuth)this.config).getGeneric().getProfileAttrs()).to(arg_0 -> ((GenericOAuth20Client)genericOAuth20Client).setProfileAttrs(arg_0));
            this.initOAuth20Client((OAuth20Client)genericOAuth20Client, ((OAuth)this.config).getGeneric(), propertyMapper);
            return genericOAuth20Client;
        }

        @Bean(name={"casOAuthWrapperClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"cas.enabled"}, havingValue="true")
        public CasOAuthWrapperClient casOAuthWrapperClient() {
            CasOAuthWrapperClient casOAuthWrapperClient = new CasOAuthWrapperClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret(), ((OAuth)this.config).getCas().getCasOAuthUrl());
            casOAuthWrapperClient.setSpringSecurityCompliant(((OAuth)this.config).getCas().isSpringSecurityCompliant());
            casOAuthWrapperClient.setImplicitFlow(((OAuth)this.config).getCas().isImplicitFlow());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)casOAuthWrapperClient, ((OAuth)this.config).getCas(), propertyMapper);
            propertyMapper.from((Object)((OAuth)this.config).getCas().getCasLogoutUrl()).to(arg_0 -> ((CasOAuthWrapperClient)casOAuthWrapperClient).setCasLogoutUrl(arg_0));
            return casOAuthWrapperClient;
        }

        @Bean(name={"dropboxClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"dropbox.enabled"}, havingValue="true")
        public DropBoxClient dropboxClient() {
            DropBoxClient dropboxClient = new DropBoxClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)dropboxClient, ((OAuth)this.config).getDropBox(), propertyMapper);
            return dropboxClient;
        }

        @Bean(name={"facebookClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"facebook.enabled"}, havingValue="true")
        public FacebookClient facebookClient() {
            FacebookClient facebookClient = new FacebookClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            facebookClient.setFields(((OAuth)this.config).getFacebook().getFields());
            facebookClient.setLimit(((OAuth)this.config).getFacebook().getLimit());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)facebookClient, ((OAuth)this.config).getFacebook(), propertyMapper);
            return facebookClient;
        }

        @Bean(name={"figShareClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"fig-share.enabled"}, havingValue="true")
        public FigShareClient figShareClient() {
            FigShareClient figShareClient = new FigShareClient();
            figShareClient.setKey(((OAuth)this.config).getKey());
            figShareClient.setSecret(((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)figShareClient, ((OAuth)this.config).getFigShare(), propertyMapper);
            return figShareClient;
        }

        @Bean(name={"foursquareClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"foursquare.enabled"}, havingValue="true")
        public FoursquareClient foursquareClient() {
            FoursquareClient foursquareClient = new FoursquareClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)foursquareClient, ((OAuth)this.config).getFoursquare(), propertyMapper);
            return foursquareClient;
        }

        @Bean(name={"githubClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"github.enabled"}, havingValue="true")
        public GitHubClient githubClient() {
            GitHubClient gitHubClient = new GitHubClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)gitHubClient, ((OAuth)this.config).getGitHub(), propertyMapper);
            return gitHubClient;
        }

        @Bean(name={"google2Client"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"google2.enabled"}, havingValue="true")
        public Google2Client google2Client() {
            Google2Client google2Client = new Google2Client(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)google2Client, ((OAuth)this.config).getGoogle2(), propertyMapper);
            propertyMapper.from(((OAuth)this.config).getGoogle2()::getScope).as(v -> (Google2Client.Google2Scope)EnumUtils.getEnumIgnoreCase(Google2Client.Google2Scope.class, (String)v)).to(arg_0 -> ((Google2Client)google2Client).setScope(arg_0));
            return google2Client;
        }

        @Bean(name={"google2Client"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"google2.enabled"}, havingValue="true")
        public HiOrgServerClient hiOrgServerClient() {
            HiOrgServerClient hiOrgServerClient = new HiOrgServerClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)hiOrgServerClient, ((OAuth)this.config).getHiOrgServer(), propertyMapper);
            return hiOrgServerClient;
        }

        @Bean(name={"linkedin2Client"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"linkedin2.enabled"}, havingValue="true")
        public LinkedIn2Client linkedin2Client() {
            LinkedIn2Client linkedIn2Client = new LinkedIn2Client(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)linkedIn2Client, ((OAuth)this.config).getLinkedIn2(), propertyMapper);
            return linkedIn2Client;
        }

        @Bean(name={"okClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"ok.enabled"}, havingValue="true")
        public OkClient okClient() {
            OkClient okClient = new OkClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret(), ((OAuth)this.config).getOk().getPublicKey());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)okClient, ((OAuth)this.config).getOk(), propertyMapper);
            return okClient;
        }

        @Bean(name={"paypalClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"paypal.enabled"}, havingValue="true")
        public PayPalClient paypalClient() {
            PayPalClient payPalClient = new PayPalClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)payPalClient, ((OAuth)this.config).getPayPal(), propertyMapper);
            return payPalClient;
        }

        @Bean(name={"qqClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"qq.enabled"}, havingValue="true")
        public QQClient qqClient() {
            QQClient qqClient = new QQClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)qqClient, ((OAuth)this.config).getQq(), propertyMapper);
            if (Validate.isNotEmpty(((OAuth)this.config).getQq().getScopes())) {
                qqClient.setScopes(((OAuth)this.config).getQq().getScopes());
            }
            return qqClient;
        }

        @Bean(name={"stravaClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"strava.enabled"}, havingValue="true")
        public StravaClient stravaClient() {
            StravaClient stravaClient = new StravaClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)stravaClient, ((OAuth)this.config).getStrava(), propertyMapper);
            propertyMapper.from(((OAuth)this.config).getStrava()::getApprovalPrompt).to(arg_0 -> ((StravaClient)stravaClient).setApprovalPrompt(arg_0));
            return stravaClient;
        }

        @Bean(name={"vkClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"vk.enabled"}, havingValue="true")
        public VkClient vkClient() {
            VkClient vkClient = new VkClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)vkClient, ((OAuth)this.config).getVk(), propertyMapper);
            return vkClient;
        }

        @Bean(name={"weiboClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"weibo.enabled"}, havingValue="true")
        public WeiboClient weiboClient() {
            WeiboClient weiboClient = new WeiboClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)weiboClient, ((OAuth)this.config).getWeibo(), propertyMapper);
            propertyMapper.from(((OAuth)this.config).getWeibo()::getScope).as(v -> (WeiboClient.WeiboScope)EnumUtils.getEnumIgnoreCase(WeiboClient.WeiboScope.class, (String)v)).to(arg_0 -> ((WeiboClient)weiboClient).setScope(arg_0));
            return weiboClient;
        }

        @Bean(name={"wechatClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"wechat.enabled"}, havingValue="true")
        public WechatClient wechatClient() {
            WechatClient wechatClient = new WechatClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)wechatClient, ((OAuth)this.config).getWechat(), propertyMapper);
            if (Validate.isNotEmpty(((OAuth)this.config).getWechat().getScopes())) {
                wechatClient.setScopes(((OAuth)this.config).getWechat().getScopes());
            }
            return wechatClient;
        }

        @Bean(name={"windowsLiveClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"windows-live.enabled"}, havingValue="true")
        public WindowsLiveClient windowsLiveClient() {
            WindowsLiveClient windowsLiveClient = new WindowsLiveClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)windowsLiveClient, ((OAuth)this.config).getWindowsLive(), propertyMapper);
            return windowsLiveClient;
        }

        @Bean(name={"wordpressClient"})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.pac4j.client.oauth", name={"word-press.enabled"}, havingValue="true")
        public WordPressClient wordPressClient() {
            WordPressClient wordPressClient = new WordPressClient(((OAuth)this.config).getKey(), ((OAuth)this.config).getSecret());
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenHasText();
            this.initOAuth20Client((OAuth20Client)wordPressClient, ((OAuth)this.config).getWordPress(), propertyMapper);
            return wordPressClient;
        }

        protected void initOAuth10Client(OAuth10Client client, OAuth.BaseOAuth10Config config, PropertyMapper propertyMapper) {
            OAuth10Configuration configuration = client.getConfiguration();
            propertyMapper.from(((OAuth)this.config)::getCallbackUrl).to(arg_0 -> ((OAuth10Client)client).setCallbackUrl(arg_0));
            propertyMapper.from(config::getResponseType).to(arg_0 -> ((OAuth10Configuration)configuration).setResponseType(arg_0));
            propertyMapper.from(config::getScope).to(arg_0 -> ((OAuth10Configuration)configuration).setScope(arg_0));
            configuration.setTokenAsHeader(config.isTokenAsHeader());
            this.afterClientInitialized((BaseClient<Credentials>)client, config);
        }

        protected void initOAuth20Client(OAuth20Client client, OAuth.BaseOAuth20Config config, PropertyMapper propertyMapper) {
            OAuth20Configuration configuration = client.getConfiguration();
            propertyMapper.from(((OAuth)this.config)::getCallbackUrl).to(arg_0 -> ((OAuth20Client)client).setCallbackUrl(arg_0));
            propertyMapper.from(config::getResponseType).to(arg_0 -> ((OAuth20Configuration)configuration).setResponseType(arg_0));
            propertyMapper.from(config::getScope).to(arg_0 -> ((OAuth20Configuration)configuration).setScope(arg_0));
            propertyMapper.from(config::getCustomParameters).to(arg_0 -> ((OAuth20Configuration)configuration).setCustomParams(arg_0));
            configuration.setWithState(config.isWithState());
            configuration.setTokenAsHeader(config.isTokenAsHeader());
            configuration.setTokenAsHeader(config.isTokenAsHeader());
            this.afterClientInitialized((BaseClient<Credentials>)client, config);
        }
    }
}

