/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.pac4j.autoconfigure;

import com.buession.core.utils.StringUtils;
import com.buession.core.validator.Validate;
import com.buession.springboot.pac4j.autoconfigure.Pac4jConfiguration;
import com.buession.springboot.pac4j.autoconfigure.Pac4jProperties;
import com.buession.springboot.pac4j.filter.Pac4jFilter;
import io.buji.pac4j.filter.CallbackFilter;
import io.buji.pac4j.filter.LogoutFilter;
import io.buji.pac4j.filter.SecurityFilter;
import javax.servlet.Filter;
import org.pac4j.core.config.Config;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Pac4jProperties.class})
@ConditionalOnProperty(prefix="spring.pac4j.filter", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={Pac4jConfiguration.class})
public class Pac4jWebFilterConfiguration {
    private final Pac4jProperties properties;
    private final Config config;

    public Pac4jWebFilterConfiguration(Pac4jProperties properties, ObjectProvider<Config> config) {
        this.properties = properties;
        this.config = (Config)config.getIfAvailable();
    }

    @Bean(name={"pac4jFilter"})
    @ConditionalOnMissingBean
    public Pac4jFilter pac4jFilter() {
        Pac4jFilter pac4jFilter = new Pac4jFilter();
        Pac4jProperties.Filter.Security securityConfig = this.properties.getFilter().getSecurity();
        pac4jFilter.addFilter(securityConfig.getName(), (Filter)this.securityFilter(securityConfig));
        Pac4jProperties.Filter.Callback callbackConfig = this.properties.getFilter().getCallback();
        pac4jFilter.addFilter(callbackConfig.getName(), (Filter)this.callbackFilter(callbackConfig));
        Pac4jProperties.Filter.Logout logoutConfig = this.properties.getFilter().getLogout();
        pac4jFilter.addFilter(logoutConfig.getName(), (Filter)this.logoutFilter(logoutConfig));
        return pac4jFilter;
    }

    private SecurityFilter securityFilter(Pac4jProperties.Filter.Security securityConfig) {
        SecurityFilter securityFilter = new SecurityFilter();
        securityFilter.setConfig(this.config);
        securityFilter.setMultiProfile(Boolean.valueOf(this.properties.isMultiProfile()));
        if (this.properties.getClients() != null) {
            securityFilter.setClients(StringUtils.join(this.properties.getClients(), (String)","));
        }
        if (Validate.isNotEmpty(securityConfig.getAuthorizers())) {
            securityFilter.setAuthorizers(StringUtils.join(securityConfig.getAuthorizers(), (String)","));
        }
        if (Validate.isNotEmpty(securityConfig.getMatchers())) {
            securityFilter.setMatchers(StringUtils.join(securityConfig.getMatchers(), (String)","));
        }
        return securityFilter;
    }

    private CallbackFilter callbackFilter(Pac4jProperties.Filter.Callback callbackConfig) {
        CallbackFilter callbackFilter = new CallbackFilter();
        callbackFilter.setConfig(this.config);
        callbackFilter.setDefaultUrl(callbackConfig.getDefaultUrl());
        callbackFilter.setMultiProfile(Boolean.valueOf(this.properties.isMultiProfile()));
        callbackFilter.setDefaultClient(this.properties.getDefaultClient());
        callbackFilter.setSaveInSession(Boolean.valueOf(this.properties.isSaveInSession()));
        return callbackFilter;
    }

    private LogoutFilter logoutFilter(Pac4jProperties.Filter.Logout logoutConfig) {
        LogoutFilter logoutFilter = new LogoutFilter();
        logoutFilter.setConfig(this.config);
        logoutFilter.setDefaultUrl(logoutConfig.getDefaultUrl());
        logoutFilter.setLogoutUrlPattern(logoutConfig.getLogoutUrlPattern());
        logoutFilter.setLocalLogout(Boolean.valueOf(logoutConfig.isLocalLogout()));
        logoutFilter.setCentralLogout(Boolean.valueOf(logoutConfig.isCentralLogout()));
        return logoutFilter;
    }
}

