/*
 * Decompiled with CFR 0.152.
 */
package org.butor.log4j;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.RolloverDescriptionImpl;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.rolling.helper.ActionBase;
import org.butor.log4j.TimeBasedRollingPolicyFromApacheLog4jExtras;

public class TimeBasedRollingPolicy
extends TimeBasedRollingPolicyFromApacheLog4jExtras {
    private Long timeDeltaForFilenameChange;
    private int maxBackupIndex = 0;
    private int numberOfBackupFilenamesToCheckForRegularCleanup = 24;
    private int numberOfExtraBackupFilenamesToCheckForFirstCleanup = 365;
    private boolean firstCleanupRan = false;

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public void setNumberOfBackupFilenamesToCheckForRegularCleanup(int numberOfBackupFilenamesToCheckForRegularCleanup) {
        this.numberOfBackupFilenamesToCheckForRegularCleanup = numberOfBackupFilenamesToCheckForRegularCleanup;
    }

    public void setNumberOfExtraBackupFilenamesToCheckForFirstCleanup(int numberOfExtraBackupFilenamesToCheckForFirstCleanup) {
        this.numberOfExtraBackupFilenamesToCheckForFirstCleanup = numberOfExtraBackupFilenamesToCheckForFirstCleanup;
    }

    @Override
    public RolloverDescription rollover(String currentActiveFile) {
        RolloverDescription rolloverDescription = super.rollover(currentActiveFile);
        if (rolloverDescription == null) {
            return null;
        }
        if (this.maxBackupIndex <= 0) {
            return rolloverDescription;
        }
        String activeFileName = rolloverDescription.getActiveFileName();
        boolean append = rolloverDescription.getAppend();
        Action synchronous = rolloverDescription.getSynchronous();
        final Action asynchronous = rolloverDescription.getAsynchronous();
        ActionBase newAsynchronous = new ActionBase(){

            public boolean execute() throws IOException {
                boolean success = true;
                if (asynchronous != null) {
                    success &= asynchronous.execute();
                }
                int searchFileCount = TimeBasedRollingPolicy.this.maxBackupIndex + TimeBasedRollingPolicy.this.numberOfBackupFilenamesToCheckForRegularCleanup;
                if (!TimeBasedRollingPolicy.this.firstCleanupRan) {
                    searchFileCount += TimeBasedRollingPolicy.this.numberOfExtraBackupFilenamesToCheckForFirstCleanup;
                }
                for (String backupFileToDelete : Iterables.skip((Iterable)TimeBasedRollingPolicy.this.getBackupFiles(searchFileCount), (int)TimeBasedRollingPolicy.this.maxBackupIndex)) {
                    success &= this.deleteFileWithoutSuffix(backupFileToDelete, "");
                    success &= this.deleteFileWithoutSuffix(backupFileToDelete, ".gz");
                    success &= this.deleteFileWithoutSuffix(backupFileToDelete, ".zip");
                }
                TimeBasedRollingPolicy.this.firstCleanupRan = true;
                return success;
            }

            private boolean deleteFileWithoutSuffix(String filename, String suffix) {
                File file;
                if (filename.endsWith(suffix) && (file = new File(filename.substring(0, filename.length() - suffix.length()))).exists()) {
                    return file.delete();
                }
                return true;
            }
        };
        return new RolloverDescriptionImpl(activeFileName, append, synchronous, (Action)newAsynchronous);
    }

    private Iterable<String> getBackupFiles(int searchFileCount) {
        long timeIncrement = -this.getTimeDeltaForFilenameChange() / 2L;
        if (timeIncrement == 0L) {
            return Collections.emptyList();
        }
        ArrayList backupFiles = Lists.newArrayList();
        for (String filename : this.getNextFilenames(searchFileCount, System.currentTimeMillis(), timeIncrement)) {
            backupFiles.add(filename);
        }
        return backupFiles;
    }

    private Iterable<String> getNextFilenames(int filenameCount, long fromTime, long timeIncrement) {
        LinkedHashSet nextFilenames = Sets.newLinkedHashSet();
        long time = fromTime;
        while (nextFilenames.size() < filenameCount) {
            nextFilenames.add(this.getFilename(time));
            time += timeIncrement;
        }
        return nextFilenames;
    }

    private long getTimeDeltaForFilenameChange() {
        if (this.timeDeltaForFilenameChange == null) {
            long nextTimeThatFilenameChange = this.findNextTimeThatFilenameChange(System.currentTimeMillis());
            long nextTimeThatFilenameChangeAgain = this.findNextTimeThatFilenameChange(nextTimeThatFilenameChange);
            long timeDelta = nextTimeThatFilenameChangeAgain - nextTimeThatFilenameChange;
            this.timeDeltaForFilenameChange = timeDelta;
        }
        return this.timeDeltaForFilenameChange;
    }

    private long findNextTimeThatFilenameChange(long baseTime) {
        String baseFilename = this.getFilename(baseTime);
        long lowerBound = baseTime;
        long delta = 1L;
        long upperBound = baseTime + delta;
        while (delta < 0x4000000000000000L && this.getFilename(upperBound).equals(baseFilename)) {
            lowerBound = upperBound;
            upperBound = baseTime + (delta <<= 1);
        }
        if (delta >= 0x4000000000000000L) {
            return baseTime;
        }
        while (upperBound - lowerBound > 1L) {
            long newBound = (lowerBound + upperBound) / 2L;
            if (this.getFilename(newBound).equals(baseFilename)) {
                lowerBound = newBound;
                continue;
            }
            upperBound = newBound;
        }
        return upperBound;
    }

    private String getFilename(long n) {
        StringBuffer buf = new StringBuffer();
        this.formatFileName(new Date(n), buf);
        return buf.toString();
    }
}

