/*
 * Decompiled with CFR 0.152.
 */
package com.butor.portal.web.ajax;

import com.butor.portal.common.userProfile.UserProfileServices;
import com.butor.portal.web.ajax.PortalAjaxCmp;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.butor.attrset.common.AttrSet;
import org.butor.auth.common.AuthServices;
import org.butor.json.JsonHelper;
import org.butor.json.service.Context;
import org.butor.json.service.ResponseHandler;
import org.butor.json.util.ContextBuilder;
import org.butor.utils.CommonDateFormat;
import org.butor.utils.Message;
import org.butor.web.servlet.AjaxContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PortalAjaxCmp
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private AuthServices authServices;
    private UserProfileServices profileServices;
    private String menuDefJson;
    private String appsDefJson;
    private String pagesDefJson;
    private Object menuDef;
    private Object appsDef;
    private Object pagesDef;

    public void getSetup(Context ctx) {
        ResponseHandler resp = ctx.getResponseHandler();
        AjaxContext ac = (AjaxContext)ctx;
        try {
            ArrayList funcs = new ArrayList();
            1 handler = new /* Unavailable Anonymous Inner Class!! */;
            String username = null;
            if (ac.getHttpServletRequest().getUserPrincipal() != null) {
                username = ac.getHttpServletRequest().getUserPrincipal().getName();
            }
            ac.getRequest().setUserId(username);
            Context sctx = new ContextBuilder().setCommonRequestArgs(ac.getRequest()).setResponseHandler((ResponseHandler)handler).build();
            HashMap<String, Object> result = new HashMap<String, Object>();
            this.authServices.listAuthFunc(sctx);
            result.put("funcs", funcs);
            result.put("menuDef", this.menuDef);
            result.put("appsDef", this.appsDef);
            result.put("pagesDef", this.pagesDef);
            resp.addRow(result);
        }
        catch (Exception ex) {
            resp.addMessage(new Message(0, Message.MessageType.ERROR, Throwables.getRootCause((Throwable)ex).toString()));
        }
    }

    public void getProfile(Context ctx) {
        ResponseHandler resp = ctx.getResponseHandler();
        AjaxContext ac = (AjaxContext)ctx;
        try {
            HashMap profile = new HashMap();
            2 handler = new /* Unavailable Anonymous Inner Class!! */;
            String username = null;
            if (ac.getHttpServletRequest().getUserPrincipal() != null) {
                username = ac.getHttpServletRequest().getUserPrincipal().getName();
            }
            ac.getRequest().setUserId(username);
            Context sctx = new ContextBuilder().setCommonRequestArgs(ac.getRequest()).setResponseHandler((ResponseHandler)handler).build();
            this.profileServices.readProfile(sctx);
            resp.addRow(profile);
        }
        catch (Exception ex) {
            resp.addMessage(new Message(0, Message.MessageType.ERROR, Throwables.getRootCause((Throwable)ex).toString()));
        }
    }

    public void updateProfileAttr(Context ctx, String key, String val) {
        ResponseHandler resp = ctx.getResponseHandler();
        AjaxContext ac = (AjaxContext)ctx;
        try {
            HashMap entry = new HashMap();
            3 handler = new /* Unavailable Anonymous Inner Class!! */;
            String username = null;
            if (ac.getHttpServletRequest().getUserPrincipal() != null) {
                username = ac.getHttpServletRequest().getUserPrincipal().getName();
            }
            ac.getRequest().setUserId(username);
            Context sctx = new ContextBuilder().setCommonRequestArgs(ac.getRequest()).setResponseHandler((ResponseHandler)handler).build();
            AttrSet attr = new AttrSet();
            attr.setType("user");
            attr.setId(username);
            attr.setK1(key);
            attr.setK2(".");
            attr.setValue(val);
            this.profileServices.updateAttr(sctx, attr);
            resp.addRow(entry);
        }
        catch (Exception ex) {
            resp.addMessage(new Message(0, Message.MessageType.ERROR, Throwables.getRootCause((Throwable)ex).toString()));
        }
    }

    public void deleteProfileAttr(Context ctx, String key) {
        ResponseHandler resp = ctx.getResponseHandler();
        AjaxContext ac = (AjaxContext)ctx;
        try {
            4 handler = new /* Unavailable Anonymous Inner Class!! */;
            String username = null;
            if (ac.getHttpServletRequest().getUserPrincipal() != null) {
                username = ac.getHttpServletRequest().getUserPrincipal().getName();
            }
            ac.getRequest().setUserId(username);
            Context sctx = new ContextBuilder().setCommonRequestArgs(ac.getRequest()).setResponseHandler((ResponseHandler)handler).build();
            AttrSet attr = new AttrSet();
            attr.setType("user");
            attr.setId(username);
            attr.setK1(key);
            attr.setK2(".");
            this.profileServices.deleteAttr(sctx, attr);
        }
        catch (Exception ex) {
            resp.addMessage(new Message(0, Message.MessageType.ERROR, Throwables.getRootCause((Throwable)ex).toString()));
        }
    }

    public void ping(Context ctx) {
        ResponseHandler resp = ctx.getResponseHandler();
        resp.addRow((Object)CommonDateFormat.YYYYMMDD_HHMMSS_WITHMS.format(new Date()));
    }

    public void afterPropertiesSet() throws Exception {
        this.logger.info("menuDefJson={}", (Object)this.menuDefJson);
        this.logger.info("appsDefJson={}", (Object)this.appsDefJson);
        this.logger.info("pagesDefJson={}", (Object)this.pagesDefJson);
        JsonHelper jsh = new JsonHelper();
        this.logger.info("Deserializing apps definitions JSON ...");
        this.appsDef = jsh.deserialize(this.appsDefJson, Object.class);
        this.logger.info("Deserializing pages definitions JSON ...");
        this.pagesDef = jsh.deserialize(this.pagesDefJson, Object.class);
        this.logger.info("Deserializing menu definition JSON ...");
        this.menuDef = jsh.deserialize(this.menuDefJson, Object.class);
    }

    public void setMenuDefJson(String menuDefJson) {
        this.menuDefJson = menuDefJson;
    }

    public void setAppsDefJson(String appsDefJson) {
        this.appsDefJson = appsDefJson;
    }

    public void setPagesDefJson(String pagesDefJson) {
        this.pagesDefJson = pagesDefJson;
    }

    public void setAuthServices(AuthServices authServices) {
        this.authServices = authServices;
    }

    public void setProfileServices(UserProfileServices profileServices) {
        this.profileServices = profileServices;
    }
}

