/*
 * Decompiled with CFR 0.152.
 */
package com.butor.portal.web.notif;

import com.butor.notif.DefaultNotifManager;
import com.butor.notif.NotifManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class NotifContextListener
implements ServletContextListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static DefaultNotifManager notifManager = null;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
            notifManager = (DefaultNotifManager)ctxt.getBean(DefaultNotifManager.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.warn("Failed while retrieving notification manager bean! Fix if you expecting notification to be enbaled!", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (notifManager != null) {
            notifManager.shutdown();
        }
    }

    public static NotifManager getNotifManager() {
        return notifManager;
    }
}

