/*
 * Decompiled with CFR 0.152.
 */
package com.butor.portal.web.notif;

import com.butor.portal.web.notif.NotifContextListener;
import com.butor.portal.web.notif.NotifSession;
import com.google.common.base.Throwables;
import java.io.EOFException;
import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifEndpoint
extends Endpoint {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        RemoteEndpoint.Basic remoteEndpointBasic = session.getBasicRemote();
        if (NotifContextListener.getNotifManager() == null) {
            this.logger.warn("Notification are not enabled! bye");
            try {
                session.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed closing session", (Throwable)e);
            }
            return;
        }
        NotifSession ns = new NotifSession(session.getId(), session.getUserPrincipal().getName(), remoteEndpointBasic);
        session.addMessageHandler((MessageHandler)ns);
        NotifContextListener.getNotifManager().addSession((com.butor.notif.NotifSession)ns);
    }

    public void onClose(Session session, CloseReason closeReason) {
        NotifContextListener.getNotifManager().removeSession(session.getId());
    }

    public void onError(Session session, Throwable thr) {
        Throwable root = Throwables.getRootCause((Throwable)thr);
        if (!(root instanceof EOFException)) {
            this.logger.error("onError: " + thr.toString(), thr);
        }
    }
}

