/*
 * Decompiled with CFR 0.152.
 */
package com.butor.portal.web.notif;

import com.butor.notif.AbstractNotifSession;
import com.google.common.base.Preconditions;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifSession
extends AbstractNotifSession
implements MessageHandler.Whole<String> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteEndpoint.Basic remoteEndpointBasic;

    public NotifSession(String id, String username, RemoteEndpoint.Basic remoteEndpointBasic) {
        super(id, username);
        this.remoteEndpointBasic = (RemoteEndpoint.Basic)Preconditions.checkNotNull((Object)remoteEndpointBasic);
    }

    public void onMessage(String serializedMessage) {
        super.handleClientMessage(serializedMessage);
    }

    public void sendToClient(String serializedMessage) {
        try {
            this.remoteEndpointBasic.sendText(serializedMessage);
        }
        catch (Exception e) {
            this.logger.warn("Failed while sending message to client!", (Throwable)e);
        }
    }
}

