/*
 * Decompiled with CFR 0.152.
 */
package com.butor.portal.web.servlet;

import com.google.api.client.util.IOUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WhiteLabelingServlet
extends HttpServlet {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = -4573847543526921509L;
    private Map<Pattern, String> wlMap;
    private String resDir;
    private String themesByDomain;
    private String defaultTheme = "default";
    private String applyCommonByDomain;

    public void init(ServletConfig config) {
        WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.themesByDomain = (String)Preconditions.checkNotNull((Object)((String)ctxt.getBean("wlThemesByDomain")), (Object)"Missing wlThemesByDomain spring bean!");
        this.defaultTheme = (String)Preconditions.checkNotNull((Object)((String)ctxt.getBean("wlDefaultTheme")), (Object)"Missing wlDefaultTheme spring bean!");
        this.applyCommonByDomain = (String)ctxt.getBean("wlApplyCommonByDomain");
        this.resDir = (String)Preconditions.checkNotNull((Object)((String)ctxt.getBean("wlResDir")), (Object)"Missing wlResDir spring bean!");
        this.wlMap = new HashMap();
        String[] tds = this.themesByDomain.split("\\|");
        if (tds != null) {
            for (String td : tds) {
                String[] toks = td.split(":");
                if (toks.length != 2) {
                    this.logger.error("Bad domain theme config! should be pattern:theme: " + td);
                }
                this.wlMap.put(Pattern.compile(toks[0]), toks[1]);
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] toks;
        String c = request.getParameter("c");
        String j = request.getParameter("j");
        String a = request.getParameter("a");
        String i = request.getParameter("i");
        String h = request.getParameter("h");
        String t = request.getParameter("t");
        String s = request.getServerName();
        if (Strings.isNullOrEmpty((String)t)) {
            for (Pattern p : this.wlMap.keySet()) {
                Matcher matcher = p.matcher(s);
                if (!matcher.find()) continue;
                t = (String)this.wlMap.get(p);
                break;
            }
        }
        if (t == null) {
            t = this.defaultTheme;
        }
        File comFile = null;
        File file = null;
        if (j != null) {
            t = t + "/j.js";
            comFile = new File(this.resDir, "theme/common/j.js");
            file = new File(this.resDir, "theme/" + t);
            response.setContentType("text/javascript");
        } else if (c != null) {
            t = t + "/c.css";
            comFile = new File(this.resDir, "theme/common/c.css");
            file = new File(this.resDir, "theme/" + t);
            response.setContentType("text/css");
        } else if (h != null) {
            t = t + "/" + this.extractFilename(h);
            file = new File(this.resDir, "theme/" + t);
            response.setContentType("text/html");
        } else if (a != null) {
            toks = (a = this.extractFilename(a)).split("\\.");
            if (toks.length == 0) {
                return;
            }
            file = new File(this.resDir, "avatar/" + a);
            response.setContentType("image/" + toks[toks.length - 1]);
        } else if (i != null) {
            toks = (i = this.extractFilename(i)).split("\\.");
            if (toks.length == 0) {
                return;
            }
            t = t + "/" + i;
            file = new File(this.resDir, "theme/" + t);
            response.setContentType("image/" + toks[toks.length - 1]);
        }
        if (comFile != null && comFile.exists()) {
            boolean applyCommon = true;
            if (!Strings.isNullOrEmpty((String)this.applyCommonByDomain)) {
                String[] hosts;
                applyCommon = false;
                block1: for (String host : hosts = this.applyCommonByDomain.split(",")) {
                    for (Pattern p : this.wlMap.keySet()) {
                        Matcher matcher = p.matcher(host);
                        if (!matcher.find()) continue;
                        applyCommon = true;
                        continue block1;
                    }
                }
            }
            if (applyCommon && comFile.exists()) {
                FileInputStream fis = new FileInputStream(comFile);
                IOUtils.copy((InputStream)fis, (OutputStream)response.getOutputStream());
                Closeables.close((Closeable)fis, (boolean)false);
            }
        }
        if (file != null && file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            IOUtils.copy((InputStream)fis, (OutputStream)response.getOutputStream());
            Closeables.close((Closeable)fis, (boolean)false);
        }
    }

    private String extractFilename(String name) {
        if (com.google.api.client.util.Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        int pos = (name = new File(name).getName()).indexOf("?");
        if (pos > -1) {
            name = name.substring(0, pos);
        }
        return name;
    }
}

