/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.progresso.log4j;

import com.carrotsearch.progresso.views.console.ConsoleAware;
import com.carrotsearch.progresso.views.console.ConsoleWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ThrowableProxy;

@Plugin(name="ProgressAwareAppender", category="Core", elementType="appender", printObject=false)
public class ProgressAwareAppender
extends AbstractAppender {
    private final ConsoleWriter consoleWriter = ConsoleAware.writer();
    private boolean printStackTraces = true;

    public ProgressAwareAppender(String name, Filter filter) {
        super(name, filter, null, true);
    }

    public boolean isPrintStackTraces() {
        return this.printStackTraces;
    }

    public void setPrintStackTraces(boolean printStackTraces) {
        this.printStackTraces = printStackTraces;
    }

    public void append(LogEvent event) {
        ThrowableProxy thrownProxy;
        StringBuilder builder = new StringBuilder("> ");
        if (event.getLevel().isMoreSpecificThan(Level.WARN)) {
            if (event.getLevel() == Level.WARN) {
                builder.append("[WARNING]: ");
            } else {
                builder.append("[").append(event.getLevel()).append("]: ");
            }
        }
        builder.append(event.getMessage().getFormattedMessage());
        if (this.printStackTraces && (thrownProxy = event.getThrownProxy()) != null) {
            builder.append(ConsoleWriter.LF);
            builder.append(thrownProxy.getCauseStackTraceAsString(""));
        }
        try {
            this.consoleWriter.printLine(builder.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @PluginFactory
    public static ProgressAwareAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="printStackTraces") boolean printStackTraces, @PluginElement(value="Filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided");
            return null;
        }
        ProgressAwareAppender progressAwareAppender = new ProgressAwareAppender(name, filter);
        progressAwareAppender.setPrintStackTraces(printStackTraces);
        return progressAwareAppender;
    }
}

