/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.asca;

import com.checkmarx.ast.asca.Error;
import com.checkmarx.ast.asca.ScanDetail;
import com.checkmarx.ast.utils.JsonParser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class ScanResult {
    private final String requestId;
    private final boolean status;
    private final String message;
    private final List<ScanDetail> scanDetails;
    private final Error error;

    @JsonCreator
    public ScanResult(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="status") boolean status, @JsonProperty(value="message") String message, @JsonProperty(value="scan_details") List<ScanDetail> scanDetails, @JsonProperty(value="error") Error error) {
        this.requestId = requestId;
        this.status = status;
        this.message = message;
        this.scanDetails = scanDetails;
        this.error = error;
    }

    public static <T> T fromLine(String line) {
        return JsonParser.parse(line, TypeFactory.defaultInstance().constructType(ScanResult.class));
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ScanDetail> getScanDetails() {
        return this.scanDetails;
    }

    public Error getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanResult)) {
            return false;
        }
        ScanResult other = (ScanResult)o;
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<ScanDetail> this$scanDetails = this.getScanDetails();
        List<ScanDetail> other$scanDetails = other.getScanDetails();
        if (this$scanDetails == null ? other$scanDetails != null : !((Object)this$scanDetails).equals(other$scanDetails)) {
            return false;
        }
        Error this$error = this.getError();
        Error other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStatus() ? 79 : 97);
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<ScanDetail> $scanDetails = this.getScanDetails();
        result = result * 59 + ($scanDetails == null ? 43 : ((Object)$scanDetails).hashCode());
        Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "ScanResult(super=" + super.toString() + ", requestId=" + this.getRequestId() + ", status=" + this.isStatus() + ", message=" + this.getMessage() + ", scanDetails=" + this.getScanDetails() + ", error=" + this.getError() + ")";
    }
}

