/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.codebashing;

import com.checkmarx.ast.predicate.Predicate;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class CodeBashing {
    private final String path;
    private final String cweId;
    private final String language;
    private final String queryName;

    @JsonCreator
    public CodeBashing(@JsonProperty(value="path") String path, @JsonProperty(value="cwe_id") String cweId, @JsonProperty(value="lang") String language, @JsonProperty(value="cxQueryName") String queryName) {
        this.path = path;
        this.cweId = cweId;
        this.language = language;
        this.queryName = queryName;
    }

    public static <T> T fromLine(String line) {
        return CodeBashing.parse(line, TypeFactory.defaultInstance().constructType(Predicate.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)CodeBashing.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, CodeBashing.class));
    }

    protected static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && CodeBashing.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getCweId() {
        return this.cweId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeBashing)) {
            return false;
        }
        CodeBashing other = (CodeBashing)o;
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$cweId = this.getCweId();
        String other$cweId = other.getCweId();
        if (this$cweId == null ? other$cweId != null : !this$cweId.equals(other$cweId)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$queryName = this.getQueryName();
        String other$queryName = other.getQueryName();
        return !(this$queryName == null ? other$queryName != null : !this$queryName.equals(other$queryName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $cweId = this.getCweId();
        result = result * 59 + ($cweId == null ? 43 : $cweId.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $queryName = this.getQueryName();
        result = result * 59 + ($queryName == null ? 43 : $queryName.hashCode());
        return result;
    }

    public String toString() {
        return "CodeBashing(path=" + this.getPath() + ", cweId=" + this.getCweId() + ", language=" + this.getLanguage() + ", queryName=" + this.getQueryName() + ")";
    }
}

