/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.remediation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class KicsRemediation {
    private final String availableRemediation;
    private final String appliedRemediation;

    @JsonCreator
    public KicsRemediation(@JsonProperty(value="available_remediation_count") String availableRemediation, @JsonProperty(value="applied_remediation_count") String appliedRemediation) {
        this.availableRemediation = availableRemediation;
        this.appliedRemediation = appliedRemediation;
    }

    public static <T> T fromLine(String line) {
        return KicsRemediation.parse(line, TypeFactory.defaultInstance().constructType(KicsRemediation.class));
    }

    private static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && KicsRemediation.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getAvailableRemediation() {
        return this.availableRemediation;
    }

    public String getAppliedRemediation() {
        return this.appliedRemediation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KicsRemediation)) {
            return false;
        }
        KicsRemediation other = (KicsRemediation)o;
        String this$availableRemediation = this.getAvailableRemediation();
        String other$availableRemediation = other.getAvailableRemediation();
        if (this$availableRemediation == null ? other$availableRemediation != null : !this$availableRemediation.equals(other$availableRemediation)) {
            return false;
        }
        String this$appliedRemediation = this.getAppliedRemediation();
        String other$appliedRemediation = other.getAppliedRemediation();
        return !(this$appliedRemediation == null ? other$appliedRemediation != null : !this$appliedRemediation.equals(other$appliedRemediation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $availableRemediation = this.getAvailableRemediation();
        result = result * 59 + ($availableRemediation == null ? 43 : $availableRemediation.hashCode());
        String $appliedRemediation = this.getAppliedRemediation();
        result = result * 59 + ($appliedRemediation == null ? 43 : $appliedRemediation.hashCode());
        return result;
    }

    public String toString() {
        return "KicsRemediation(availableRemediation=" + this.getAvailableRemediation() + ", appliedRemediation=" + this.getAppliedRemediation() + ")";
    }
}

