/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.results.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Node {
    private final String id;
    private final int line;
    private final String name;
    private final int column;
    private final int length;
    private final String method;
    private final int nodeId;
    private final String domType;
    private final String fileName;
    private final String fullName;
    private final String typeName;
    private final String methodLine;
    private final String definitions;

    public Node(@JsonProperty(value="id") String id, @JsonProperty(value="line") int line, @JsonProperty(value="name") String name, @JsonProperty(value="column") int column, @JsonProperty(value="length") int length, @JsonProperty(value="method") String method, @JsonProperty(value="nodeID") int nodeId, @JsonProperty(value="domType") String domType, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="fullName") String fullName, @JsonProperty(value="typeName") String typeName, @JsonProperty(value="methodLine") String methodLine, @JsonProperty(value="definitions") String definitions) {
        this.id = id;
        this.line = line;
        this.name = name;
        this.column = column;
        this.length = length;
        this.method = method;
        this.nodeId = nodeId;
        this.domType = domType;
        this.fileName = fileName;
        this.fullName = fullName;
        this.typeName = typeName;
        this.methodLine = methodLine;
        this.definitions = definitions;
    }

    public static <T> T fromLine(String line) {
        return Node.parse(line, TypeFactory.defaultInstance().constructType(Node.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)Node.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Node.class));
    }

    private static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && Node.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node node = (Node)obj;
        return this.line == node.line && this.column == node.column && this.length == node.length && Objects.equals(this.name, node.name) && Objects.equals(this.method, node.method) && Objects.equals(this.domType, node.domType) && Objects.equals(this.fileName, node.fileName) && Objects.equals(this.fullName, node.fullName) && Objects.equals(this.methodLine, node.methodLine);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public String getMethod() {
        return this.method;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getDomType() {
        return this.domType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getMethodLine() {
        return this.methodLine;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public String toString() {
        return "Node(id=" + this.getId() + ", line=" + this.getLine() + ", name=" + this.getName() + ", column=" + this.getColumn() + ", length=" + this.getLength() + ", method=" + this.getMethod() + ", nodeId=" + this.getNodeId() + ", domType=" + this.getDomType() + ", fileName=" + this.getFileName() + ", fullName=" + this.getFullName() + ", typeName=" + this.getTypeName() + ", methodLine=" + this.getMethodLine() + ", definitions=" + this.getDefinitions() + ")";
    }
}

