/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.metriccatcher;

import com.clearspring.metriccatcher.MetricCatcher;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.reporting.GangliaReporter;
import com.yammer.metrics.reporting.GraphiteReporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.jackson.map.util.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader {
    private static final Logger logger = LoggerFactory.getLogger(Loader.class);
    private static final String defaultPropertiesFilename = "conf/config.properties";
    private MetricCatcher metricCatcher;
    private static final String METRICCATCHER_INTERVAL = "metriccatcher.interval";
    private static final String METRICCATCHER_UDP_PORT = "metriccatcher.udp.port";
    private static final String METRICCATCHER_MAX_METRICS = "metriccatcher.maxMetrics";
    private static final String METRICCATCHER_GANGLIA_HOST = "metriccatcher.ganglia.host";
    private static final String METRICCATCHER_GANGLIA_PORT = "metriccatcher.ganglia.port";
    private static final String METRICCATCHER_GRAPHITE_HOST = "metriccatcher.graphite.host";
    private static final String METRICCATCHER_GRAPHITE_PORT = "metriccatcher.graphite.port";
    private static final String METRICCATCHER_GRAPHITE_PREFIX = "metriccatcher.graphite.prefix";
    private static final String METRICCATCHER_DISABLE_JVM_METRICS = "metriccatcher.disableJvmMetrics";

    public Loader(File propertiesFile) throws IOException {
        logger.info("Starting metriccatcher");
        logger.info("Loading configuration from: " + propertiesFile.getAbsolutePath());
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(propertiesFile));
            for (Object key : properties.keySet()) {
                System.setProperty((String)key, (String)properties.get(key));
            }
        }
        catch (IOException e) {
            logger.error("error reading properties file: " + e);
            System.exit(1);
        }
        int reportingInterval = 60;
        String intervalProperty = properties.getProperty(METRICCATCHER_INTERVAL);
        if (intervalProperty != null) {
            try {
                reportingInterval = Integer.parseInt(intervalProperty);
            }
            catch (NumberFormatException e) {
                logger.warn("Couldn't parse metriccatcher.interval setting", (Throwable)e);
            }
        }
        boolean disableJvmMetrics = false;
        String disableJvmProperty = properties.getProperty(METRICCATCHER_DISABLE_JVM_METRICS);
        if (disableJvmProperty != null && (disableJvmMetrics = BooleanUtils.toBoolean((String)disableJvmProperty))) {
            logger.info("Disabling JVM metric reporting");
        }
        String gangliaHost = properties.getProperty(METRICCATCHER_GANGLIA_HOST);
        String gangliaPort = properties.getProperty(METRICCATCHER_GANGLIA_PORT);
        if (gangliaHost != null && gangliaPort != null) {
            logger.info("Creating Ganglia reporter pointed at " + gangliaHost + ":" + gangliaPort);
            GangliaReporter gangliaReporter = new GangliaReporter(gangliaHost, Integer.parseInt(gangliaPort));
            gangliaReporter.printVMMetrics = !disableJvmMetrics;
            gangliaReporter.start((long)reportingInterval, TimeUnit.SECONDS);
        }
        String graphiteHost = properties.getProperty(METRICCATCHER_GRAPHITE_HOST);
        String graphitePort = properties.getProperty(METRICCATCHER_GRAPHITE_PORT);
        if (graphiteHost != null && graphitePort != null) {
            String graphitePrefix = properties.getProperty(METRICCATCHER_GRAPHITE_PREFIX);
            if (graphitePrefix == null) {
                graphitePrefix = InetAddress.getLocalHost().getHostName();
            }
            logger.info("Creating Graphite reporter pointed at " + graphiteHost + ":" + graphitePort + " with prefix '" + graphitePrefix + "'");
            GraphiteReporter graphiteReporter = new GraphiteReporter(graphiteHost, Integer.parseInt(graphitePort), StringUtils.trimToNull((String)graphitePrefix));
            graphiteReporter.printVMMetrics = !disableJvmMetrics;
            graphiteReporter.start((long)reportingInterval, TimeUnit.SECONDS);
        }
        int maxMetrics = Integer.parseInt(properties.getProperty(METRICCATCHER_MAX_METRICS, "500"));
        logger.info("Max metrics: " + maxMetrics);
        LRUMap lruMap = new LRUMap(10, maxMetrics);
        int port = Integer.parseInt(properties.getProperty(METRICCATCHER_UDP_PORT, "1420"));
        logger.info("Listening on UDP port " + port);
        DatagramSocket socket = new DatagramSocket(port);
        this.metricCatcher = new MetricCatcher(socket, (Map<String, Metric>)lruMap);
        this.metricCatcher.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Loader.this.shutdown();
            }
        });
    }

    public void shutdown() {
        logger.info("shutting down...");
        if (this.metricCatcher != null) {
            this.metricCatcher.shutdown();
        }
        try {
            this.metricCatcher.join(1000L);
        }
        catch (InterruptedException e) {
            logger.info("interrupted waiting for thread to shutdown, exiting...");
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)System.getProperty("log4j.configuration"));
        String propertiesFilename = defaultPropertiesFilename;
        for (int i = 0; i < args.length; ++i) {
            if (!"-c".equals(args[i])) continue;
            propertiesFilename = args[++i];
        }
        File propertiesFile = new File(propertiesFilename);
        Loader loader = new Loader(propertiesFile);
    }
}

