/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.metriccatcher;

import com.clearspring.metriccatcher.GaugeMetricImpl;
import com.clearspring.metriccatcher.JSONMetric;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricCatcher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MetricCatcher.class);
    AtomicBoolean shutdown = new AtomicBoolean();
    private ObjectMapper mapper = new ObjectMapper();
    private DatagramSocket socket;
    private Map<String, Metric> metricCache;

    public MetricCatcher(DatagramSocket socket, Map<String, Metric> metricCache) throws IOException {
        this.socket = socket;
        this.metricCache = metricCache;
    }

    @Override
    public void run() {
        byte[] data = new byte[24258];
        byte[] json = null;
        while (!this.shutdown.get()) {
            DatagramPacket received = new DatagramPacket(data, data.length);
            try {
                this.socket.receive(received);
                json = received.getData();
                if (logger.isDebugEnabled()) {
                    logger.debug("Got packet from " + received.getAddress() + ":" + received.getPort());
                    if (logger.isTraceEnabled()) {
                        String jsonString = new String(json);
                        logger.trace("JSON: " + jsonString);
                    }
                }
                TypeReference<List<JSONMetric>> typeRef = new TypeReference<List<JSONMetric>>(){};
                List jsonMetrics = (List)this.mapper.readValue(json, (TypeReference)typeRef);
                for (JSONMetric jsonMetric : jsonMetrics) {
                    if (!this.metricCache.containsKey(jsonMetric.getName())) {
                        logger.info("Creating new " + jsonMetric.getType().name() + " metric for '" + jsonMetric.getName() + "'");
                        Metric newMetric = this.createMetric(jsonMetric);
                        this.metricCache.put(jsonMetric.getName(), newMetric);
                    }
                    logger.debug("Updating " + (Object)((Object)jsonMetric.getType()) + " '" + jsonMetric.getName() + "' with <" + jsonMetric.getValue() + ">");
                    this.updateMetric(this.metricCache.get(jsonMetric.getName()), jsonMetric.getValue());
                }
            }
            catch (IOException e) {
                logger.warn("IO error: " + e);
                String jsonString = new String(json);
                logger.warn("JSON: " + jsonString);
            }
        }
        this.socket.close();
    }

    protected Metric createMetric(JSONMetric jsonMetric) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(jsonMetric.getName().split("\\.")));
        MetricName metricName = parts.size() >= 3 ? new MetricName(parts.remove(0), parts.remove(0), StringUtils.join(parts, (String)".")) : new MetricName(jsonMetric.getName(), "", "");
        Class<?> metricType = jsonMetric.getMetricClass();
        if (metricType == Gauge.class) {
            return Metrics.newGauge((MetricName)metricName, (Gauge)new GaugeMetricImpl());
        }
        if (metricType == Counter.class) {
            return Metrics.newCounter((MetricName)metricName);
        }
        if (metricType == Meter.class) {
            return Metrics.newMeter((MetricName)metricName, (String)jsonMetric.getName(), (TimeUnit)TimeUnit.MINUTES);
        }
        if (metricType == Histogram.class) {
            if (jsonMetric.getType().equals("biased")) {
                return Metrics.newHistogram((MetricName)metricName, (boolean)true);
            }
            return Metrics.newHistogram((MetricName)metricName, (boolean)false);
        }
        if (metricType == Timer.class) {
            return Metrics.newTimer((MetricName)metricName, (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        }
        return null;
    }

    protected void updateMetric(Metric metric, double value) {
        if (metric.getClass() == Gauge.class) {
            ((GaugeMetricImpl)metric).setValue((long)value);
        } else if (metric.getClass() == Counter.class) {
            if (value > 0.0) {
                ((Counter)metric).inc((long)value);
            } else if (value < 0.0) {
                ((Counter)metric).dec((long)value * -1L);
            } else {
                ((Counter)metric).clear();
            }
        } else if (metric.getClass() == Meter.class) {
            ((Meter)metric).mark((long)value);
        } else if (metric.getClass() == Histogram.class) {
            ((Histogram)metric).update((long)value);
        } else if (metric.getClass() == Timer.class) {
            ((Timer)metric).update((long)value, TimeUnit.MICROSECONDS);
        }
    }

    public void shutdown() {
        logger.info("Got shutdown signal");
        this.shutdown.set(true);
        logger.debug("Shutdown set");
        this.interrupt();
        logger.info("Done shutting down");
    }
}

