/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.cluster4j.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CloudMessage {
    private final Object data;
    private final Map<String, String> meta;
    private final String key;

    public CloudMessage(Object data, String key) {
        this.data = data;
        this.meta = new HashMap<String, String>();
        this.key = key;
    }

    public CloudMessage(Object data, String key, Map<String, String> meta) {
        this.data = data;
        this.meta = Collections.unmodifiableMap(meta);
        this.key = key;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public String getKey() {
        return this.key;
    }

    public CloudMessage withAttr(String attr, String value) {
        return CloudMessage.builder().from(this).withAttr(attr, value).build();
    }

    public String attr(String attr) {
        return this.meta.get(attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object data;
        private Map<String, String> meta = new HashMap<String, String>();
        private String key;

        public Builder from(CloudMessage msg) {
            this.data = msg.data;
            this.meta = new HashMap<String, String>(msg.meta);
            this.key = msg.getKey();
            return this;
        }

        public Builder withData(Object data) {
            this.data = data;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withAttr(String name, String value) {
            this.meta.put(name, value);
            return this;
        }

        public CloudMessage build() {
            return new CloudMessage(this.data, this.key, this.meta);
        }
    }
}

