/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.cluster4j.core;

import com.cloudimpl.cluster4j.core.CloudRouterDescriptor;
import com.cloudimpl.cluster4j.core.CloudUtil;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class CloudFunction {
    private final String functionType;
    private final String inputType;
    private final CloudRouterDescriptor routerDesc;

    public CloudFunction(String functionType, String inputType, CloudRouterDescriptor routerDesc) {
        this.functionType = functionType;
        this.inputType = inputType;
        this.routerDesc = routerDesc;
    }

    public String getFunctionType() {
        return this.functionType;
    }

    public String getInputType() {
        return this.inputType;
    }

    public CloudRouterDescriptor getRouterDesc() {
        return this.routerDesc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Class<? extends Function> functionType;
        private String inputType;
        private CloudRouterDescriptor routerDesc;

        public Builder withFunction(Class<? extends Function<?, ? extends Publisher>> functionType) {
            this.functionType = functionType;
            this.inputType = CloudUtil.extractGenericParameter(functionType, Function.class, 0).getName();
            return this;
        }

        public Builder withRouter(CloudRouterDescriptor routerDesc) {
            this.routerDesc = routerDesc;
            return this;
        }

        public CloudFunction build() {
            return new CloudFunction(this.functionType.getName(), this.inputType, this.routerDesc);
        }
    }
}

