/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.cluster4j.core;

import com.cloudimpl.cluster4j.core.CloudRouter;
import com.cloudimpl.cluster4j.core.CloudUtil;

public class CloudRouterDescriptor {
    private final String routerType;
    private final String loadBalancer;

    public CloudRouterDescriptor(String routerType, String loadBalancer) {
        this.routerType = routerType;
        this.loadBalancer = loadBalancer;
    }

    public Class<? extends CloudRouter> getRouterType() {
        return CloudUtil.classForName(this.routerType);
    }

    public String getLoadBalancer() {
        return this.loadBalancer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Class<? extends CloudRouter> routerType;
        private String loadBalancer;

        public Builder withRouterType(Class<? extends CloudRouter> routerType) {
            this.routerType = routerType;
            return this;
        }

        public Builder withLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public CloudRouterDescriptor build() {
            return new CloudRouterDescriptor(this.routerType.getName(), this.loadBalancer);
        }
    }
}

