/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.cluster4j.core;

import com.cloudimpl.cluster4j.core.CloudException;
import com.cloudimpl.cluster4j.core.CloudServiceException;
import com.cloudimpl.cluster4j.core.Injector;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public class CloudUtil {
    public static <T> T newInstance(Injector injector, Class<T> classType) {
        return injector.inject(classType);
    }

    public static <T> Class<T> classForName(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new CloudException(ex.getMessage());
        }
    }

    public static String getHostIpAddr() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            byte[] addr = localMachine.getAddress();
            Object ipaddr = "";
            for (int i = 0; i < addr.length; ++i) {
                if (i > 0) {
                    ipaddr = (String)ipaddr + ".";
                }
                ipaddr = (String)ipaddr + (addr[i] & 0xFF);
            }
            return ipaddr;
        }
        catch (UnknownHostException ex) {
            throw new CloudException(ex);
        }
    }

    public static <T> Class<T> extractGenericParameter(Class<?> parameterizedSubClass, Class<?> genericSuperClass, int pos) {
        HashMap mapping = new HashMap();
        Class klass = parameterizedSubClass;
        while (klass != null) {
            Type superType = klass.getGenericSuperclass();
            Type[] genericInterfaces = klass.getGenericInterfaces();
            for (int j = 0; j <= genericInterfaces.length; ++j) {
                Type type;
                Type type2 = type = j == 0 ? superType : genericInterfaces[j - 1];
                if (type instanceof ParameterizedType) {
                    ParameterizedType parType = (ParameterizedType)type;
                    Type rawType = parType.getRawType();
                    if (rawType.equals(genericSuperClass)) {
                        Type t = parType.getActualTypeArguments()[pos];
                        if (t instanceof Class) {
                            return (Class)t;
                        }
                        return (Class)mapping.get((TypeVariable)t);
                    }
                    TypeVariable<?>[] vars = ((GenericDeclaration)((Object)parType.getRawType())).getTypeParameters();
                    Type[] args = parType.getActualTypeArguments();
                    for (int i = 0; i < vars.length; ++i) {
                        if (args[i] instanceof Class) {
                            mapping.put(vars[i], (Class)args[i]);
                            continue;
                        }
                        mapping.put(vars[i], (Class)mapping.get((TypeVariable)args[i]));
                    }
                    klass = (Class)rawType;
                    continue;
                }
                klass = klass.getSuperclass();
            }
        }
        throw new CloudServiceException("template not found");
    }
}

