/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.cluster4j.core;

import com.cloudimpl.cluster4j.common.Pair;
import com.cloudimpl.cluster4j.core.Inject;
import com.cloudimpl.cluster4j.core.InjectException;
import com.cloudimpl.cluster4j.core.Named;
import com.cloudimpl.cluster4j.core.logger.ILogger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Injector {
    private final Map<Class<?>, Object> map;
    protected final Map<String, Object> nameBinds;

    public Injector() {
        this.map = new ConcurrentHashMap();
        this.nameBinds = new ConcurrentHashMap<String, Object>();
    }

    private Injector(Map<Class<?>, Object> map, Map<String, Object> nameBinds) {
        this.map = new ConcurrentHashMap(map);
        this.nameBinds = new ConcurrentHashMap<String, Object>(nameBinds);
    }

    public BindHolder bind(Class<?> cls) {
        return new BindHolder(cls, this);
    }

    public NamedBindHolder bind(String name) {
        return new NamedBindHolder(name, this);
    }

    public void nameBind(String name, Object value) {
        this.nameBinds.put(name, value);
    }

    public <T> T nameBind(String name) {
        return (T)this.nameBinds.get(name);
    }

    public Injector with(String name, Object value) {
        Injector injector = new Injector(this.map, this.nameBinds);
        injector.nameBind(name, value);
        return injector;
    }

    public <T> Injector with(Class<T> clazz, Object value) {
        Injector injector = new Injector(this.map, this.nameBinds);
        injector.bind(clazz).to(value);
        return injector;
    }

    public <T> T inject(Class<T> clazz) {
        try {
            Constructor constructor = this.getInjectableConstructorOrDefault(clazz);
            Class<?>[] paramTypes = constructor.getParameterTypes();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            Object returnObject = constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(this.getConstructorInjects(paramTypes, annotations));
            this.inject(returnObject);
            return returnObject;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new InjectException(ex);
        }
    }

    protected Object[] getConstructorInjects(Class<?>[] paramTypes, Annotation[][] annotations) {
        Object[] params = IntStream.range(0, paramTypes.length).mapToObj(i -> new Pair<Class, Annotation[]>(paramTypes[i], annotations[i])).map(tuple -> this.getInjectAnonValue((Pair<Class<?>, Annotation[]>)tuple)).collect(Collectors.toList()).toArray();
        return params;
    }

    public void inject(Object injectableObject) {
        this.injectMembers(injectableObject);
    }

    public <T> T getInjecterbleInstance(Class<? extends T> cls) {
        return (T)this.map.get(cls);
    }

    private void injectMembers(Object injectableObject) {
        for (Class<?> clazz = injectableObject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            Arrays.asList(fields).stream().filter(f -> this.isInjectable((Field)f)).forEach(f -> this.injectMember(injectableObject, (Field)f));
        }
    }

    private Constructor getInjectableConstructorOrDefault(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> injectableConstructor = Arrays.asList(constructors).stream().filter(constructor -> this.isInjectable((Constructor<?>)constructor)).findFirst().orElse(constructors[0]);
        return injectableConstructor;
    }

    protected boolean isInjectable(Field f) {
        Annotation[] annotations = f.getDeclaredAnnotations();
        return Arrays.stream(annotations).anyMatch(annotation -> annotation instanceof Inject);
    }

    protected boolean isInjectable(Constructor<?> constructor) {
        Annotation[] annotations = constructor.getDeclaredAnnotations();
        return Arrays.stream(annotations).anyMatch(annotation -> annotation instanceof Inject);
    }

    protected void injectMember(Object injectObject, Field field) {
        try {
            field.setAccessible(true);
            Class<?> clazzType = field.getType();
            Object value = this.getInjectValue(clazzType, field);
            field.set(injectObject, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new InjectException(ex);
        }
    }

    protected <T> T getInjectValue(Class<T> clazz, Field field) {
        Object val;
        if (field != null && field.isAnnotationPresent(Named.class)) {
            Named named = field.getAnnotation(Named.class);
            val = this.nameBinds.get(named.value());
        } else {
            val = this.map.get(clazz);
        }
        if (val == null) {
            throw new InjectException("inject value not found for clazz " + clazz.getName());
        }
        return (T)val;
    }

    private Object getInjectAnonValue(Pair<Class<?>, Annotation[]> pair) {
        for (Annotation anno : pair.getValue()) {
            if (!(anno instanceof Named)) continue;
            Named named = (Named)anno;
            if (ILogger.class.isAssignableFrom(pair.getKey())) {
                String[] p = named.value().split("\\.");
                return ((ILogger)this.map.get(ILogger.class)).createSubLogger(p[0], p[1]);
            }
            if (this.nameBinds.get(named.value()) == null) {
                throw new InjectException("bind value for " + named.value() + " not found");
            }
            return this.nameBinds.get(named.value());
        }
        return this.getInjectValue(pair.getKey(), null);
    }

    public static final class NamedBindHolder {
        private final String name;
        private final Injector injector;

        protected NamedBindHolder(String name, Injector injector) {
            this.name = name;
            this.injector = injector;
        }

        public void to(Object value) {
            this.injector.nameBind(this.name, value);
        }
    }

    public static final class BindHolder {
        private final Class<?> clazz;
        private final Injector injector;

        protected BindHolder(Class<?> clazz, Injector injector) {
            this.clazz = clazz;
            this.injector = injector;
        }

        public void to(Object value) {
            this.injector.map.put(this.clazz, value);
        }
    }
}

