/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.taglib;

import com.cloudinary.Cloudinary;
import com.cloudinary.Singleton;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class CloudinaryJsConfigTag
extends SimpleTagSupport {
    public void doTag() throws JspException, IOException {
        Cloudinary cloudinary = Singleton.getCloudinary();
        if (cloudinary == null) {
            throw new JspException("Cloudinary config could not be located");
        }
        JspWriter out = this.getJspContext().getOut();
        out.println("<script language='javascript' type='text/javascript'>$.cloudinary.config({");
        String[] keys = new String[]{"api_key", "cloud_name", "cdn_subdomain"};
        String[] boolKeys = new String[]{"private_cdn", "secure_distribution"};
        for (String key : keys) {
            if (cloudinary.getStringConfig(key) == null || cloudinary.getStringConfig(key).isEmpty()) continue;
            out.println(key + ": \"" + cloudinary.getStringConfig(key) + "\",");
        }
        for (String key : boolKeys) {
            if (cloudinary.getStringConfig(key) == null || cloudinary.getStringConfig(key).isEmpty()) continue;
            out.println(key + ": " + cloudinary.getStringConfig(key) + ",");
        }
        out.println("});</script>");
    }
}

