/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.taglib;

import com.cloudinary.Cloudinary;
import com.cloudinary.Singleton;
import com.cloudinary.Transformation;
import com.cloudinary.Uploader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class CloudinaryUploadTag
extends SimpleTagSupport {
    private String id = null;
    private String name = "file";
    private String extraClasses = null;
    private Boolean multiple = false;
    private String tags = null;
    protected String fieldName;
    private String resourceType = "auto";
    private String transformation = null;
    private String eager = null;
    private String callback = null;
    private String publicId = null;
    private String format = null;
    private String notificationUrl = null;
    private String eagerNotificationUrl = null;
    private String proxy = null;
    private String folder = null;
    private String faceCoordinates = null;
    private String customCoordinates = null;
    private String allowedFormats = null;
    private String context = null;
    private String ocr = null;
    private String detection = null;
    private String categorization = null;
    private String similaritySearch = null;
    private String backgroundRemoval = null;
    private Float autoTagging = null;
    protected String uploadPreset = null;
    private Boolean backup = null;
    private Boolean exif = null;
    private Boolean faces = null;
    private Boolean colors = null;
    private Boolean imageMetadata = null;
    private Boolean useFilename = null;
    private Boolean uniqueFilename = null;
    private Boolean eagerAsync = null;
    private Boolean invalidate = null;
    private Boolean overwrite = null;
    private Boolean phash = null;
    protected boolean unsigned = false;

    public void doTag() throws JspException, IOException {
        Cloudinary cloudinary = Singleton.getCloudinary();
        if (cloudinary == null) {
            throw new JspException("Cloudinary config could not be located");
        }
        Uploader uploader = cloudinary.uploader();
        HashMap<String, Object> htmlOptions = new HashMap<String, Object>();
        htmlOptions.put("type", "file");
        htmlOptions.put("name", this.name);
        htmlOptions.put("multiple", this.multiple);
        htmlOptions.put("class", this.extraClasses);
        htmlOptions.put("id", this.id);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("resource_type", this.resourceType);
        options.put("transformation", this.transformation);
        options.put("eager", this.buildEager());
        options.put("tags", this.tags);
        options.put("callback", this.callback);
        options.put("public_id", this.publicId);
        options.put("format", this.format);
        options.put("notification_url", this.notificationUrl);
        options.put("eager_notification_url", this.eagerNotificationUrl);
        options.put("proxy", this.proxy);
        options.put("folder", this.folder);
        options.put("backup", this.backup);
        options.put("exif", this.exif);
        options.put("faces", this.faces);
        options.put("colors", this.colors);
        options.put("image_metadata", this.imageMetadata);
        options.put("use_filename", this.useFilename);
        options.put("unique_filename", this.uniqueFilename);
        options.put("eager_async", this.eagerAsync);
        options.put("invalidate", this.invalidate);
        options.put("face_coordinates", this.faceCoordinates);
        options.put("custom_coordinates", this.customCoordinates);
        options.put("allowed_formats", this.allowedFormats);
        options.put("context", this.context);
        options.put("overwrite", this.overwrite);
        options.put("phash", this.phash);
        options.put("ocr", this.ocr);
        options.put("detection", this.detection);
        options.put("categorization", this.categorization);
        options.put("similarity_search", this.similaritySearch);
        options.put("auto_tagging", this.autoTagging);
        options.put("background_removal", this.backgroundRemoval);
        options.put("upload_preset", this.uploadPreset);
        options.put("unsigned", this.unsigned);
        this.buildCallbackUrl(options);
        this.getJspContext().getOut().println(this.uploadTag(uploader, options, htmlOptions));
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExtraClasses(String extraClasses) {
        this.extraClasses = extraClasses;
    }

    public String getExtraClasses() {
        return this.extraClasses;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation.replaceAll("\\s+", "/");
    }

    public String getTransformation() {
        return this.transformation;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public Boolean getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    public String getEager() {
        return this.eager;
    }

    public void setEager(String eager) {
        this.eager = eager.replaceAll("\\s+", "|");
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public String getEagerNotificationUrl() {
        return this.eagerNotificationUrl;
    }

    public void setEagerNotificationUrl(String eagerNotificationUrl) {
        this.eagerNotificationUrl = eagerNotificationUrl;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public boolean isExif() {
        return this.exif;
    }

    public void setExif(boolean exif) {
        this.exif = exif;
    }

    public boolean isFaces() {
        return this.faces;
    }

    public void setFaces(boolean faces) {
        this.faces = faces;
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        this.colors = colors;
    }

    public boolean isImageMetadata() {
        return this.imageMetadata;
    }

    public void setImageMetadata(boolean imageMetadata) {
        this.imageMetadata = imageMetadata;
    }

    public boolean isUseFilename() {
        return this.useFilename;
    }

    public void setUseFilename(boolean useFilename) {
        this.useFilename = useFilename;
    }

    public boolean isUniqueFilename() {
        return this.uniqueFilename;
    }

    public void setUniqueFilename(boolean uniqueFilename) {
        this.uniqueFilename = uniqueFilename;
    }

    public boolean isEagerAsync() {
        return this.eagerAsync;
    }

    public void setEagerAsync(boolean eagerAsync) {
        this.eagerAsync = eagerAsync;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public void setInvalidate(boolean invalidate) {
        this.invalidate = invalidate;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getFaceCoordinates() {
        return this.faceCoordinates;
    }

    public void setFaceCoordinates(String faceCoordinates) {
        this.faceCoordinates = faceCoordinates;
    }

    public String getCustomCoordinates() {
        return this.customCoordinates;
    }

    public void setCustomCoordinates(String customCoordinates) {
        this.customCoordinates = customCoordinates;
    }

    public String getAllowedFormats() {
        return this.allowedFormats;
    }

    public void setAllowedFormats(String allowedFormats) {
        this.allowedFormats = allowedFormats;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isPhash() {
        return this.phash;
    }

    public void setPhash(boolean phash) {
        this.phash = phash;
    }

    public String getOcr() {
        return this.ocr;
    }

    public void setOcr(String ocr) {
        this.ocr = ocr;
    }

    public String getDetection() {
        return this.detection;
    }

    public void setDetection(String detection) {
        this.detection = detection;
    }

    public String getCategorization() {
        return this.categorization;
    }

    public void setCategorization(String categorization) {
        this.categorization = categorization;
    }

    public String getSimilaritySearch() {
        return this.similaritySearch;
    }

    public void setSimilaritySearch(String similaritySearch) {
        this.similaritySearch = similaritySearch;
    }

    public String getBackgroundRemoval() {
        return this.backgroundRemoval;
    }

    public void setBackgroundRemoval(String backgroundRemoval) {
        this.backgroundRemoval = backgroundRemoval;
    }

    public Float getAutoTagging() {
        return this.autoTagging;
    }

    public void setAutoTagging(String autoTagging) {
        this.autoTagging = Float.valueOf(Float.parseFloat(autoTagging));
    }

    public String getUploadPreset() {
        return this.uploadPreset;
    }

    public void setUploadPreset(String uploadPreset) {
        this.uploadPreset = uploadPreset;
    }

    protected String uploadTag(Uploader uploader, Map options, Map htmlOptions) {
        return uploader.imageUploadTag(this.fieldName, options, htmlOptions);
    }

    private void buildCallbackUrl(Map options) {
        String callback = (String)options.get("callback");
        if (callback == null || callback.isEmpty()) {
            callback = Singleton.getCloudinary().getStringConfig("callback");
        }
        if (callback == null || callback.isEmpty()) {
            callback = "/cloudinary_cors.html";
        }
        if (!callback.matches("^https?://")) {
            PageContext context = (PageContext)this.getJspContext();
            HttpServletRequest request = (HttpServletRequest)context.getRequest();
            String callbackUrl = request.getScheme() + "://" + request.getServerName();
            if (request.getScheme().equals("https") && request.getServerPort() != 443 || request.getScheme().equals("http") && request.getServerPort() != 80) {
                callbackUrl = callbackUrl + ":" + request.getServerPort() + request.getContextPath();
            }
            callbackUrl = callbackUrl + callback;
            options.put("callback", callbackUrl);
        }
    }

    private List<Transformation> buildEager() {
        if (this.eager == null) {
            return null;
        }
        String[] raws = this.eager.split("\\|");
        ArrayList<Transformation> list = new ArrayList<Transformation>();
        for (String raw : raws) {
            list.add(new Transformation().rawTransformation(raw));
        }
        return list;
    }
}

