/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.taglib;

import com.cloudinary.Cloudinary;
import com.cloudinary.Singleton;
import com.cloudinary.StoredFile;
import com.cloudinary.Transformation;
import com.cloudinary.Url;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class CloudinaryUrl
extends SimpleTagSupport
implements DynamicAttributes {
    private String src = null;
    private StoredFile storedSrc = null;
    private String type = null;
    private String resourceType = null;
    private String format = null;
    private String transformation = null;
    private Boolean secure = null;
    private Boolean cdnSubdomain = null;
    private String namedTransformation = null;
    private Map<String, Object> tagAttrs = new HashMap<String, Object>();

    public void doTag() throws JspException, IOException {
        Cloudinary cloudinary = Singleton.getCloudinary();
        if (cloudinary == null) {
            throw new JspException("Cloudinary config could not be located");
        }
        JspWriter out = this.getJspContext().getOut();
        Url url = cloudinary.url();
        if (this.storedSrc != null) {
            url.source(this.storedSrc);
        } else {
            url.source(this.src);
        }
        Transformation baseTransformation = new Transformation().params(this.tagAttrs);
        if (this.namedTransformation != null) {
            baseTransformation.named(new String[]{this.namedTransformation});
        }
        url.transformation(baseTransformation.chain().rawTransformation(this.transformation));
        if (this.format != null) {
            url.format(this.format);
        }
        if (this.type != null) {
            url.type(this.type);
        }
        if (this.resourceType != null) {
            url.resourceType(this.resourceType);
        }
        if (this.secure != null) {
            url.secure(this.secure.booleanValue());
        } else if (Boolean.TRUE.equals(this.isSecureRequest())) {
            url.secure(true);
        }
        if (this.cdnSubdomain != null) {
            url.cdnSubdomain(this.cdnSubdomain.booleanValue());
        }
        out.println(url.generate());
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public StoredFile getStoredSrc() {
        return this.storedSrc;
    }

    public void setStoredSrc(StoredFile storedSrc) {
        this.storedSrc = storedSrc;
    }

    public String getSrc() {
        return this.src;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation.replaceAll("\\s", "/");
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Boolean getCdnSubdomain() {
        return this.cdnSubdomain;
    }

    public void setCdnSubdomain(Boolean cdnSubdomain) {
        this.cdnSubdomain = cdnSubdomain;
    }

    public String getNamed() {
        return this.namedTransformation;
    }

    public void setNamed(String namedTransformation) {
        this.namedTransformation = namedTransformation;
    }

    public void setDynamicAttribute(String uri, String name, Object value) throws JspException {
        this.tagAttrs.put(name, value);
    }

    private Boolean isSecureRequest() {
        PageContext context = (PageContext)this.getJspContext();
        if (context == null) {
            return null;
        }
        ServletRequest request = context.getRequest();
        return request.getScheme().equals("https");
    }
}

