/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Cloudinary;
import com.cloudinary.Transformation;
import com.cloudinary.Uploader;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractContextTest
extends MockableTest {
    private static final String CONTEXT_TAG = "context_tag_" + String.valueOf(System.currentTimeMillis()) + SUFFIX;
    public static final Map CONTEXT = ObjectUtils.asMap((Object[])new Object[]{"caption", "some c\u00e4ption", "alt", "alternativ\u00e8"});
    private Uploader uploader;
    @Rule
    public TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpClass() throws Exception {
        Cloudinary cloudinary = new Cloudinary();
        if (cloudinary.config.apiSecret == null) {
            System.err.println("Please setup environment for Upload test to run");
        }
    }

    private static Map uploadResource(String publicId) throws IOException {
        return new Cloudinary().uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", publicId, "tags", new String[]{SDK_TEST_TAG, CONTEXT_TAG}, "context", CONTEXT, "transformation", new Transformation().crop("scale").width((Object)10)}));
    }

    @AfterClass
    public static void tearDownClass() {
        Cloudinary cloudinary = new Cloudinary();
        try {
            cloudinary.api().deleteResourcesByTag(CONTEXT_TAG, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        this.uploader = this.cloudinary.uploader();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
    }

    @Test
    public void testExplicit() throws Exception {
        String publicId = "explicit_id" + SUFFIX;
        AbstractContextTest.uploadResource(publicId);
        Map differentContext = ObjectUtils.asMap((Object[])new Object[]{"caption", "different = caption", "alt2", "alt|alternative alternative"});
        Map result = this.uploader.explicit(publicId, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "context", differentContext}));
        Assert.assertEquals((String)"explicit API should return the new context", (Object)ObjectUtils.asMap((Object[])new Object[]{"custom", differentContext}), result.get("context"));
        ApiResponse resource = this.cloudinary.api().resource(publicId, ObjectUtils.asMap((Object[])new Object[]{"context", true}));
        Assert.assertEquals((String)"explicit API should replace the context", (Object)ObjectUtils.asMap((Object[])new Object[]{"custom", differentContext}), resource.get("context"));
    }

    @Test
    public void testAddContext() throws Exception {
        String publicId = "add_context_id" + SUFFIX;
        Map resource = AbstractContextTest.uploadResource(publicId);
        HashMap<String, String> context = new HashMap<String, String>((Map)((Map)resource.get("context")).get("custom"));
        context.put("caption", "new caption");
        Map result = this.uploader.addContext(ObjectUtils.asMap((Object[])new Object[]{"caption", "new caption"}), new String[]{publicId, "no-such-id"}, null);
        Assert.assertThat((String)"addContext should return a list of modified public IDs", (Object)((List)result.get("public_ids")), (Matcher)Matchers.contains((Object[])new String[]{publicId}));
        resource = this.cloudinary.api().resource(publicId, ObjectUtils.asMap((Object[])new Object[]{"context", true}));
        Assert.assertEquals((Object)ObjectUtils.asMap((Object[])new Object[]{"custom", context}), resource.get("context"));
    }

    @Test
    public void testRemoveAllContext() throws Exception {
        String publicId = "remove_context_id" + SUFFIX;
        AbstractContextTest.uploadResource(publicId);
        Map result = this.uploader.removeAllContext(new String[]{publicId, "no-such-id"}, null);
        Assert.assertThat((Object)((List)result.get("public_ids")), (Matcher)Matchers.contains((Object[])new String[]{publicId}));
        ApiResponse resource = this.cloudinary.api().resource(publicId, ObjectUtils.asMap((Object[])new Object[]{"context", true}));
        Assert.assertThat((Object)resource, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"context")));
    }
}

