/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Cloudinary;
import com.cloudinary.Search;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractSearchTest
extends MockableTest {
    @Rule
    public TestName currentTest = new TestName();
    private static final String SEARCH_TAG = "search_test_tag_" + SUFFIX;
    public static final String[] UPLOAD_TAGS = new String[]{SDK_TEST_TAG, SEARCH_TAG};
    private static final String SEARCH_TEST = "search_test_" + SUFFIX;
    private static final String SEARCH_TEST_1 = SEARCH_TEST + "_1";
    private static final String SEARCH_TEST_2 = SEARCH_TEST + "_2";
    private static String SEARCH_TEST_ASSET_ID_1;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Cloudinary cloudinary = new Cloudinary();
        Map options = ObjectUtils.asMap((Object[])new Object[]{"public_id", SEARCH_TEST, "tags", UPLOAD_TAGS, "context", "stage=in_review"});
        cloudinary.api().deleteResourcesByTag(SEARCH_TAG, null);
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        options = ObjectUtils.asMap((Object[])new Object[]{"public_id", SEARCH_TEST_1, "tags", UPLOAD_TAGS, "context", "stage=new"});
        SEARCH_TEST_ASSET_ID_1 = cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options).get("asset_id").toString();
        options = ObjectUtils.asMap((Object[])new Object[]{"public_id", SEARCH_TEST_2, "tags", UPLOAD_TAGS, "context", "stage=validated"});
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Cloudinary cloudinary = new Cloudinary();
        cloudinary.api().deleteResourcesByTag(SEARCH_TAG, null);
    }

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
    }

    @Test
    public void shouldFindResourcesByTag() throws Exception {
        ApiResponse result = this.cloudinary.search().expression(String.format("tags:%s", SEARCH_TAG)).execute();
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)3L, (long)resources.size());
    }

    @Test
    public void shouldFindResourceByPublicId() throws Exception {
        ApiResponse result = this.cloudinary.search().expression(String.format("public_id:%s", SEARCH_TEST_1)).execute();
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
    }

    @Test
    public void shouldFindResourceByAssetId() throws Exception {
        ApiResponse result = this.cloudinary.search().expression(String.format("asset_id:%s", SEARCH_TEST_ASSET_ID_1)).execute();
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
    }

    @Test
    public void testShouldNotDuplicateValues() throws Exception {
        Field[] fields;
        Search request = this.cloudinary.search().maxResults(Integer.valueOf(1)).sortBy("created_at", "asc").sortBy("created_at", "desc").sortBy("public_id", "asc").aggregate("format").aggregate("format").aggregate("resource_type").withField("context").withField("context").withField("tags");
        for (Field field : fields = Search.class.getDeclaredFields()) {
            HashSet testSet;
            if (field.getName() == "aggregateParam") {
                field.setAccessible(true);
                ArrayList aggregateList = (ArrayList)field.get(request);
                testSet = new HashSet(aggregateList);
                Assert.assertTrue((aggregateList.size() == testSet.size() ? 1 : 0) != 0);
            }
            if (field.getName() == "withFieldParam") {
                field.setAccessible(true);
                ArrayList withFieldList = (ArrayList)field.get(request);
                testSet = new HashSet(withFieldList);
                Assert.assertTrue((withFieldList.size() == testSet.size() ? 1 : 0) != 0);
            }
            if (field.getName() != "sortByParam") continue;
            field.setAccessible(true);
            ArrayList sortByList = (ArrayList)field.get(request);
            testSet = new HashSet(sortByList);
            Assert.assertTrue((sortByList.size() == testSet.size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldPaginateResourcesLimitedByTagAndOrderdByAscendingPublicId() throws Exception {
        ApiResponse result = this.cloudinary.search().maxResults(Integer.valueOf(1)).expression(String.format("tags:%s", SEARCH_TAG)).sortBy("public_id", "asc").execute();
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)3, result.get("total_count"));
        Assert.assertEquals((Object)SEARCH_TEST, ((Map)resources.get(0)).get("public_id"));
        result = this.cloudinary.search().maxResults(Integer.valueOf(1)).expression(String.format("tags:%s", SEARCH_TAG)).sortBy("public_id", "asc").nextCursor(ObjectUtils.asString(result.get("next_cursor"))).execute();
        resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)3, result.get("total_count"));
        Assert.assertEquals((Object)SEARCH_TEST_1, ((Map)resources.get(0)).get("public_id"));
        result = this.cloudinary.search().maxResults(Integer.valueOf(1)).expression(String.format("tags:%s", SEARCH_TAG)).sortBy("public_id", "asc").nextCursor(ObjectUtils.asString(result.get("next_cursor"))).execute();
        resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)3, result.get("total_count"));
        Assert.assertEquals((Object)SEARCH_TEST_2, ((Map)resources.get(0)).get("public_id"));
        Assert.assertNull(result.get("next_cursor"));
    }
}

