/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.Transformation;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.AlreadyExists;
import com.cloudinary.api.exceptions.NotFound;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractStreamingProfilesApiTest
extends MockableTest {
    private static final String PROFILE_NAME = "api_test_streaming_profile" + SUFFIX;
    protected Api api;
    private static final List<String> PREDEFINED_PROFILES = Arrays.asList("4k", "full_hd", "hd", "sd", "full_hd_wifi", "full_hd_lean", "hd_lean");
    public static final String UPDATE_PROFILE_NAME = PROFILE_NAME + "_update";
    public static final String DELETE_PROFILE_NAME = PROFILE_NAME + "_delete";
    public static final String CREATE_PROFILE_NAME = PROFILE_NAME + "_create";
    @Rule
    public TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpClass() throws IOException {
        Cloudinary cloudinary = new Cloudinary();
        if (cloudinary.config.apiSecret == null) {
            System.err.println("Please setup environment for Upload test to run");
        }
    }

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
        this.api = this.cloudinary.api();
    }

    @Test
    public void testCreate() throws Exception {
        ApiResponse result = this.api.createStreamingProfile(CREATE_PROFILE_NAME, null, Collections.singletonList(ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().crop("limit").width((Object)1200).height((Object)1200).bitRate("5m")})), ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)result.containsKey((Object)"data"));
        Map profile = (Map)result.get((Object)"data");
        Assert.assertThat((Object)profile, (Matcher)Matchers.hasEntry((Object)"name", (Object)CREATE_PROFILE_NAME));
    }

    @Test
    public void testGet() throws Exception {
        ApiResponse result = this.api.getStreamingProfile(PREDEFINED_PROFILES.get(0));
        Assert.assertTrue((boolean)result.containsKey((Object)"data"));
        Map profile = (Map)result.get((Object)"data");
        Assert.assertThat((Object)profile, (Matcher)Matchers.hasEntry((Object)"name", (Object)PREDEFINED_PROFILES.get(0)));
    }

    @Test
    public void testList() throws Exception {
        ApiResponse result = this.api.listStreamingProfiles();
        Assert.assertTrue((boolean)result.containsKey((Object)"data"));
        List profiles = (List)result.get((Object)"data");
        for (String p : PREDEFINED_PROFILES) {
            Assert.assertThat((Object)profiles, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"name", (Object)p)));
        }
    }

    @Test
    public void testDelete() throws Exception {
        try {
            this.api.createStreamingProfile(DELETE_PROFILE_NAME, null, Collections.singletonList(ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().crop("limit").width((Object)1200).height((Object)1200).bitRate("5m")})), ObjectUtils.emptyMap());
        }
        catch (AlreadyExists alreadyExists) {
            // empty catch block
        }
        ApiResponse result = this.api.deleteStreamingProfile(DELETE_PROFILE_NAME);
        Assert.assertEquals((Object)"deleted", (Object)result.get((Object)"message"));
    }

    @Test
    public void testUpdate() throws Exception {
        try {
            this.api.createStreamingProfile(UPDATE_PROFILE_NAME, null, Collections.singletonList(ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().crop("limit").width((Object)1200).height((Object)1200).bitRate("5m")})), ObjectUtils.emptyMap());
        }
        catch (AlreadyExists alreadyExists) {
            // empty catch block
        }
        ApiResponse result = this.api.updateStreamingProfile(UPDATE_PROFILE_NAME, null, Collections.singletonList(ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().crop("limit").width((Object)800).height((Object)800).bitRate("5m")})), ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)result.containsKey("data"));
        Assert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Object)"message", (Object)"updated"));
        Map profile = (Map)result.get("data");
        Assert.assertThat((Object)profile, (Matcher)Matchers.hasEntry((Object)"name", (Object)UPDATE_PROFILE_NAME));
        Assert.assertThat((Object)profile, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"representations"), (Matcher)Matchers.hasItem((Matcher)Matchers.hasKey((Object)"transformation"))));
        Map representation = (Map)((List)profile.get("representations")).get(0);
        Map transformation = (Map)((List)representation.get("transformation")).get(0);
        Assert.assertThat((Object)transformation, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"width", (Object)800), (Matcher)Matchers.hasEntry((Object)"height", (Object)800), (Matcher)Matchers.hasEntry((Object)"crop", (Object)"limit"), (Matcher)Matchers.hasEntry((Object)"bit_rate", (Object)"5m")));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Api api = new Cloudinary().api();
        try {
            api.deleteStreamingProfile(CREATE_PROFILE_NAME);
        }
        catch (NotFound notFound) {
            // empty catch block
        }
        try {
            api.deleteStreamingProfile(UPDATE_PROFILE_NAME);
        }
        catch (NotFound notFound) {
            // empty catch block
        }
        try {
            api.deleteStreamingProfile(DELETE_PROFILE_NAME);
        }
        catch (NotFound notFound) {
            // empty catch block
        }
    }
}

