/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Cloudinary;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.provisioning.Account;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;

public abstract class AbstractAccountApiTest
extends MockableTest {
    private static Random rand = new Random();
    protected Account account;
    private static Set<String> createdSubAccountIds = new HashSet<String>();
    private static Set<String> createdUserIds = new HashSet<String>();
    private static Set<String> createdGroupIds = new HashSet<String>();
    @Rule
    public TestName currentTest = new TestName();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setUpClass() {
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.account = new Account(new Cloudinary());
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("Start TearDownClass");
        Account account = new Account(new Cloudinary());
        for (String createdSubAccountId : createdSubAccountIds) {
            try {
                account.deleteSubAccount(createdSubAccountId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String userId : createdUserIds) {
            try {
                account.deleteUser(userId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String groupId : createdGroupIds) {
            try {
                account.deleteUserGroup(groupId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("### Deleted - SubAccounts:" + createdSubAccountIds.size() + ", Users:" + createdUserIds.size() + ", UserGroups:" + createdGroupIds.size());
    }

    @Test
    public void testPassingCredentialsThroughOptions() throws Exception {
        int exceptions = 0;
        Map<String, Object> map = Collections.singletonMap("provisioning_api_secret", new Object());
        try {
            this.account.subAccounts(Boolean.valueOf(true), null, null, map);
        }
        catch (IllegalArgumentException ignored) {
            ++exceptions;
        }
        map = Collections.singletonMap("provisioning_api_key", new Object());
        try {
            this.account.subAccounts(Boolean.valueOf(true), null, null, map);
        }
        catch (IllegalArgumentException ignored) {
            ++exceptions;
        }
        map = new HashMap<String, Object>();
        map.put("provisioning_api_key", "abc");
        map.put("provisioning_api_secret", "def");
        try {
            this.account.subAccounts(Boolean.valueOf(true), null, null, map);
        }
        catch (Exception ex) {
            TestCase.assertTrue((boolean)ex.getMessage().contains("Invalid credentials"));
            ++exceptions;
        }
        Assert.assertEquals((long)3L, (long)exceptions);
    }

    @Test
    public void testGetSubAccount() throws Exception {
        ApiResponse accountResponse = this.createSubAccount();
        ApiResponse account = this.account.subAccount(accountResponse.get((Object)"id").toString(), null);
        Assert.assertNotNull((Object)account);
    }

    @Test
    public void testGetSubAccounts() throws Exception {
        this.createSubAccount();
        ApiResponse accounts = this.account.subAccounts(null, null, null, null);
        Assert.assertNotNull((Object)accounts);
        TestCase.assertTrue((((ArrayList)accounts.get((Object)"sub_accounts")).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSubAccount() throws Exception {
        ApiResponse result = this.createSubAccount();
        Assert.assertNotNull((Object)result);
        String message = "";
        try {
            this.account.createSubAccount(AbstractAccountApiTest.randomLetters(), null, Collections.emptyMap(), true, "non-existing-id", null);
        }
        catch (Exception ex) {
            message = ex.getMessage();
        }
        TestCase.assertTrue((boolean)message.contains("cannot find sub account"));
    }

    @Test
    public void testUpdateSubAccount() throws Exception {
        ApiResponse subAccount = this.createSubAccount();
        String newCloudName = AbstractAccountApiTest.randomLetters();
        ApiResponse result = this.account.updateSubAccount(subAccount.get((Object)"id").toString(), null, newCloudName, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.get((Object)"cloud_name"), (Object)newCloudName);
    }

    @Test
    public void testDeleteSubAccount() throws Exception {
        ApiResponse createResult = this.createSubAccount();
        String id = createResult.get((Object)"id").toString();
        ApiResponse result = this.account.deleteSubAccount(id, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.get((Object)"message"), (Object)"ok");
        createdSubAccountIds.remove(id);
    }

    @Test
    public void testGetUser() throws Exception {
        ApiResponse user = this.createUser();
        String userId = user.get((Object)"id").toString();
        ApiResponse result = this.account.user(userId, null);
        Assert.assertNotNull((Object)result);
        this.deleteUser(userId);
    }

    @Test
    public void testGetUsers() throws Exception {
        String user1Id = this.createUser(Account.Role.MASTER_ADMIN).get((Object)"id").toString();
        String user2Id = this.createUser(Account.Role.MASTER_ADMIN).get((Object)"id").toString();
        ApiResponse result = this.account.users(null, Arrays.asList(user1Id, user2Id), null, null, null);
        Assert.assertNotNull((Object)result);
        ArrayList users = (ArrayList)result.get((Object)"users");
        ArrayList<String> returnedIds = new ArrayList<String>(2);
        Assert.assertEquals((String)"Should return two users", (long)2L, (long)users.size());
        returnedIds.add(((Map)users.get(0)).get("id").toString());
        returnedIds.add(((Map)users.get(1)).get("id").toString());
        TestCase.assertTrue((String)"User1 id should be in the result set", (boolean)returnedIds.contains(user1Id));
        TestCase.assertTrue((String)"User2 id should be in the result set", (boolean)returnedIds.contains(user2Id));
        this.deleteUser(user1Id);
        this.deleteUser(user2Id);
    }

    @Test
    public void testGetPendingUsers() throws Exception {
        String id = this.createUser(Account.Role.BILLING).get((Object)"id").toString();
        ApiResponse pending = this.account.users(Boolean.valueOf(true), Collections.singletonList(id), null, null, null);
        Assert.assertEquals((long)1L, (long)((ArrayList)pending.get((Object)"users")).size());
        ApiResponse notPending = this.account.users(Boolean.valueOf(false), Collections.singletonList(id), null, null, null);
        Assert.assertEquals((long)0L, (long)((ArrayList)notPending.get((Object)"users")).size());
        ApiResponse all = this.account.users(null, Collections.singletonList(id), null, null, null);
        Assert.assertEquals((long)1L, (long)((ArrayList)all.get((Object)"users")).size());
    }

    @Test
    public void testGetUsersByPrefix() throws Exception {
        long timeMillis = System.currentTimeMillis();
        String userName = String.format("SDK TEST Get Users By Prefix %d", timeMillis);
        String userEmail = String.format("sdk-test-get-users-by-prefix+%d@cloudinary.com", timeMillis);
        this.createUser(userName, userEmail, Account.Role.BILLING, Collections.emptyList());
        ApiResponse userByPrefix = this.account.users(Boolean.valueOf(true), null, userName.substring(0, userName.length() - 1), null, null);
        Assert.assertEquals((long)1L, (long)((ArrayList)userByPrefix.get((Object)"users")).size());
        ApiResponse userByNonExistingPrefix = this.account.users(Boolean.valueOf(true), null, userName + "zzz", null, null);
        Assert.assertEquals((long)0L, (long)((ArrayList)userByNonExistingPrefix.get((Object)"users")).size());
    }

    @Test
    public void testGetUsersBySubAccountIds() throws Exception {
        ApiResponse subAccount = this.createSubAccount();
        String subAccountId = subAccount.get((Object)"id").toString();
        long timeMillis = System.currentTimeMillis();
        String userName = String.format("SDK TEST Get Users By Sub Account Ids %d", timeMillis);
        String userEmail = String.format("sdk-test-get-users-by-sub-account-ids+%d@cloudinary.com", timeMillis);
        this.createUser(userName, userEmail, Account.Role.BILLING, Collections.singletonList(subAccountId));
        ApiResponse usersBySubAccount = this.account.users(Boolean.valueOf(true), null, userName, subAccountId, null);
        Assert.assertEquals((long)1L, (long)((ArrayList)usersBySubAccount.get((Object)"users")).size());
    }

    @Test
    public void testGetUsersThrowsWhenSubAccountIdDoesntExist() throws Exception {
        String subAccountId = AbstractAccountApiTest.randomLetters();
        this.expectedException.expectMessage("Cannot find sub account with id " + subAccountId);
        this.account.users(Boolean.valueOf(true), null, null, subAccountId, null);
    }

    @Test
    public void testCreateUser() throws Exception {
        ApiResponse createResult = this.createSubAccount();
        ApiResponse result = this.createUser(Collections.singletonList(createResult.get((Object)"id").toString()));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testCreateUserWithOptions() throws Exception {
        ApiResponse createResult = this.createSubAccount();
        ApiResponse result = this.createUser(Collections.singletonList(createResult.get((Object)"id").toString()), ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testCreateUserEnabled() throws Exception {
        ApiResponse createResult = this.createSubAccount();
        ApiResponse result = this.createUser(Collections.singletonList(createResult.get((Object)"id").toString()), true);
        TestCase.assertTrue((boolean)((Boolean)result.get((Object)"enabled")));
    }

    @Test
    public void testCreateUserDisabled() throws Exception {
        ApiResponse createResult = this.createSubAccount();
        ApiResponse result = this.createUser(Collections.singletonList(createResult.get((Object)"id").toString()), false);
        Assert.assertFalse((boolean)((Boolean)result.get((Object)"enabled")));
    }

    @Test
    public void testUpdateUser() throws Exception {
        ApiResponse user = this.createUser(Account.Role.ADMIN);
        String userId = user.get((Object)"id").toString();
        String newName = AbstractAccountApiTest.randomLetters();
        ApiResponse result = this.account.updateUser(userId, newName, null, null, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.get((Object)"name"), (Object)newName);
        this.deleteUser(userId);
    }

    @Test
    public void testUpdateUserEnabled() throws Exception {
        ApiResponse user = this.createUser(Account.Role.ADMIN);
        String userId = user.get((Object)"id").toString();
        String newName = AbstractAccountApiTest.randomLetters();
        ApiResponse result = this.account.updateUser(userId, newName, null, null, Boolean.valueOf(true), null, null);
        Assert.assertNotNull((Object)result);
        TestCase.assertTrue((boolean)((Boolean)result.get((Object)"enabled")));
        this.deleteUser(userId);
    }

    @Test
    public void testUpdateUserDisabled() throws Exception {
        ApiResponse user = this.createUser(Account.Role.ADMIN);
        String userId = user.get((Object)"id").toString();
        String newName = AbstractAccountApiTest.randomLetters();
        ApiResponse result = this.account.updateUser(userId, newName, null, null, Boolean.valueOf(false), null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)((Boolean)result.get((Object)"enabled")));
        this.deleteUser(userId);
    }

    @Test
    public void testDeleteUser() throws Exception {
        ApiResponse user = this.createUser(Collections.emptyList());
        String id = user.get((Object)"id").toString();
        ApiResponse result = this.account.deleteUser(id, null);
        Assert.assertEquals((Object)result.get((Object)"message"), (Object)"ok");
        createdUserIds.remove(id);
    }

    @Test
    public void testCreateUserGroup() throws Exception {
        ApiResponse group = this.createGroup();
        Assert.assertNotNull((Object)group);
    }

    @Test
    public void testUpdateUserGroup() throws Exception {
        ApiResponse group = this.createGroup();
        String newName = AbstractAccountApiTest.randomLetters();
        ApiResponse result = this.account.updateUserGroup(group.get((Object)"id").toString(), newName, null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteUserGroup() throws Exception {
        ApiResponse group = this.createGroup();
        String id = group.get((Object)"id").toString();
        ApiResponse result = this.account.deleteUserGroup(id, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.get((Object)"ok"), (Object)true);
        createdGroupIds.remove(id);
    }

    @Test
    public void testAddUserToUserGroup() throws Exception {
        ApiResponse user = this.createUser();
        ApiResponse group = this.createGroup();
        String userId = user.get((Object)"id").toString();
        ApiResponse result = this.account.addUserToGroup(group.get((Object)"id").toString(), userId, null);
        Assert.assertNotNull((Object)result);
        this.deleteUser(userId);
    }

    @Test
    public void testRemoveUserFromUserGroup() throws Exception {
        ApiResponse user = this.createUser(Account.Role.MEDIA_LIBRARY_ADMIN);
        ApiResponse group = this.createGroup();
        String groupId = group.get((Object)"id").toString();
        String userId = user.get((Object)"id").toString();
        this.account.addUserToGroup(groupId, userId, null);
        ApiResponse result = this.account.removeUserFromGroup(groupId, userId, null);
        Assert.assertNotNull((Object)result);
        this.deleteUser(userId);
    }

    @Test
    public void testListUserGroups() throws Exception {
        this.createGroup();
        ApiResponse result = this.account.userGroups();
        Assert.assertNotNull((Object)result);
        TestCase.assertTrue((((List)result.get((Object)"user_groups")).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testListUserGroup() throws Exception {
        ApiResponse group = this.createGroup();
        ApiResponse result = this.account.userGroup(group.get((Object)"id").toString(), null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testListUsersInGroup() throws Exception {
        ApiResponse user1 = this.createUser();
        ApiResponse user2 = this.createUser();
        ApiResponse group = this.createGroup();
        String groupId = group.get((Object)"id").toString();
        String user1Id = user1.get((Object)"id").toString();
        String user2Id = user2.get((Object)"id").toString();
        this.account.addUserToGroup(groupId, user1Id, null);
        this.account.addUserToGroup(groupId, user2Id, null);
        ApiResponse result = this.account.userGroupUsers(groupId, null);
        Assert.assertNotNull((Object)result);
        TestCase.assertTrue((((List)result.get((Object)"users")).size() >= 2 ? 1 : 0) != 0);
        this.deleteUser(user1Id);
        this.deleteUser(user2Id);
    }

    private ApiResponse createGroup() throws Exception {
        String name = AbstractAccountApiTest.randomLetters();
        ApiResponse userGroup = this.account.createUserGroup(name);
        createdGroupIds.add(userGroup.get((Object)"id").toString());
        return userGroup;
    }

    private ApiResponse createUser() throws Exception {
        return this.createUser(Collections.emptyList());
    }

    private ApiResponse createUser(Account.Role role) throws Exception {
        return this.createUser(Collections.emptyList(), role);
    }

    private ApiResponse createUser(List<String> subAccountsIds) throws Exception {
        return this.createUser(subAccountsIds, Account.Role.BILLING);
    }

    private ApiResponse createUser(List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        return this.createUser(subAccountsIds, Account.Role.BILLING, options);
    }

    private ApiResponse createUser(List<String> subAccountsIds, Boolean enabled) throws Exception {
        return this.createUser(subAccountsIds, Account.Role.BILLING, enabled);
    }

    private ApiResponse createUser(List<String> subAccountsIds, Account.Role role) throws Exception {
        String email = String.format("%s@%s.com", AbstractAccountApiTest.randomLetters(), AbstractAccountApiTest.randomLetters());
        return this.createUser("TestName", email, role, subAccountsIds);
    }

    private ApiResponse createUser(List<String> subAccountsIds, Account.Role role, Map<String, Object> options) throws Exception {
        String email = String.format("%s@%s.com", AbstractAccountApiTest.randomLetters(), AbstractAccountApiTest.randomLetters());
        ApiResponse user = this.account.createUser("TestUserJava" + new Date().toString(), email, role, null, subAccountsIds, options);
        createdUserIds.add(user.get((Object)"id").toString());
        return user;
    }

    private ApiResponse createUser(List<String> subAccountsIds, Account.Role role, Boolean enabled) throws Exception {
        String email = String.format("%s@%s.com", AbstractAccountApiTest.randomLetters(), AbstractAccountApiTest.randomLetters());
        ApiResponse user = this.account.createUser("TestUserJava" + new Date().toString(), email, role, enabled, subAccountsIds, null);
        createdUserIds.add(user.get((Object)"id").toString());
        return user;
    }

    private ApiResponse createUser(String name, String email, Account.Role role, List<String> subAccountsIds) throws Exception {
        ApiResponse user = this.account.createUser(name, email, role, subAccountsIds, null);
        createdUserIds.add(user.get((Object)"id").toString());
        return user;
    }

    private void deleteUser(String userId) {
        try {
            this.account.deleteUser(userId, null);
            createdUserIds.remove(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ApiResponse createSubAccount() throws Exception {
        ApiResponse subAccount = this.account.createSubAccount(AbstractAccountApiTest.randomLetters(), null, Collections.emptyMap(), true, null);
        createdSubAccountIds.add(subAccount.get((Object)"id").toString());
        return subAccount;
    }

    private static String randomLetters() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append((char)(97 + rand.nextInt(26)));
        }
        return sb.toString();
    }
}

