/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.AccessControlRule;
import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.Coordinates;
import com.cloudinary.Transformation;
import com.cloudinary.Uploader;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.BadRequest;
import com.cloudinary.api.exceptions.NotFound;
import com.cloudinary.metadata.MetadataField;
import com.cloudinary.test.MetadataTestHelper;
import com.cloudinary.test.MockableTest;
import com.cloudinary.test.rules.RetryRule;
import com.cloudinary.transformation.AbstractLayer;
import com.cloudinary.transformation.TextLayer;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cloudinary.json.JSONArray;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsNot;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractApiTest
extends MockableTest {
    private static final String API_TEST = "api_test_" + SUFFIX;
    private static final String API_TEST_1 = API_TEST + "_1";
    private static final String API_TEST_2 = API_TEST + "_2";
    private static final String API_TEST_3 = API_TEST + "_3";
    private static final String API_TEST_5 = API_TEST + "_5";
    public static final String API_TEST_TRANSFORMATION = "api_test_transformation_" + SUFFIX;
    public static final String API_TEST_TRANSFORMATION_2 = API_TEST_TRANSFORMATION + "2";
    public static final String API_TEST_TRANSFORMATION_3 = API_TEST_TRANSFORMATION + "3";
    public static final String API_TEST_UPLOAD_PRESET = "api_test_upload_preset_" + SUFFIX;
    public static final String API_TEST_UPLOAD_PRESET_2 = API_TEST_UPLOAD_PRESET + "2";
    public static final String API_TEST_UPLOAD_PRESET_3 = API_TEST_UPLOAD_PRESET + "3";
    public static final String API_TEST_UPLOAD_PRESET_4 = API_TEST_UPLOAD_PRESET + "4";
    public static final String API_TAG = SDK_TEST_TAG + "_api";
    public static final String DIRECTION_TAG = SDK_TEST_TAG + "_api_resource_direction";
    public static final String[] UPLOAD_TAGS = new String[]{SDK_TEST_TAG, API_TAG};
    public static final String EXPLICIT_TRANSFORMATION_NAME = "c_scale,l_text:Arial_60:" + SUFFIX + ",w_100";
    public static final Transformation EXPLICIT_TRANSFORMATION = new Transformation().width((Object)100).crop("scale").overlay((AbstractLayer)new TextLayer().text(SUFFIX).fontFamily("Arial").fontSize(60));
    public static final String UPDATE_TRANSFORMATION_NAME = "c_scale,l_text:Arial_60:" + SUFFIX + "_update,w_100";
    public static final Transformation UPDATE_TRANSFORMATION = new Transformation().width((Object)100).crop("scale").overlay((AbstractLayer)new TextLayer().text(SUFFIX + "_update").fontFamily("Arial").fontSize(60));
    public static final String DELETE_TRANSFORMATION_NAME = "c_scale,l_text:Arial_60:" + SUFFIX + "_delete,w_100";
    public static final Transformation DELETE_TRANSFORMATION = new Transformation().width((Object)100).crop("scale").overlay((AbstractLayer)new TextLayer().text(SUFFIX + "_delete").fontFamily("Arial").fontSize(60));
    public static final String TEST_KEY = "test-key" + SUFFIX;
    public static final String API_TEST_RESTORE = "api_test_restore" + SUFFIX;
    public static final Set<String> createdFolders = new HashSet<String>();
    private static final String CUSTOM_USER_AGENT_PREFIX = "TEST_USER_AGENT";
    private static final String CUSTOM_USER_AGENT_VERSION = "9.9.9";
    private static String assetId1;
    private static String assetId2;
    private static final int SLEEP_TIMEOUT = 5000;
    protected Api api;
    @Rule
    public TestName currentTest = new TestName();
    @Rule
    public RetryRule retryRule = new RetryRule();

    @BeforeClass
    public static void setUpClass() throws IOException {
        Cloudinary cloudinary = new Cloudinary();
        if (cloudinary.config.apiSecret == null) {
            System.err.println("Please setup environment for Upload test to run");
            return;
        }
        ArrayList<String> uploadAndDirectionTag = new ArrayList<String>(Arrays.asList(UPLOAD_TAGS));
        uploadAndDirectionTag.add(DIRECTION_TAG);
        Map options = ObjectUtils.asMap((Object[])new Object[]{"public_id", API_TEST, "tags", uploadAndDirectionTag, "context", "key=value", "eager", Collections.singletonList(EXPLICIT_TRANSFORMATION)});
        assetId1 = cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options).get("asset_id").toString();
        options.put("public_id", API_TEST_1);
        assetId2 = cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options).get("asset_id").toString();
        options.remove("public_id");
        options.put("eager", Collections.singletonList(UPDATE_TRANSFORMATION));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        options.put("eager", Collections.singletonList(DELETE_TRANSFORMATION));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        String context1 = TEST_KEY + "=alt";
        String context2 = TEST_KEY + "=alternate";
        options = ObjectUtils.asMap((Object[])new Object[]{"public_id", "context_1" + SUFFIX, "tags", uploadAndDirectionTag, "context", context1});
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        options = ObjectUtils.asMap((Object[])new Object[]{"public_id", "context_2" + SUFFIX, "tags", uploadAndDirectionTag, "context", context2});
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
    }

    @AfterClass
    public static void tearDownClass() {
        Api api = new Cloudinary().api();
        try {
            api.deleteResourcesByTag(API_TAG, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteTransformation(API_TEST_TRANSFORMATION, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteTransformation(API_TEST_TRANSFORMATION_2, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteTransformation(API_TEST_TRANSFORMATION_3, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteUploadPreset(API_TEST_UPLOAD_PRESET, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_2, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_3, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_4, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (String folder : createdFolders) {
                api.deleteFolder(folder, ObjectUtils.emptyMap());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
        this.api = this.cloudinary.api();
    }

    public Map findByAttr(List<Map> elements, String attr, Object value) {
        for (Map element : elements) {
            if (!value.equals(element.get(attr))) continue;
            return element;
        }
        return null;
    }

    @Test
    public void testCustomUserAgent() throws Exception {
        this.cloudinary.setUserAgent(CUSTOM_USER_AGENT_PREFIX, CUSTOM_USER_AGENT_VERSION);
        ApiResponse results = this.api.ping(ObjectUtils.emptyMap());
    }

    @Test
    public void test01ResourceTypes() throws Exception {
        ApiResponse result = this.api.resourceTypes(ObjectUtils.emptyMap());
        List resource_types = (List)result.get("resource_types");
        Assert.assertThat((Object)resource_types, (Matcher)Matchers.hasItem((Object)"image"));
    }

    @Test
    public void test03ResourcesCursor() throws Exception {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("max_results", 1);
        ApiResponse result = this.api.resources(options);
        List resources = (List)result.get("resources");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertNotNull(result.get("next_cursor"));
        options.put("next_cursor", (Integer)result.get("next_cursor"));
        ApiResponse result2 = this.api.resources(options);
        List resources2 = (List)result2.get("resources");
        Assert.assertNotNull((Object)resources2);
        Assert.assertEquals((long)resources2.size(), (long)1L);
        Assert.assertNotSame(((Map)resources2.get(0)).get("public_id"), ((Map)resources.get(0)).get("public_id"));
    }

    @Test
    public void test04ResourcesByType() throws Exception {
        ApiResponse result = this.api.resources(ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "max_results", 10}));
        List resources = (List)result.get("resources");
        Assert.assertTrue((resources.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOAuthToken() {
        String message = "";
        try {
            this.api.resource(API_TEST, Collections.singletonMap("oauth_token", "not_a_real_token"));
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        Assert.assertTrue((boolean)message.contains("Invalid token"));
    }

    @Test
    public void test05ResourcesByPrefix() throws Exception {
        ApiResponse result = this.api.resources(ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "prefix", API_TEST, "tags", true, "context", true}));
        List resources = (List)result.get("resources");
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", (Object)API_TEST)));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", (Object)API_TEST_1)));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"public_id", (Object)API_TEST), Matchers.hasEntry((Object)"type", (Object)"upload")})));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"context", (Object)ObjectUtils.asMap((Object[])new Object[]{"custom", ObjectUtils.asMap((Object[])new Object[]{"key", "value"})}))));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"tags"), (Matcher)Matchers.hasItem((Object)API_TAG))));
    }

    @Test
    public void testResourcesListingDirection() throws Exception {
        ApiResponse result = this.api.resourcesByTag(DIRECTION_TAG, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "direction", "asc", "max_results", 500}));
        List resources = (List)result.get("resources");
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (Map resource : resources) {
            resourceIds.add((String)resource.get("public_id"));
        }
        result = this.api.resourcesByTag(DIRECTION_TAG, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "direction", -1, "max_results", 500}));
        List resourcesDesc = (List)result.get("resources");
        ArrayList<String> resourceIdsDesc = new ArrayList<String>();
        for (Map resource : resourcesDesc) {
            resourceIdsDesc.add((String)resource.get("public_id"));
        }
        Collections.reverse(resourceIds);
        Assert.assertEquals(resourceIds, resourceIdsDesc);
    }

    @Ignore
    public void testResourcesListingStartAt() throws Exception {
        Thread.sleep(2000L);
        Date startAt = new Date();
        Thread.sleep(2000L);
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
        ApiResponse listResources = this.api.resources(ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "start_at", startAt, "direction", "asc"}));
        List resources = (List)listResources.get((Object)"resources");
        Assert.assertEquals(response.get("public_id"), ((Map)resources.get(0)).get("public_id"));
    }

    @Test
    public void testTransformationsWithCursor() throws Exception {
        ApiResponse result;
        String name = "testTransformation" + SDK_TEST_TAG + System.currentTimeMillis();
        this.api.createTransformation(name, "c_scale,w_100", null);
        ArrayList transformations = new ArrayList();
        String next_cursor = null;
        do {
            result = this.api.transformations(ObjectUtils.asMap((Object[])new Object[]{"max_results", 500, "next_cursor", next_cursor}));
            transformations.addAll((List)result.get("transformations"));
        } while ((next_cursor = (String)result.get("next_cursor")) != null);
        Assert.assertThat(transformations, (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"name", (Object)("t_" + name))})));
    }

    @Test
    public void testResourcesByAssetIds() throws Exception {
        ApiResponse result = this.api.resourcesByAssetIDs(Arrays.asList(assetId1, assetId2), ObjectUtils.asMap((Object[])new Object[]{"tags", true, "context", true}));
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertNotNull((Object)this.findByAttr(resources, "public_id", API_TEST));
        Assert.assertNotNull((Object)this.findByAttr(resources, "public_id", API_TEST_1));
    }

    @Test
    public void testResourceByAssetId() throws Exception {
        ApiResponse result = this.api.resourceByAssetID(assetId1, ObjectUtils.asMap((Object[])new Object[]{"tags", true, "context", true}));
        Assert.assertEquals((Object)API_TEST, (Object)result.get("public_id").toString());
    }

    @Test
    public void testResourcesByPublicIds() throws Exception {
        ApiResponse result = this.api.resourcesByIds(Arrays.asList(API_TEST, API_TEST_1, "bogus"), ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "tags", true, "context", true}));
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertNotNull((Object)this.findByAttr(resources, "public_id", API_TEST));
        Assert.assertNotNull((Object)this.findByAttr(resources, "public_id", API_TEST_1));
        Assert.assertNotNull((Object)this.findByAttr((List)result.get("resources"), "context", ObjectUtils.asMap((Object[])new Object[]{"custom", ObjectUtils.asMap((Object[])new Object[]{"key", "value"})})));
        boolean found = false;
        for (Map r : resources) {
            ArrayList tags = (ArrayList)r.get("tags");
            found = found || tags.contains(API_TAG);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void test06ResourcesTag() throws Exception {
        ApiResponse result = this.api.resourcesByTag(API_TAG, ObjectUtils.asMap((Object[])new Object[]{"tags", true, "context", true, "max_results", 500}));
        Map resource = this.findByAttr((List)result.get("resources"), "public_id", API_TEST);
        Assert.assertNotNull((Object)resource);
        resource = this.findByAttr((List)result.get("resources"), "context", ObjectUtils.asMap((Object[])new Object[]{"custom", ObjectUtils.asMap((Object[])new Object[]{"key", "value"})}));
        Assert.assertNotNull((Object)resource);
        List resources = (List)result.get("resources");
        boolean found = false;
        for (Map r : resources) {
            ArrayList tags = (ArrayList)r.get("tags");
            found = found || tags.contains(API_TAG);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void test07ResourceMetadata() throws Exception {
        ApiResponse resource = this.api.resource(API_TEST, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)API_TEST, resource.get("public_id"));
        Assert.assertEquals((Object)3381, resource.get("bytes"));
        Assert.assertEquals((long)1L, (long)((List)resource.get("derived")).size());
    }

    @Test
    public void test08DeleteDerived() throws Exception {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", API_TEST_3, "tags", UPLOAD_TAGS, "eager", Collections.singletonList(new Transformation().width((Object)101).crop("scale"))}));
        ApiResponse resource = this.api.resource(API_TEST_3, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        List derived = (List)resource.get("derived");
        Assert.assertEquals((long)derived.size(), (long)1L);
        String derived_resource_id = (String)((Map)derived.get(0)).get("id");
        this.api.deleteDerivedResources(Collections.singletonList(derived_resource_id), ObjectUtils.emptyMap());
        resource = this.api.resource(API_TEST_3, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        derived = (List)resource.get("derived");
        Assert.assertEquals((long)derived.size(), (long)0L);
    }

    @Test
    public void testDeleteDerivedByTransformation() throws Exception {
        String public_id = "api_test_123" + SUFFIX;
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        transformations.add(new Transformation().angle(90));
        transformations.add(new Transformation().width((Object)120));
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", public_id, "tags", UPLOAD_TAGS, "eager", transformations}));
        ApiResponse resource = this.api.resource(public_id, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        List derived = (List)resource.get("derived");
        Assert.assertTrue((derived.size() == 2 ? 1 : 0) != 0);
        this.api.deleteDerivedByTransformation((Iterable)ObjectUtils.asArray((Object)public_id), ObjectUtils.asArray(transformations), ObjectUtils.emptyMap());
        resource = this.api.resource(public_id, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        derived = (List)resource.get("derived");
        Assert.assertTrue((derived.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetResourcesWithMetadata() throws Exception {
        String public_id = "api_,withMetadata" + SUFFIX;
        String fieldId = MetadataTestHelper.addFieldToAccount(this.api, (MetadataField)MetadataTestHelper.newFieldInstance("some_field" + SUFFIX)).get((Object)"external_id").toString();
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", public_id, "tags", UPLOAD_TAGS, "metadata", ObjectUtils.asMap((Object[])new Object[]{fieldId, "test"}), "moderation", "manual", "context", ObjectUtils.asMap((Object[])new Object[]{"name", "value"})}));
        ApiResponse result = this.api.resources(ObjectUtils.asMap((Object[])new Object[]{"metadata", false}));
        Assert.assertNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resources(ObjectUtils.asMap((Object[])new Object[]{"metadata", true}));
        Assert.assertNotNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByTag(UPLOAD_TAGS[0], ObjectUtils.asMap((Object[])new Object[]{"metadata", true}));
        Assert.assertNotNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByTag(UPLOAD_TAGS[0], ObjectUtils.asMap((Object[])new Object[]{"metadata", false}));
        Assert.assertNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByModeration("manual", "pending", ObjectUtils.asMap((Object[])new Object[]{"metadata", true}));
        Assert.assertNotNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByModeration("manual", "pending", ObjectUtils.asMap((Object[])new Object[]{"metadata", false}));
        Assert.assertNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByContext("name", "value", ObjectUtils.asMap((Object[])new Object[]{"metadata", true}));
        Assert.assertNotNull((Object)this.getMetadata(public_id, (Map)result));
        result = this.api.resourcesByContext("name", "value", ObjectUtils.asMap((Object[])new Object[]{"metadata", false}));
        Assert.assertNull((Object)this.getMetadata(public_id, (Map)result));
    }

    private Object getMetadata(String public_id, Map result) {
        Map resource = this.findByAttr((List)result.get("resources"), "public_id", public_id);
        return resource.get("metadata");
    }

    @Test(expected=NotFound.class)
    public void test09DeleteResources() throws Exception {
        String public_id = "api_,test3" + SUFFIX;
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", public_id, "tags", UPLOAD_TAGS}));
        ApiResponse resource = this.api.resource(public_id, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        this.api.deleteResources(Arrays.asList(public_id), ObjectUtils.emptyMap());
        this.api.resource(public_id, ObjectUtils.emptyMap());
    }

    @Test(expected=NotFound.class)
    public void test09aDeleteResourcesByPrefix() throws Exception {
        String public_id = SUFFIX + "_api_test_by_prefix";
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", public_id, "tags", UPLOAD_TAGS}));
        ApiResponse resource = this.api.resource(public_id, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        this.api.deleteResourcesByPrefix(public_id.substring(0, SUFFIX.length() + 10), ObjectUtils.emptyMap());
        this.api.resource(public_id, ObjectUtils.emptyMap());
    }

    @Test(expected=NotFound.class)
    public void test09aDeleteResourcesByTags() throws Exception {
        String tag = "api_test_tag_for_delete" + SUFFIX;
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", API_TEST + "_4", "tags", Collections.singletonList(tag)}));
        ApiResponse resource = this.api.resource(API_TEST + "_4", ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)resource);
        this.api.deleteResourcesByTag(tag, ObjectUtils.emptyMap());
        this.api.resource(API_TEST + "_4", ObjectUtils.emptyMap());
    }

    @Test
    public void test10Tags() throws Exception {
        ApiResponse result = this.api.tags(ObjectUtils.asMap((Object[])new Object[]{"max_results", 10}));
        List tags = (List)result.get("tags");
        Assert.assertNotNull((Object)tags);
        Assert.assertTrue((tags.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test11TagsPrefix() throws Exception {
        ApiResponse result = this.api.tags(ObjectUtils.asMap((Object[])new Object[]{"prefix", API_TAG.substring(0, API_TAG.length() - 1)}));
        List tags = (List)result.get("tags");
        Assert.assertThat((Object)tags, (Matcher)Matchers.hasItem((Object)API_TAG));
        result = this.api.tags(ObjectUtils.asMap((Object[])new Object[]{"prefix", "api_test_no_such_tag"}));
        tags = (List)result.get("tags");
        Assert.assertEquals((long)0L, (long)tags.size());
    }

    @Test
    public void test12Transformations() throws Exception {
        Transformation listTest = new Transformation().width((Object)25).crop("scale").overlay((AbstractLayer)new TextLayer().text(SUFFIX + "_testListTransformations").fontFamily("Arial").fontSize(60));
        this.preloadResource(ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "eager", Collections.singletonList(listTest)}));
        ApiResponse result = this.api.transformations(ObjectUtils.asMap((Object[])new Object[]{"max_results", 500}));
        Map transformation = this.findByAttr((List)result.get("transformations"), "name", listTest.generate());
        Assert.assertNotNull((Object)transformation);
        Assert.assertTrue((boolean)((Boolean)transformation.get("used")));
    }

    @Test
    public void test13TransformationMetadata() throws Exception {
        this.preloadResource(ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "eager", Collections.singletonList(EXPLICIT_TRANSFORMATION)}));
        ApiResponse transformation = this.api.transformation(EXPLICIT_TRANSFORMATION_NAME, ObjectUtils.asMap((Object[])new Object[]{"max_results", 500}));
        Assert.assertNotNull((Object)transformation);
        Assert.assertEquals((Object)new Transformation((List)transformation.get("info")).generate(), (Object)EXPLICIT_TRANSFORMATION.generate());
    }

    @Test
    public void test14TransformationUpdate() throws Exception {
        this.api.updateTransformation(UPDATE_TRANSFORMATION_NAME, ObjectUtils.asMap((Object[])new Object[]{"allowed_for_strict", true}), ObjectUtils.emptyMap());
        ApiResponse transformation = this.api.transformation(UPDATE_TRANSFORMATION_NAME, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)transformation);
        Assert.assertEquals(transformation.get("allowed_for_strict"), (Object)true);
        this.api.updateTransformation(UPDATE_TRANSFORMATION_NAME, ObjectUtils.asMap((Object[])new Object[]{"allowed_for_strict", false}), ObjectUtils.emptyMap());
        transformation = this.api.transformation(UPDATE_TRANSFORMATION_NAME, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)transformation);
        Assert.assertEquals(transformation.get("allowed_for_strict"), (Object)false);
    }

    @Test
    public void test15TransformationCreate() throws Exception {
        this.api.createTransformation(API_TEST_TRANSFORMATION, new Transformation().crop("scale").width((Object)102).generate(), ObjectUtils.emptyMap());
        ApiResponse transformation = this.api.transformation(API_TEST_TRANSFORMATION, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)transformation);
        Assert.assertEquals(transformation.get("allowed_for_strict"), (Object)true);
        Assert.assertEquals((Object)new Transformation((List)transformation.get("info")).generate(), (Object)new Transformation().crop("scale").width((Object)102).generate());
        Assert.assertEquals(transformation.get("used"), (Object)false);
    }

    @Test
    public void test15aTransformationUnsafeUpdate() throws Exception {
        this.api.createTransformation(API_TEST_TRANSFORMATION_3, new Transformation().crop("scale").width((Object)102).generate(), ObjectUtils.emptyMap());
        this.api.updateTransformation(API_TEST_TRANSFORMATION_3, ObjectUtils.asMap((Object[])new Object[]{"unsafe_update", new Transformation().crop("scale").width((Object)103).generate()}), ObjectUtils.emptyMap());
        ApiResponse transformation = this.api.transformation(API_TEST_TRANSFORMATION_3, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)transformation);
        Assert.assertEquals((Object)new Transformation((List)transformation.get("info")).generate(), (Object)new Transformation().crop("scale").width((Object)103).generate());
        Assert.assertEquals(transformation.get("used"), (Object)false);
    }

    @Test(expected=NotFound.class)
    public void test16aTransformationDelete() throws Exception {
        this.api.createTransformation(API_TEST_TRANSFORMATION_2, new Transformation().crop("scale").width((Object)103).generate(), ObjectUtils.emptyMap());
        this.api.transformation(API_TEST_TRANSFORMATION_2, ObjectUtils.emptyMap());
        ApiResponse res = this.api.deleteTransformation(API_TEST_TRANSFORMATION_2, ObjectUtils.emptyMap());
        Assert.assertEquals((Object)"deleted", (Object)res.get((Object)"message"));
        this.api.transformation(API_TEST_TRANSFORMATION_2, ObjectUtils.emptyMap());
    }

    @Test(expected=NotFound.class)
    public void test17aTransformationDeleteImplicit() throws Exception {
        this.api.transformation(DELETE_TRANSFORMATION_NAME, ObjectUtils.emptyMap());
        ApiResponse res = this.api.deleteTransformation(DELETE_TRANSFORMATION_NAME, ObjectUtils.emptyMap());
        Assert.assertEquals((Object)"deleted", (Object)res.get((Object)"message"));
        this.api.deleteTransformation(DELETE_TRANSFORMATION_NAME, ObjectUtils.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTransformationByNamed() throws Exception {
        String name = "a_test_named_transformation_param" + SUFFIX;
        try {
            this.api.createTransformation(name, "w_100", null);
            name = "t_" + name;
            List named = (List)this.api.transformations(ObjectUtils.asMap((Object[])new Object[]{"max_results", 30, "named", true})).get((Object)"transformations");
            List unnamed = (List)this.api.transformations(ObjectUtils.asMap((Object[])new Object[]{"max_results", 30, "named", false})).get((Object)"transformations");
            boolean unnamedFound = false;
            boolean namedFound = false;
            for (Map t : unnamed) {
                if (!t.get("name").equals(name)) continue;
                unnamedFound = true;
                break;
            }
            if (!unnamedFound) {
                for (Map t : named) {
                    if (!t.get("name").equals(name)) continue;
                    namedFound = true;
                    break;
                }
            }
            Assert.assertTrue((String)"Named transformation wasn't returned with named=true param", (boolean)namedFound);
            Assert.assertFalse((String)"Named transformation returned with named=false param", (boolean)unnamedFound);
        }
        finally {
            try {
                this.api.deleteTransformation(name, null);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void test20ResourcesContext() throws Exception {
        ApiResponse result = this.api.resourcesByContext(TEST_KEY, ObjectUtils.emptyMap());
        List resources = (List)result.get("resources");
        Assert.assertEquals((long)2L, (long)resources.size());
        result = this.api.resourcesByContext(TEST_KEY, "alt", ObjectUtils.emptyMap());
        resources = (List)result.get("resources");
        Assert.assertEquals((long)1L, (long)resources.size());
    }

    @Test
    public void test18Usage() throws Exception {
        Date yesterday = this.yesterday();
        ApiResponse result = this.api.usage(ObjectUtils.asMap((Object[])new Object[]{"date", yesterday}));
        Assert.assertNotNull(result.get("last_updated"));
        result = this.api.usage(ObjectUtils.asMap((Object[])new Object[]{"date", ObjectUtils.toUsageApiDateFormat((Date)yesterday)}));
        Assert.assertNotNull(result.get("last_updated"));
        result = this.api.usage(ObjectUtils.emptyMap());
        Assert.assertNotNull(result.get("last_updated"));
    }

    private Date yesterday() {
        return new Date(new Date().getTime() - 86400000L);
    }

    @Test
    public void testRateLimitWithNonEnglishLocale() throws Exception {
        Locale.setDefault(new Locale("de", "DE"));
        ApiResponse result = this.cloudinary.api().usage(new HashMap());
        Assert.assertNotNull((Object)result.apiRateLimit().getReset());
    }

    @Test
    public void testRateLimits() throws Exception {
        ApiResponse result = this.cloudinary.api().usage(new HashMap());
        Assert.assertNotEquals((long)0L, (long)result.apiRateLimit().getLimit());
        Assert.assertNotNull((Object)result.apiRateLimit().getReset());
        Assert.assertNotEquals((long)0L, (long)result.apiRateLimit().getRemaining());
    }

    @Test
    public void test19Ping() throws Exception {
        ApiResponse result = this.api.ping(ObjectUtils.emptyMap());
        Assert.assertEquals(result.get("status"), (Object)"ok");
    }

    public void testDeleteAllResources() throws Exception {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", API_TEST_5, "tags", UPLOAD_TAGS, "eager", Collections.singletonList(new Transformation().crop("scale").width((Object)2.0))}));
        ApiResponse result = this.api.resource(API_TEST_5, ObjectUtils.emptyMap());
        Assert.assertEquals((long)1L, (long)((JSONArray)result.get("derived")).length());
        this.api.deleteAllResources(ObjectUtils.asMap((Object[])new Object[]{"keep_original", true}));
        result = this.api.resource(API_TEST_5, ObjectUtils.emptyMap());
    }

    @Test
    public void testManualModeration() throws Exception {
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"moderation", "manual", "tags", UPLOAD_TAGS}));
        ApiResponse apiResult = this.api.update((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"moderation_status", "approved", "tags", UPLOAD_TAGS}));
        Assert.assertEquals((Object)"approved", ((Map)((List)apiResult.get("moderation")).get(0)).get("status"));
    }

    @Test
    public void testOcrUpdate() throws Exception {
        this.assumeAddonEnabled("ocr");
        Exception expected = null;
        try {
            Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
            this.api.update((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"ocr", "illegal"}));
        }
        catch (Exception e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        Assert.assertTrue((boolean)(expected instanceof BadRequest));
        Assert.assertTrue((boolean)expected.getMessage().matches("^Illegal value(.*)"));
    }

    @Test
    public void testRawConvertUpdate() {
        try {
            Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
            this.api.update((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"raw_convert", "illegal"}));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequest));
            Assert.assertTrue((boolean)e.getMessage().matches("^Illegal value(.*)"));
        }
    }

    @Test
    public void testCategorizationUpdate() {
        try {
            Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
            this.api.update((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"categorization", "illegal"}));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequest));
            Assert.assertTrue((boolean)e.getMessage().matches("^Illegal value(.*)"));
        }
    }

    @Test
    public void testDetectionUpdate() {
        try {
            Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
            this.api.update((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"detection", "illegal"}));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequest));
            Assert.assertTrue((boolean)e.getMessage().matches("^Illegal value(.*)"));
        }
    }

    @Test
    public void testUpdateCustomCoordinates() throws IOException, Exception {
        Coordinates coordinates = new Coordinates("121,31,110,151");
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
        this.cloudinary.api().update(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"custom_coordinates", coordinates}));
        ApiResponse result = this.cloudinary.api().resource(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"coordinates", true}));
        int[] expected = new int[]{121, 31, 110, 151};
        ArrayList actual = (ArrayList)((ArrayList)((Map)result.get("coordinates")).get("custom")).get(0);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    @Test
    public void testUpdateAccessControl() throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Date start = simpleDateFormat.parse("2019-02-22 16:20:57 +0200");
        Date end = simpleDateFormat.parse("2019-03-22 00:00:00 +0200");
        AccessControlRule acl = AccessControlRule.anonymous((Date)start, (Date)end);
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS}));
        ApiResponse res = this.cloudinary.api().update(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"access_control", acl}));
        ApiResponse result = this.cloudinary.api().resource(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"access_control", true}));
        Map accessControlResult = (Map)((List)result.get("access_control")).get(0);
        Assert.assertEquals((Object)"anonymous", accessControlResult.get("access_type"));
        Assert.assertEquals((Object)"2019-02-22T14:20:57Z", accessControlResult.get("start"));
        Assert.assertEquals((Object)"2019-03-21T22:00:00Z", accessControlResult.get("end"));
    }

    @Test
    public void testListUploadPresets() throws Exception {
        this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"name", API_TEST_UPLOAD_PRESET, "folder", "folder"}));
        this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"name", API_TEST_UPLOAD_PRESET_2, "folder", "folder2"}));
        this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"name", API_TEST_UPLOAD_PRESET_3, "folder", "folder3"}));
        ArrayList presets = (ArrayList)this.api.uploadPresets(ObjectUtils.emptyMap()).get((Object)"presets");
        Assert.assertThat((Object)presets, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"name", (Object)API_TEST_UPLOAD_PRESET)));
        Assert.assertThat((Object)presets, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"name", (Object)API_TEST_UPLOAD_PRESET_2)));
        Assert.assertThat((Object)presets, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"name", (Object)API_TEST_UPLOAD_PRESET_3)));
        this.api.deleteUploadPreset(API_TEST_UPLOAD_PRESET, ObjectUtils.emptyMap());
        this.api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_2, ObjectUtils.emptyMap());
        this.api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_3, ObjectUtils.emptyMap());
    }

    @Test
    public void testGetUploadPreset() throws Exception {
        Object[] tags = new String[]{"a", "b", "c"};
        Map context = ObjectUtils.asMap((Object[])new Object[]{"a", "b", "c", "d"});
        ApiResponse result = this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"unsigned", true, "folder", "folder", "transformation", EXPLICIT_TRANSFORMATION, "tags", tags, "context", context, "live", true}));
        String name = result.get("name").toString();
        ApiResponse preset = this.api.uploadPreset(name, ObjectUtils.emptyMap());
        Assert.assertEquals(preset.get("name"), (Object)name);
        Assert.assertEquals((Object)Boolean.TRUE, preset.get("unsigned"));
        Map settings = (Map)preset.get("settings");
        Assert.assertEquals(settings.get("folder"), (Object)"folder");
        Assert.assertEquals(settings.get("live"), (Object)Boolean.TRUE);
        Map outTransformation = (Map)((ArrayList)settings.get("transformation")).get(0);
        Assert.assertEquals(outTransformation.get("width"), (Object)100);
        Assert.assertEquals(outTransformation.get("crop"), (Object)"scale");
        Object[] outTags = ((ArrayList)settings.get("tags")).toArray();
        Assert.assertArrayEquals((Object[])tags, (Object[])outTags);
        Map outContext = (Map)settings.get("context");
        Assert.assertEquals((Object)context, (Object)outContext);
        this.api.deleteUploadPreset(name, ObjectUtils.emptyMap());
    }

    @Test
    public void testDeleteUploadPreset() throws Exception {
        this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"name", API_TEST_UPLOAD_PRESET_4, "folder", "folder"}));
        this.api.uploadPreset(API_TEST_UPLOAD_PRESET_4, ObjectUtils.emptyMap());
        this.api.deleteUploadPreset(API_TEST_UPLOAD_PRESET_4, ObjectUtils.emptyMap());
        boolean error = false;
        try {
            this.api.uploadPreset(API_TEST_UPLOAD_PRESET_4, ObjectUtils.emptyMap());
        }
        catch (Exception e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testUpdateUploadPreset() throws Exception {
        String name = this.api.createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"folder", "folder"})).get((Object)"name").toString();
        ApiResponse preset = this.api.uploadPreset(name, ObjectUtils.emptyMap());
        Map settings = (Map)preset.get("settings");
        settings.putAll(ObjectUtils.asMap((Object[])new Object[]{"colors", true, "unsigned", true, "disallow_public_id", true, "live", true, "eval", "if (resource_info['width'] < 450) { upload_options['quality_analysis'] = true };upload_options['context'] = 'width=' + resource_info['width'];"}));
        this.api.updateUploadPreset(name, settings);
        settings.remove("unsigned");
        preset = this.api.uploadPreset(name, ObjectUtils.emptyMap());
        Assert.assertEquals((Object)name, preset.get("name"));
        Assert.assertEquals((Object)Boolean.TRUE, preset.get("unsigned"));
        Assert.assertEquals(settings.get("live"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)settings, preset.get("settings"));
        this.api.deleteUploadPreset(name, ObjectUtils.emptyMap());
    }

    @Test
    public void testListByModerationUpdate() throws Exception {
        Map result1 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"moderation", "manual", "tags", UPLOAD_TAGS}));
        Map result2 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"moderation", "manual", "tags", UPLOAD_TAGS}));
        Map result3 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"moderation", "manual", "tags", UPLOAD_TAGS}));
        this.api.update((String)result1.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"moderation_status", "approved"}));
        this.api.update((String)result2.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"moderation_status", "rejected"}));
        ApiResponse approved = this.api.resourcesByModeration("manual", "approved", ObjectUtils.asMap((Object[])new Object[]{"max_results", 1000}));
        ApiResponse rejected = this.api.resourcesByModeration("manual", "rejected", ObjectUtils.asMap((Object[])new Object[]{"max_results", 1000}));
        ApiResponse pending = this.api.resourcesByModeration("manual", "pending", ObjectUtils.asMap((Object[])new Object[]{"max_results", 1000}));
        List resources = (List)approved.get("resources");
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result1.get("public_id"))));
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result2.get("public_id")))));
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result3.get("public_id")))));
        resources = (List)rejected.get("resources");
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result1.get("public_id")))));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result2.get("public_id"))));
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result3.get("public_id")))));
        resources = (List)pending.get("resources");
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result1.get("public_id")))));
        Assert.assertThat((Object)resources, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result2.get("public_id")))));
        Assert.assertThat((Object)resources, (Matcher)Matchers.hasItem((Matcher)Matchers.hasEntry((Object)"public_id", result3.get("public_id"))));
    }

    public void testFolderApi() throws Exception {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", "test_folder1/item", "tags", UPLOAD_TAGS}));
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", "test_folder2/item", "tags", UPLOAD_TAGS}));
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", "test_folder1/test_subfolder1/item", "tags", UPLOAD_TAGS}));
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", "test_folder1/test_subfolder2/item", "tags", UPLOAD_TAGS}));
        ApiResponse result = this.api.rootFolders(null);
        Assert.assertEquals((Object)"test_folder1", ((Map)((JSONArray)result.get("folders")).get(0)).get("name"));
        Assert.assertEquals((Object)"test_folder2", ((Map)((JSONArray)result.get("folders")).get(1)).get("name"));
        result = this.api.subFolders("test_folder1", null);
        Assert.assertEquals((Object)"test_folder1/test_subfolder1", ((Map)((JSONArray)result.get("folders")).get(0)).get("path"));
        Assert.assertEquals((Object)"test_folder1/test_subfolder2", ((Map)((JSONArray)result.get("folders")).get(1)).get("path"));
        try {
            this.api.subFolders("test_folder", null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NotFound));
        }
        this.api.deleteResourcesByPrefix("test_folder", ObjectUtils.emptyMap());
    }

    @Test
    public void testCreateFolder() throws Exception {
        String apTestCreateFolder = "api_test_create_folder_" + SUFFIX;
        createdFolders.add(apTestCreateFolder);
        ApiResponse result = this.api.createFolder("apTestCreateFolder", null);
        Assert.assertTrue((boolean)((Boolean)result.get("success")));
    }

    @Test
    public void testRestore() throws Exception {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", API_TEST_RESTORE, "backup", true, "tags", UPLOAD_TAGS}));
        ApiResponse resource = this.api.resource(API_TEST_RESTORE, ObjectUtils.emptyMap());
        Assert.assertEquals(resource.get("bytes"), (Object)3381);
        this.api.deleteResources(Collections.singletonList(API_TEST_RESTORE), ObjectUtils.emptyMap());
        resource = this.api.resource(API_TEST_RESTORE, ObjectUtils.emptyMap());
        Assert.assertEquals(resource.get("bytes"), (Object)0);
        Assert.assertTrue((boolean)((Boolean)resource.get("placeholder")));
        ApiResponse response = this.api.restore(Collections.singletonList(API_TEST_RESTORE), ObjectUtils.emptyMap());
        Map info = (Map)response.get(API_TEST_RESTORE);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals(info.get("bytes"), (Object)3381);
        resource = this.api.resource(API_TEST_RESTORE, ObjectUtils.emptyMap());
        Assert.assertEquals(resource.get("bytes"), (Object)3381);
    }

    @Test
    public void testRestoreDifferentVersionsOfDeletedAsset() throws Exception {
        String TEST_RESOURCE_PUBLIC_ID = "api_test_restore_different_versions_single_asset" + SUFFIX;
        Uploader uploader = this.cloudinary.uploader();
        Map firstUpload = uploader.upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", TEST_RESOURCE_PUBLIC_ID, "backup", true, "tags", UPLOAD_TAGS}));
        Assert.assertEquals(firstUpload.get("public_id"), (Object)TEST_RESOURCE_PUBLIC_ID);
        Thread.sleep(5000L);
        ApiResponse firstDelete = this.api.deleteResources(Collections.singletonList(TEST_RESOURCE_PUBLIC_ID), ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)firstDelete.containsKey((Object)"deleted"));
        Thread.sleep(5000L);
        Map secondUpload = uploader.upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", TEST_RESOURCE_PUBLIC_ID, "backup", true, "transformation", new Transformation().angle(new String[]{"0"}), "tags", UPLOAD_TAGS}));
        Assert.assertEquals(secondUpload.get("public_id"), (Object)TEST_RESOURCE_PUBLIC_ID);
        Thread.sleep(5000L);
        ApiResponse secondDelete = this.api.deleteResources(Collections.singletonList(TEST_RESOURCE_PUBLIC_ID), ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)secondDelete.containsKey((Object)"deleted"));
        Thread.sleep(5000L);
        Assert.assertNotEquals(firstUpload.get("bytes"), secondUpload.get("bytes"));
        ApiResponse getVersionsResp = this.api.resource(TEST_RESOURCE_PUBLIC_ID, ObjectUtils.asMap((Object[])new Object[]{"versions", true}));
        List versions = (List)getVersionsResp.get((Object)"versions");
        Assert.assertTrue((versions.size() > 1 ? 1 : 0) != 0);
        Object firstAssetVersion = ((Map)versions.get(0)).get("version_id");
        Object secondAssetVersion = ((Map)versions.get(1)).get("version_id");
        ApiResponse firstVerRestore = this.api.restore(Collections.singletonList(TEST_RESOURCE_PUBLIC_ID), ObjectUtils.asMap((Object[])new Object[]{"versions", Collections.singletonList(firstAssetVersion)}));
        Assert.assertEquals(((Map)firstVerRestore.get((Object)TEST_RESOURCE_PUBLIC_ID)).get("bytes"), firstUpload.get("bytes"));
        ApiResponse secondVerRestore = this.api.restore(Collections.singletonList(TEST_RESOURCE_PUBLIC_ID), ObjectUtils.asMap((Object[])new Object[]{"versions", Collections.singletonList(secondAssetVersion)}));
        Assert.assertEquals(((Map)secondVerRestore.get((Object)TEST_RESOURCE_PUBLIC_ID)).get("bytes"), secondUpload.get("bytes"));
        Thread.sleep(5000L);
        ApiResponse finalDeleteResp = this.api.deleteResources(Collections.singletonList(TEST_RESOURCE_PUBLIC_ID), ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)finalDeleteResp.containsKey((Object)"deleted"));
    }

    @Test
    public void testShouldRestoreTwoDifferentDeletedAssets() throws Exception {
        String PUBLIC_ID_BACKUP_1 = "api_test_restore_versions_different_assets_1_" + SUFFIX;
        String PUBLIC_ID_BACKUP_2 = "api_test_restore_versions_different_assets_2_" + SUFFIX;
        Uploader uploader = this.cloudinary.uploader();
        Map firstUpload = uploader.upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", PUBLIC_ID_BACKUP_1, "backup", true, "tags", UPLOAD_TAGS}));
        Map secondUpload = uploader.upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", PUBLIC_ID_BACKUP_2, "backup", true, "transformation", new Transformation().angle(new String[]{"0"}), "tags", UPLOAD_TAGS}));
        ApiResponse deleteAll = this.api.deleteResources(Arrays.asList(PUBLIC_ID_BACKUP_1, PUBLIC_ID_BACKUP_2), ObjectUtils.emptyMap());
        Assert.assertEquals((Object)"deleted", ((Map)deleteAll.get((Object)"deleted")).get(PUBLIC_ID_BACKUP_1));
        Assert.assertEquals((Object)"deleted", ((Map)deleteAll.get((Object)"deleted")).get(PUBLIC_ID_BACKUP_2));
        ApiResponse getFirstAssetVersion = this.api.resource(PUBLIC_ID_BACKUP_1, ObjectUtils.asMap((Object[])new Object[]{"versions", true}));
        ApiResponse getSecondAssetVersion = this.api.resource(PUBLIC_ID_BACKUP_2, ObjectUtils.asMap((Object[])new Object[]{"versions", true}));
        Object firstAssetVersion = ((Map)((List)getFirstAssetVersion.get((Object)"versions")).get(0)).get("version_id");
        Object secondAssetVersion = ((Map)((List)getSecondAssetVersion.get((Object)"versions")).get(0)).get("version_id");
        ApiResponse restore = this.api.restore(Arrays.asList(PUBLIC_ID_BACKUP_1, PUBLIC_ID_BACKUP_2), ObjectUtils.asMap((Object[])new Object[]{"versions", Arrays.asList(firstAssetVersion, secondAssetVersion)}));
        Assert.assertEquals(((Map)restore.get((Object)PUBLIC_ID_BACKUP_1)).get("bytes"), firstUpload.get("bytes"));
        Assert.assertEquals(((Map)restore.get((Object)PUBLIC_ID_BACKUP_2)).get("bytes"), secondUpload.get("bytes"));
        ApiResponse finalDelete = this.api.deleteResources(Arrays.asList(PUBLIC_ID_BACKUP_1, PUBLIC_ID_BACKUP_2), ObjectUtils.emptyMap());
        Assert.assertEquals((Object)"deleted", ((Map)finalDelete.get((Object)"deleted")).get(PUBLIC_ID_BACKUP_1));
        Assert.assertEquals((Object)"deleted", ((Map)finalDelete.get((Object)"deleted")).get(PUBLIC_ID_BACKUP_2));
    }

    @Test
    public void testEncodeUrlInApiCall() throws Exception {
        String apiTestEncodeUrlInApiCall = "sub^folder test";
        createdFolders.add(apiTestEncodeUrlInApiCall);
        ApiResponse result = this.api.createFolder(apiTestEncodeUrlInApiCall, null);
        Assert.assertEquals((Object)"sub^folder test", result.get("path"));
    }

    @Test
    public void testUploadMapping() throws Exception {
        Map mapping;
        String aptTestUploadMapping = "api_test_upload_mapping" + SUFFIX;
        try {
            this.api.deleteUploadMapping(aptTestUploadMapping, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.api.createUploadMapping(aptTestUploadMapping, ObjectUtils.asMap((Object[])new Object[]{"template", "http://cloudinary.com"}));
        ApiResponse result = this.api.uploadMapping(aptTestUploadMapping, ObjectUtils.emptyMap());
        Assert.assertEquals(result.get("template"), (Object)"http://cloudinary.com");
        this.api.updateUploadMapping(aptTestUploadMapping, ObjectUtils.asMap((Object[])new Object[]{"template", "http://res.cloudinary.com"}));
        result = this.api.uploadMapping(aptTestUploadMapping, ObjectUtils.emptyMap());
        Assert.assertEquals(result.get("template"), (Object)"http://res.cloudinary.com");
        result = this.api.uploadMappings(ObjectUtils.emptyMap());
        ListIterator mappings = ((ArrayList)result.get("mappings")).listIterator();
        boolean found = false;
        while (mappings.hasNext()) {
            mapping = (Map)mappings.next();
            if (!mapping.get("folder").equals(aptTestUploadMapping) || !mapping.get("template").equals("http://res.cloudinary.com")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        this.api.deleteUploadMapping(aptTestUploadMapping, ObjectUtils.emptyMap());
        result = this.api.uploadMappings(ObjectUtils.emptyMap());
        found = false;
        while (mappings.hasNext()) {
            mapping = (Map)mappings.next();
            if (!mapping.get("folder").equals(aptTestUploadMapping) || !mapping.get("template").equals("http://res.cloudinary.com")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((!found ? 1 : 0) != 0);
    }

    @Test
    public void testPublishByIds() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "type", "authenticated"}));
        String publicId = (String)response.get("public_id");
        response = this.cloudinary.api().publishByIds(Arrays.asList(publicId), null);
        List published = (List)response.get("published");
        Assert.assertNotNull((Object)published);
        Assert.assertEquals((long)published.size(), (long)1L);
        Map resource = (Map)published.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertNotNull(resource.get("url"));
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testPublishWithType() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "type", "authenticated"}));
        String publicId = (String)response.get("public_id");
        response = this.cloudinary.api().publishByIds(Arrays.asList(publicId), ObjectUtils.asMap((Object[])new Object[]{"type", "private"}));
        List published = (List)response.get("published");
        List failed = (List)response.get("failed");
        Assert.assertNotNull((Object)published);
        Assert.assertNotNull((Object)failed);
        Assert.assertEquals((long)published.size(), (long)0L);
        Assert.assertEquals((long)failed.size(), (long)1L);
        response = this.cloudinary.api().publishByIds(Arrays.asList(publicId), ObjectUtils.asMap((Object[])new Object[]{"type", "authenticated"}));
        published = (List)response.get("published");
        failed = (List)response.get("failed");
        Assert.assertNotNull((Object)published);
        Assert.assertNotNull((Object)failed);
        Assert.assertEquals((long)published.size(), (long)1L);
        Assert.assertEquals((long)failed.size(), (long)0L);
        Map resource = (Map)published.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertNotNull(resource.get("url"));
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testPublishByPrefix() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "type", "authenticated"}));
        String publicId = (String)response.get("public_id");
        response = this.cloudinary.api().publishByPrefix(publicId.substring(0, publicId.length() - 2), null);
        List published = (List)response.get("published");
        Assert.assertNotNull((Object)published);
        Assert.assertEquals((long)published.size(), (long)1L);
        Map resource = (Map)published.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertNotNull(resource.get("url"));
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testPublishByTag() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(API_TAG, API_TAG + "1"), "type", "authenticated"}));
        String publicId = (String)response.get("public_id");
        response = this.cloudinary.api().publishByTag(API_TAG + "1", null);
        List published = (List)response.get("published");
        Assert.assertNotNull((Object)published);
        Assert.assertEquals((long)published.size(), (long)1L);
        Map resource = (Map)published.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertNotNull(resource.get("url"));
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testUpdateResourcesAccessModeByIds() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "access_mode", "authenticated"}));
        String publicId = (String)response.get("public_id");
        Assert.assertEquals(response.get("access_mode"), (Object)"authenticated");
        response = this.cloudinary.api().updateResourcesAccessModeByIds("public", Arrays.asList(publicId), null);
        List updated = (List)response.get("updated");
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((long)updated.size(), (long)1L);
        Map resource = (Map)updated.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertEquals(resource.get("access_mode"), (Object)"public");
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testUpdateResourcesAccessModeByPrefix() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "access_mode", "authenticated"}));
        String publicId = (String)response.get("public_id");
        Assert.assertEquals(response.get("access_mode"), (Object)"authenticated");
        response = this.cloudinary.api().updateResourcesAccessModeByPrefix("public", publicId.substring(0, publicId.length() - 2), null);
        List updated = (List)response.get("updated");
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((long)updated.size(), (long)1L);
        Map resource = (Map)updated.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertEquals(resource.get("access_mode"), (Object)"public");
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testUpdateResourcesAccessModeByTag() throws Exception {
        Map response = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(API_TAG, API_TAG + "2"), "access_mode", "authenticated"}));
        String publicId = (String)response.get("public_id");
        Assert.assertEquals(response.get("access_mode"), (Object)"authenticated");
        response = this.cloudinary.api().updateResourcesAccessModeByTag("public", API_TAG + "2", null);
        List updated = (List)response.get("updated");
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((long)updated.size(), (long)1L);
        Map resource = (Map)updated.get(0);
        Assert.assertEquals(resource.get("public_id"), (Object)publicId);
        Assert.assertEquals(resource.get("access_mode"), (Object)"public");
        this.cloudinary.uploader().destroy(publicId, null);
    }

    @Test
    public void testQualityAnalysis() throws Exception {
        ApiResponse result = this.cloudinary.api().resource(API_TEST, ObjectUtils.asMap((Object[])new Object[]{"quality_analysis", true}));
        Assert.assertNotNull((Object)result.get((Object)"quality_analysis"));
    }

    @Test(expected=NotFound.class)
    public void testDeleteFolder() throws Exception {
        String toDelete = "todelete_" + SUFFIX;
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", UPLOAD_TAGS, "folder", toDelete}));
        Thread.sleep(5000L);
        this.api.deleteResources(Collections.singletonList(uploadResult.get("public_id").toString()), ObjectUtils.emptyMap());
        ApiResponse result = this.api.deleteFolder(toDelete, ObjectUtils.emptyMap());
        Assert.assertTrue((boolean)((ArrayList)result.get((Object)"deleted")).contains(toDelete));
        this.api.deleteFolder(this.cloudinary.randomPublicId(), ObjectUtils.emptyMap());
    }

    @Test
    public void testCinemagraphAnalysisResource() throws Exception {
        ApiResponse res = this.api.resource(API_TEST, Collections.singletonMap("cinemagraph_analysis", true));
        Assert.assertNotNull((Object)res.get((Object)"cinemagraph_analysis"));
    }

    @Test
    public void testAccessibilityAnalysisResource() throws Exception {
        ApiResponse res = this.api.resource(API_TEST, Collections.singletonMap("accessibility_analysis", true));
        Assert.assertNotNull((Object)res.get((Object)"accessibility_analysis"));
    }
}

