/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractFoldersApiTest
extends MockableTest {
    protected Api api;
    @Rule
    public TestName currentTest = new TestName();

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
        this.api = this.cloudinary.api();
    }

    @Test
    public void testRootFolderWithParams() throws Exception {
        String rootFolder1Name = "rootFolderWithParamsTest1" + SUFFIX;
        Assert.assertTrue((boolean)((Boolean)this.api.createFolder(rootFolder1Name, null).get((Object)"success")));
        String rootFolder2Name = "rootFolderWithParamsTest2" + SUFFIX;
        Assert.assertTrue((boolean)((Boolean)this.api.createFolder(rootFolder2Name, null).get((Object)"success")));
        Thread.sleep(2000L);
        ApiResponse rootResponse1 = this.api.rootFolders(ObjectUtils.asMap((Object[])new Object[]{"max_results", 1}));
        List rootFolders1 = (List)rootResponse1.get((Object)"folders");
        Assert.assertNotNull((Object)rootFolders1);
        Assert.assertEquals((long)1L, (long)rootFolders1.size());
        String nextCursor = (String)rootResponse1.get((Object)"next_cursor");
        Assert.assertNotNull((Object)nextCursor);
        ApiResponse rootResponse2 = this.api.rootFolders(ObjectUtils.asMap((Object[])new Object[]{"max_results", 1, "next_cursor", nextCursor}));
        List folders2 = (List)rootResponse2.get((Object)"folders");
        Assert.assertNotNull((Object)folders2);
        Assert.assertEquals((long)1L, (long)folders2.size());
        Assert.assertTrue((boolean)((List)this.api.deleteFolder(rootFolder1Name, null).get((Object)"deleted")).contains(rootFolder1Name));
        Assert.assertTrue((boolean)((List)this.api.deleteFolder(rootFolder2Name, null).get((Object)"deleted")).contains(rootFolder2Name));
    }

    @Test
    public void testSubFolderWithParams() throws Exception {
        String rootFolderName = "subfolderWithParamsTest" + SUFFIX;
        Assert.assertTrue((boolean)((Boolean)this.api.createFolder(rootFolderName, null).get((Object)"success")));
        String subFolder1Name = rootFolderName + "/subfolder1" + SUFFIX;
        Assert.assertTrue((boolean)((Boolean)this.api.createFolder(subFolder1Name, null).get((Object)"success")));
        String subFolder2Name = rootFolderName + "/subfolder2" + SUFFIX;
        Assert.assertTrue((boolean)((Boolean)this.api.createFolder(subFolder2Name, null).get((Object)"success")));
        Thread.sleep(2000L);
        ApiResponse response = this.api.subFolders(rootFolderName, ObjectUtils.asMap((Object[])new Object[]{"max_results", 1}));
        List folders = (List)response.get((Object)"folders");
        Assert.assertNotNull((Object)folders);
        Assert.assertEquals((long)1L, (long)folders.size());
        String nextCursor = (String)response.get((Object)"next_cursor");
        Assert.assertNotNull((Object)nextCursor);
        ApiResponse response2 = this.api.subFolders(rootFolderName, ObjectUtils.asMap((Object[])new Object[]{"max_results", 1, "next_cursor", nextCursor}));
        List folders2 = (List)response2.get((Object)"folders");
        Assert.assertNotNull((Object)folders2);
        Assert.assertEquals((long)1L, (long)folders2.size());
        ApiResponse result = this.api.deleteFolder(rootFolderName, null);
        Assert.assertTrue((boolean)((List)result.get((Object)"deleted")).contains(rootFolderName));
    }
}

