/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.BadRequest;
import com.cloudinary.metadata.DateMetadataField;
import com.cloudinary.metadata.MetadataDataSource;
import com.cloudinary.metadata.MetadataField;
import com.cloudinary.metadata.MetadataValidation;
import com.cloudinary.metadata.SetMetadataField;
import com.cloudinary.metadata.StringMetadataField;
import com.cloudinary.test.MetadataTestHelper;
import com.cloudinary.test.MockableTest;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractStructuredMetadataTest
extends MockableTest {
    private static final String METADATA_UPLOADER_TAG = SDK_TEST_TAG + "_uploader";
    private static final String PUBLIC_ID = "before_class_public_id" + SUFFIX;
    private static final String PRIVATE_PUBLIC_ID = "before_class_private_public_id" + SUFFIX;
    protected Api api;
    public static final List<String> metadataFieldExternalIds = new ArrayList<String>();
    @Rule
    public TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpClass() throws IOException {
        Cloudinary cloudinary = new Cloudinary();
        if (cloudinary.config.apiSecret == null) {
            System.err.println("Please setup environment for Upload test to run");
        }
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", PUBLIC_ID}));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", PRIVATE_PUBLIC_ID, "type", "private"}));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Api api = new Cloudinary().api();
        for (String externalId : metadataFieldExternalIds) {
            try {
                api.deleteMetadataField(externalId);
            }
            catch (Exception exception) {}
        }
    }

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
        this.api = this.cloudinary.api();
    }

    @Test
    public void testCreateMetadata() throws Exception {
        StringMetadataField stringField = this.newFieldInstance("testCreateMetadata_1");
        ApiResponse result = this.addFieldToAccount((MetadataField)stringField);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)stringField.getLabel(), (Object)result.get((Object)"label"));
        SetMetadataField setField = this.createSetField("testCreateMetadata_2");
        result = this.cloudinary.api().addMetadataField((MetadataField)setField);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)setField.getLabel(), (Object)result.get((Object)"label"));
    }

    @Test
    public void testDateFieldDefaultValueValidation() throws Exception {
        Date max = new Date();
        Date min = new Date(max.getTime() - 259200000L);
        Date legalValue = new Date(min.getTime() + 129600000L);
        Date illegalValue = new Date(max.getTime() + 129600000L);
        DateMetadataField dateMetadataField = new DateMetadataField();
        dateMetadataField.setLabel("Start date" + new Date().getTime());
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MetadataValidation.DateGreaterThan(min));
        rules.add(new MetadataValidation.DateLessThan(max));
        dateMetadataField.setValidation((MetadataValidation)new MetadataValidation.AndValidator(rules));
        String message = null;
        ApiResponse res = null;
        try {
            dateMetadataField.setDefaultValue(illegalValue);
            res = this.api.addMetadataField((MetadataField)dateMetadataField);
            metadataFieldExternalIds.add(res.get((Object)"external_id").toString());
        }
        catch (BadRequest e) {
            message = e.getMessage();
        }
        Assert.assertEquals((Object)message, (Object)"default_value is invalid");
        dateMetadataField.setDefaultValue(legalValue);
        res = this.api.addMetadataField((MetadataField)dateMetadataField);
        metadataFieldExternalIds.add(res.get((Object)"external_id").toString());
    }

    @Test
    public void testListFields() throws Exception {
        StringMetadataField stringField = this.newFieldInstance("testListFields");
        this.addFieldToAccount((MetadataField)stringField);
        ApiResponse result = this.cloudinary.api().listMetadataFields();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.get((Object)"metadata_fields"));
        Assert.assertTrue((((List)result.get((Object)"metadata_fields")).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMetadata() throws Exception {
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)this.newFieldInstance("testGetMetadata"));
        ApiResponse result = this.api.metadataFieldByFieldId(fieldResult.get((Object)"external_id").toString());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)fieldResult.get((Object)"label"), (Object)result.get((Object)"label"));
    }

    @Test
    public void testUpdateField() throws Exception {
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)this.newFieldInstance("testUpdateField"));
        Assert.assertNotEquals((Object)"new_def", (Object)fieldResult.get((Object)"default_value"));
        StringMetadataField field = new StringMetadataField();
        field.setDefaultValue((Object)"new_def");
        ApiResponse result = this.api.updateMetadataField(fieldResult.get((Object)"external_id").toString(), (MetadataField)field);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"new_def", (Object)result.get((Object)"default_value"));
    }

    @Test
    public void testDeleteField() throws Exception {
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)this.newFieldInstance("testDeleteField"));
        ApiResponse result = this.api.deleteMetadataField(fieldResult.get((Object)"external_id").toString());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"ok", (Object)result.get((Object)"message"));
    }

    @Test
    public void testUpdateDatasource() throws Exception {
        SetMetadataField setField = this.createSetField("testUpdateDatasource");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)setField);
        MetadataDataSource.Entry newEntry = new MetadataDataSource.Entry("id1", "new1");
        ApiResponse result = this.api.updateMetadataFieldDatasource(fieldResult.get((Object)"external_id").toString(), Collections.singletonList(newEntry));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"new1", ((Map)((List)result.get((Object)"values")).get(0)).get("value"));
    }

    @Test
    public void testDeleteDatasourceEntries() throws Exception {
        SetMetadataField setField = this.createSetField("testDeleteDatasourceEntries");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)setField);
        ApiResponse result = this.api.deleteDatasourceEntries(fieldResult.get((Object)"external_id").toString(), Collections.singletonList("id1"));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testRestoreDatasourceEntries() throws Exception {
        SetMetadataField setField = this.createSetField("testRestoreDatasourceEntries");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)setField);
        String fieldExternalId = fieldResult.get((Object)"external_id").toString();
        this.api.deleteDatasourceEntries(fieldExternalId, Collections.singletonList("id1"));
        ApiResponse result = this.api.restoreDatasourceEntries(fieldExternalId, Collections.singletonList("id1"));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testReorderMetadataFieldsByLabel() throws Exception {
        this.AddStringField("some_value");
        this.AddStringField("aaa");
        this.AddStringField("zzz");
        ApiResponse result = this.api.reorderMetadataFields("label", null, Collections.EMPTY_MAP);
        Assert.assertThat((Object)this.getField(result, 0), (Matcher)Matchers.containsString((String)"aaa"));
        result = this.api.reorderMetadataFields("label", "desc", Collections.EMPTY_MAP);
        Assert.assertThat((Object)this.getField(result, 0), (Matcher)Matchers.containsString((String)"zzz"));
        result = this.api.reorderMetadataFields("label", "asc", Collections.EMPTY_MAP);
        Assert.assertThat((Object)this.getField(result, 0), (Matcher)Matchers.containsString((String)"aaa"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReorderMetadataFieldsOrderByIsRequired() throws Exception {
        this.api.reorderMetadataFields(null, null, Collections.EMPTY_MAP);
    }

    private String getField(ApiResponse result, int index) {
        String actual = ((Map)((ArrayList)result.get((Object)"metadata_fields")).get(index)).get("label").toString();
        return actual;
    }

    private void AddStringField(String labelPrefix) throws Exception {
        StringMetadataField field = this.newFieldInstance(labelPrefix);
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
    }

    @Test
    public void testUploadWithMetadata() throws Exception {
        StringMetadataField field = this.newFieldInstance("testUploadWithMetadata");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
        Map<String, String> metadata = Collections.singletonMap(fieldId, "123456");
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"metadata", metadata, "tags", Arrays.asList(SDK_TEST_TAG, METADATA_UPLOADER_TAG)}));
        Assert.assertNotNull(result.get("metadata"));
        Assert.assertEquals((Object)"123456", ((Map)result.get("metadata")).get(fieldId));
    }

    @Test
    public void testExplicitWithMetadata() throws Exception {
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, METADATA_UPLOADER_TAG)}));
        String publicId = uploadResult.get("public_id").toString();
        StringMetadataField field = this.newFieldInstance("testExplicitWithMetadata");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
        Map<String, String> metadata = Collections.singletonMap(fieldId, "123456");
        Map result = this.cloudinary.uploader().explicit(publicId, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "metadata", metadata}));
        Assert.assertNotNull(result.get("metadata"));
        Assert.assertEquals((Object)"123456", ((Map)result.get("metadata")).get(fieldId));
        metadata = Collections.singletonMap(fieldId, "12");
        String message = "";
        try {
            result = this.cloudinary.uploader().explicit(publicId, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "metadata", metadata}));
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        Assert.assertTrue((boolean)message.contains("is not valid for field"));
    }

    @Test
    public void testUpdateWithMetadata() throws Exception {
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, METADATA_UPLOADER_TAG)}));
        String publicId = uploadResult.get("public_id").toString();
        StringMetadataField field = this.newFieldInstance("testUpdateWithMetadata");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
        Map<String, String> metadata = Collections.singletonMap(fieldId, "123456");
        ApiResponse result = this.cloudinary.api().update(publicId, ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "metadata", metadata}));
        Assert.assertNotNull(result.get("metadata"));
        Assert.assertEquals((Object)"123456", ((Map)result.get("metadata")).get(fieldId));
    }

    @Test
    public void testUploaderUpdateMetadata() throws Exception {
        StringMetadataField field = this.newFieldInstance("testUploaderUpdateMetadata");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
        Map result = this.cloudinary.uploader().updateMetadata(Collections.singletonMap(fieldId, "123456"), new String[]{PUBLIC_ID}, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PUBLIC_ID, (Object)((List)result.get("public_ids")).get(0).toString());
        Map result2 = this.cloudinary.uploader().updateMetadata(Collections.singletonMap(fieldId, "123456"), new String[]{PRIVATE_PUBLIC_ID}, ObjectUtils.asMap((Object[])new Object[]{"type", "private"}));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PRIVATE_PUBLIC_ID, (Object)((List)result2.get("public_ids")).get(0).toString());
    }

    @Test
    public void testSetField() throws Exception {
        SetMetadataField field = this.createSetField("test123");
        ApiResponse fieldResult = this.addFieldToAccount((MetadataField)field);
        String fieldId = fieldResult.get((Object)"external_id").toString();
        Map result = this.cloudinary.uploader().updateMetadata(ObjectUtils.asMap((Object[])new Object[]{fieldId, new String[]{"id2", "id3"}}), new String[]{PUBLIC_ID}, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PUBLIC_ID, (Object)((List)result.get("public_ids")).get(0).toString());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("id1");
        list.add("id2");
        result = this.cloudinary.uploader().updateMetadata(ObjectUtils.asMap((Object[])new Object[]{fieldId, list}), new String[]{PUBLIC_ID}, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PUBLIC_ID, (Object)((List)result.get("public_ids")).get(0).toString());
    }

    private SetMetadataField createSetField(String labelPrefix) {
        SetMetadataField setField = new SetMetadataField();
        String label = labelPrefix + "_" + SUFFIX;
        setField.setLabel(label);
        setField.setMandatory(Boolean.valueOf(false));
        setField.setValidation((MetadataValidation)new MetadataValidation.StringLength(Integer.valueOf(3), Integer.valueOf(99)));
        setField.setDefaultValue(Arrays.asList("id2", "id3"));
        setField.setValidation(null);
        ArrayList<MetadataDataSource.Entry> entries = new ArrayList<MetadataDataSource.Entry>();
        entries.add(new MetadataDataSource.Entry("id1", "first_value"));
        entries.add(new MetadataDataSource.Entry("id2", "second_value"));
        entries.add(new MetadataDataSource.Entry("id3", "third_value"));
        MetadataDataSource dataSource = new MetadataDataSource(entries);
        setField.setDataSource(dataSource);
        return setField;
    }

    private StringMetadataField newFieldInstance(String labelPrefix) throws Exception {
        String label = labelPrefix + "_" + SUFFIX;
        return MetadataTestHelper.newFieldInstance(label);
    }

    private ApiResponse addFieldToAccount(MetadataField field) throws Exception {
        ApiResponse apiResponse = MetadataTestHelper.addFieldToAccount(this.api, field);
        metadataFieldExternalIds.add(apiResponse.get((Object)"external_id").toString());
        return apiResponse;
    }
}

