/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.AccessControlRule;
import com.cloudinary.Api;
import com.cloudinary.ArchiveParams;
import com.cloudinary.Cloudinary;
import com.cloudinary.Coordinates;
import com.cloudinary.ResponsiveBreakpoint;
import com.cloudinary.Transformation;
import com.cloudinary.Util;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.metadata.MetadataField;
import com.cloudinary.metadata.StringMetadataField;
import com.cloudinary.test.MetadataTestHelper;
import com.cloudinary.test.MockableTest;
import com.cloudinary.test.rules.RetryRule;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.Rectangle;
import com.cloudinary.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.cloudinary.json.JSONArray;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractUploaderTest
extends MockableTest {
    private static final String ARCHIVE_TAG = SDK_TEST_TAG + "_archive";
    private static final String UPLOADER_TAG = SDK_TEST_TAG + "_uploader";
    public static final int SRC_TEST_IMAGE_W = 241;
    public static final int SRC_TEST_IMAGE_H = 51;
    private static Map<String, Set<String>> toDelete = new HashMap<String, Set<String>>();
    private static final String UPLOADER_TEST_PUBLIC_ID = "uploader_test";
    public static final String SRC_FULLY_QUALIFIED_IMAGE = "image/upload/uploader_test";
    public static final String SRC_FULLY_QUALIFIED_VIDEO = "video/upload/dog";
    public static final String SRC_TEST_EVAL = "if (resource_info['width'] < 450) { upload_options['quality_analysis'] = true };upload_options['context'] = 'width=' + resource_info['width'];";
    @Rule
    public TestName currentTest = new TestName();
    @Rule
    public RetryRule retryRule = new RetryRule();

    @BeforeClass
    public static void setUpClass() throws IOException {
        Cloudinary cloudinary = new Cloudinary();
        if (cloudinary.config.apiSecret == null) {
            System.err.println("Please setup environment for Upload test to run");
        }
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG, ARCHIVE_TAG}}));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG}, "public_id", UPLOADER_TEST_PUBLIC_ID, "transformation", "f_jpg"}));
        cloudinary.uploader().upload((Object)"http://res.cloudinary.com/demo/video/upload/dog.mp4", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG, ARCHIVE_TAG}, "public_id", "dog", "resource_type", "video"}));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG, ARCHIVE_TAG}, "resource_type", "raw"}));
        cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG, ARCHIVE_TAG}, "transformation", new Transformation().crop("scale").width((Object)10)}));
    }

    @AfterClass
    public static void tearDownClass() {
        Api api = new Cloudinary().api();
        try {
            api.deleteResourcesByTag(UPLOADER_TAG, ObjectUtils.emptyMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteResourcesByTag(UPLOADER_TAG, ObjectUtils.asMap((Object[])new Object[]{"resource_type", "video"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            api.deleteResourcesByTag(UPLOADER_TAG, ObjectUtils.asMap((Object[])new Object[]{"resource_type", "raw"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String type : toDelete.keySet()) {
            try {
                api.deleteResources((Iterable)toDelete.get(type), Collections.singletonMap("type", type));
            }
            catch (Exception exception) {}
        }
        toDelete.clear();
    }

    @Before
    public void setUp() {
        System.out.println("Running " + this.getClass().getName() + "." + this.currentTest.getMethodName());
        this.cloudinary = new Cloudinary();
        Assume.assumeNotNull((Object[])new Object[]{this.cloudinary.config.apiSecret});
    }

    @Test
    public void testUtf8Upload() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"colors", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG), "public_id", "a\u00e5\u00df\u00e9\u0192"}));
        Assert.assertEquals(result.get("width"), (Object)241);
        Assert.assertEquals(result.get("height"), (Object)51);
        Assert.assertNotNull(result.get("colors"));
        Assert.assertNotNull(result.get("predominant"));
        HashMap to_sign = new HashMap();
        to_sign.put("public_id", result.get("public_id"));
        to_sign.put("version", ObjectUtils.asString(result.get("version")));
        String expected_signature = this.cloudinary.apiSignRequest(to_sign, this.cloudinary.config.apiSecret);
        Assert.assertEquals(result.get("signature"), (Object)expected_signature);
    }

    @Test
    public void testDeleteByToken() throws Exception {
        Map options = ObjectUtils.asMap((Object[])new Object[]{"return_delete_token", true, "tags", new String[]{SDK_TEST_TAG, UPLOADER_TAG}});
        Map res = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        String token = (String)res.get("delete_token");
        Map baseConfig = this.cloudinary.config.asMap();
        baseConfig.remove("api_key");
        baseConfig.remove("api_secret");
        res = new Cloudinary(baseConfig).uploader().deleteByToken(token);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"ok", res.get("result"));
    }

    @Test
    public void testUpload() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"colors", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("width"), (Object)241);
        Assert.assertEquals(result.get("height"), (Object)51);
        Assert.assertNotNull(result.get("colors"));
        Assert.assertNotNull(result.get("predominant"));
        HashMap to_sign = new HashMap();
        to_sign.put("public_id", result.get("public_id"));
        to_sign.put("version", ObjectUtils.asString(result.get("version")));
        String expected_signature = this.cloudinary.apiSignRequest(to_sign, this.cloudinary.config.apiSecret);
        Assert.assertEquals(result.get("signature"), (Object)expected_signature);
    }

    @Test
    public void testIsRemoteUrl() {
        String[] invalidUrls;
        String[] urls;
        for (String url : urls = new String[]{"ftp://ftp.cloudinary.com/images/old_logo.png", "http://cloudinary.com/images/old_logo.png", "https://cloudinary.com/images/old_logo.png", "s3://s3-us-west-2.amazonaws.com/cloudinary/images/old_logo.png", "gs://cloudinary/images/old_logo.png", "data:image/gif;charset=utf8;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7", "data:image/gif;param1=value1;param2=value2;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7", "data:image/svg+xml;charset=utf-8;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPg"}) {
            Assert.assertTrue((boolean)StringUtils.isRemoteUrl((String)url));
        }
        for (String url : invalidUrls = new String[]{"adsadasdasdasd", "     ", ""}) {
            Assert.assertFalse((boolean)StringUtils.isRemoteUrl((String)url));
        }
    }

    @Test
    public void testUploadUrl() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"http://cloudinary.com/images/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("width"), (Object)241);
        Assert.assertEquals(result.get("height"), (Object)51);
        HashMap to_sign = new HashMap();
        to_sign.put("public_id", result.get("public_id"));
        to_sign.put("version", ObjectUtils.asString(result.get("version")));
        String expected_signature = this.cloudinary.apiSignRequest(to_sign, this.cloudinary.config.apiSecret);
        Assert.assertEquals(result.get("signature"), (Object)expected_signature);
    }

    @Test
    public void testUploadLargeUrl() throws IOException {
        Map result = this.cloudinary.uploader().uploadLarge((Object)"http://cloudinary.com/images/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("width"), (Object)241);
        Assert.assertEquals(result.get("height"), (Object)51);
        HashMap to_sign = new HashMap();
        to_sign.put("public_id", result.get("public_id"));
        to_sign.put("version", ObjectUtils.asString(result.get("version")));
        String expected_signature = this.cloudinary.apiSignRequest(to_sign, this.cloudinary.config.apiSecret);
        Assert.assertEquals(result.get("signature"), (Object)expected_signature);
    }

    @Test
    public void testUploadDataUri() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"data:image/png;base64,iVBORw0KGgoAA\nAANSUhEUgAAABAAAAAQAQMAAAAlPW0iAAAABlBMVEUAAAD///+l2Z/dAAAAM0l\nEQVR4nGP4/5/h/1+G/58ZDrAz3D/McH8yw83NDDeNGe4Ug9C9zwz3gVLMDA/A6\nP9/AFGGFyjOXZtQAAAAAElFTkSuQmCC", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("width"), (Object)16);
        Assert.assertEquals(result.get("height"), (Object)16);
        HashMap to_sign = new HashMap();
        to_sign.put("public_id", result.get("public_id"));
        to_sign.put("version", ObjectUtils.asString(result.get("version")));
        String expected_signature = this.cloudinary.apiSignRequest(to_sign, this.cloudinary.config.apiSecret);
        Assert.assertEquals(result.get("signature"), (Object)expected_signature);
    }

    @Test
    public void testUploadUTF8() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"public_id", "Plattenkreiss_\u00f1g-\u00e9", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("public_id"), (Object)"Plattenkreiss_\u00f1g-\u00e9");
        this.cloudinary.uploader().upload(result.get("url"), ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
    }

    @Test
    public void testRename() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Object publicId = result.get("public_id");
        String publicId2 = "folder/" + publicId + "2";
        this.cloudinary.uploader().rename((String)publicId, publicId2, ObjectUtils.emptyMap());
        Assert.assertNotNull((Object)this.cloudinary.api().resource(publicId2, ObjectUtils.emptyMap()));
        Map result2 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/favicon.ico", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        boolean error_found = false;
        try {
            this.cloudinary.uploader().rename((String)result2.get("public_id"), publicId2, ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        }
        catch (Exception e) {
            error_found = true;
        }
        Assert.assertTrue((boolean)error_found);
        this.cloudinary.uploader().rename((String)result2.get("public_id"), publicId2, ObjectUtils.asMap((Object[])new Object[]{"overwrite", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)this.cloudinary.api().resource(publicId2, ObjectUtils.emptyMap()).get((Object)"format"), (Object)"ico");
    }

    @Test
    public void testRenameShouldReturnContext() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG), "context", ObjectUtils.asMap((Object[])new Object[]{"foo", "boo"})}));
        String publicId = result.get("public_id").toString();
        String publicId2 = "folder/" + publicId + "2";
        Map renameResult = this.cloudinary.uploader().rename(publicId, publicId2, ObjectUtils.asMap((Object[])new Object[]{"context", true}));
        Assert.assertNotNull(renameResult.get("context"));
    }

    @Test
    public void testRenameShouldReturnMetadata() throws Exception {
        String label = "test" + SUFFIX;
        StringMetadataField f = MetadataTestHelper.newFieldInstance(label);
        ApiResponse fieldResult = MetadataTestHelper.addFieldToAccount(this.cloudinary.api(), (MetadataField)f);
        String fieldId = fieldResult.get("external_id").toString();
        Map<String, String> metadata = Collections.singletonMap(fieldId, "123456");
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG), "metadata", metadata}));
        String publicId = result.get("public_id").toString();
        String publicId2 = "folder/" + publicId + "2";
        Map renameResult = this.cloudinary.uploader().rename(publicId, publicId2, ObjectUtils.asMap((Object[])new Object[]{"metadata", true}));
        Assert.assertNotNull(renameResult.get("metadata"));
    }

    @Test
    public void testUniqueFilename() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertTrue((boolean)((String)result.get("public_id")).matches("old_logo_[a-z0-9]{6}"));
        result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "unique_filename", false, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("public_id"), (Object)"old_logo");
    }

    @Test
    public void testExplicit() throws IOException {
        Map result = this.cloudinary.uploader().explicit(UPLOADER_TEST_PUBLIC_ID, ObjectUtils.asMap((Object[])new Object[]{"eager", Collections.singletonList(new Transformation().crop("scale").width((Object)2.0)), "type", "upload", "moderation", "manual"}));
        String url = this.cloudinary.url().transformation(new Transformation().crop("scale").width((Object)2.0)).format("jpg").version(result.get("version")).generate(UPLOADER_TEST_PUBLIC_ID);
        String eagerUrl = (String)((Map)((List)result.get("eager")).get(0)).get("url");
        String cloudName = this.cloudinary.config.cloudName;
        Assert.assertEquals((Object)eagerUrl.substring(eagerUrl.indexOf(cloudName)), (Object)url.substring(url.indexOf(cloudName)));
    }

    @Test
    public void testEager() throws IOException {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"eager", Collections.singletonList(new Transformation().crop("scale").width((Object)2.0)), "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
    }

    @Test
    public void testUploadAsync() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().crop("scale").width((Object)2.0), "async", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)((String)result.get("status")), (Object)"pending");
    }

    @Test
    public void testHeaders() throws IOException {
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"headers", new String[]{"Link: 1"}, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"headers", ObjectUtils.asMap((Object[])new Object[]{"Link", "1"}), "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
    }

    @Test
    public void testText() throws Exception {
        Map result = this.cloudinary.uploader().text("hello world", ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        this.addToDeleteList("text", result.get("public_id").toString());
        Assert.assertTrue(((Integer)result.get("width") > 1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)result.get("height") > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testImageUploadTag() {
        String tag = this.cloudinary.uploader().imageUploadTag("test-field", ObjectUtils.asMap((Object[])new Object[]{"callback", "http://localhost/cloudinary_cors.html"}), ObjectUtils.asMap((Object[])new Object[]{"htmlattr", "htmlvalue"}));
        Assert.assertTrue((boolean)tag.contains("type='file'"));
        Assert.assertTrue((boolean)tag.contains("data-cloudinary-field='test-field'"));
        Assert.assertTrue((boolean)tag.contains("class='cloudinary-fileupload'"));
        Assert.assertTrue((boolean)tag.contains("htmlattr='htmlvalue'"));
        tag = this.cloudinary.uploader().imageUploadTag("test-field", ObjectUtils.asMap((Object[])new Object[]{"callback", "http://localhost/cloudinary_cors.html"}), ObjectUtils.asMap((Object[])new Object[]{"class", "myclass"}));
        Assert.assertTrue((boolean)tag.contains("class='cloudinary-fileupload myclass'"));
    }

    @Test
    public void testEvalUploadParameter() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"eval", SRC_TEST_EVAL, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertTrue((result.get("quality_analysis") != null && ((HashMap)result.get("quality_analysis")).containsKey("focus") ? 1 : 0) != 0);
        Map custom = (Map)((Map)result.get("context")).get("custom");
        Assert.assertEquals(custom.get("width"), (Object)Integer.toString(241));
    }

    @Test
    public void testSprite() throws Exception {
        String sprite_test_tag = String.format("sprite_test_tag_%d", new Date().getTime());
        Map uploadResult1 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{sprite_test_tag, SDK_TEST_TAG, UPLOADER_TAG}, "public_id", "sprite_test_tag_1" + SUFFIX}));
        Map uploadResult2 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{sprite_test_tag, SDK_TEST_TAG, UPLOADER_TAG}, "public_id", "sprite_test_tag_2" + SUFFIX}));
        String[] urls = new String[]{uploadResult1.get("url").toString(), uploadResult2.get("url").toString()};
        Map result = this.cloudinary.uploader().generateSprite(urls, ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        this.addToDeleteList("sprite", result.get("public_id").toString());
        Assert.assertEquals((long)2L, (long)((Map)result.get("image_infos")).size());
        result = this.cloudinary.uploader().generateSprite(sprite_test_tag, ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        this.addToDeleteList("sprite", result.get("public_id").toString());
        Assert.assertEquals((long)2L, (long)((Map)result.get("image_infos")).size());
        result = this.cloudinary.uploader().generateSprite(sprite_test_tag, ObjectUtils.asMap((Object[])new Object[]{"transformation", "w_100"}));
        this.addToDeleteList("sprite", result.get("public_id").toString());
        Assert.assertTrue((boolean)((String)result.get("css_url")).contains("w_100"));
        result = this.cloudinary.uploader().generateSprite(sprite_test_tag, ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().width((Object)100), "format", "jpg"}));
        this.addToDeleteList("sprite", result.get("public_id").toString());
        Assert.assertTrue((boolean)((String)result.get("css_url")).contains("f_jpg,w_100"));
    }

    @Test
    public void testMulti() throws Exception {
        String MULTI_TEST_TAG = "multi_test_tag" + SUFFIX;
        Map options = ObjectUtils.asMap((Object[])new Object[]{"tags", new String[]{MULTI_TEST_TAG, SDK_TEST_TAG, UPLOADER_TAG}});
        Map uploadResult1 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        Map uploadResult2 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", options);
        String[] urls = new String[]{uploadResult1.get("url").toString(), uploadResult2.get("url").toString()};
        Map result = this.cloudinary.uploader().multi(urls, ObjectUtils.asMap((Object[])new Object[]{"transformation", "c_crop,w_0.5"}));
        this.addToDeleteList("multi", result.get("public_id").toString());
        Assert.assertTrue((boolean)((String)result.get("url")).endsWith(".gif"));
        Assert.assertTrue((boolean)((String)result.get("url")).contains("w_0.5"));
        ArrayList ids = new ArrayList();
        result = this.cloudinary.uploader().multi(MULTI_TEST_TAG, ObjectUtils.asMap((Object[])new Object[]{"transformation", "c_crop,w_0.5"}));
        this.addToDeleteList("multi", result.get("public_id").toString());
        Map pdfResult = this.cloudinary.uploader().multi(MULTI_TEST_TAG, ObjectUtils.asMap((Object[])new Object[]{"transformation", new Transformation().width((Object)111), "format", "pdf"}));
        this.addToDeleteList("multi", pdfResult.get("public_id").toString());
        Assert.assertTrue((boolean)((String)result.get("url")).endsWith(".gif"));
        Assert.assertTrue((boolean)((String)result.get("url")).contains("w_0.5"));
        Assert.assertTrue((boolean)((String)pdfResult.get("url")).contains("w_111"));
        Assert.assertTrue((boolean)((String)pdfResult.get("url")).endsWith(".pdf"));
    }

    @Test
    public void testTags() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.emptyMap());
        String public_id = (String)result.get("public_id");
        this.addToDeleteList("upload", public_id);
        Map result2 = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.emptyMap());
        String public_id2 = (String)result2.get("public_id");
        this.addToDeleteList("upload", public_id2);
        this.cloudinary.uploader().addTag("tag1", new String[]{public_id, public_id2}, ObjectUtils.emptyMap());
        this.cloudinary.uploader().addTag("tag2", new String[]{public_id}, ObjectUtils.emptyMap());
        this.cloudinary.uploader().addTag(new String[]{"tag4", "tag5"}, new String[]{public_id}, ObjectUtils.emptyMap());
        List tags = (List)this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag1", "tag2", "tag4", "tag5"}));
        tags = (List)this.cloudinary.api().resource(public_id2, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag1"}));
        this.cloudinary.uploader().removeTag("tag1", new String[]{public_id}, ObjectUtils.emptyMap());
        tags = (List)this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag2", "tag4", "tag5"}));
        this.cloudinary.uploader().removeTag(new String[]{"tag4", "tag5"}, new String[]{public_id}, ObjectUtils.emptyMap());
        tags = (List)this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag2"}));
        this.cloudinary.uploader().replaceTag("tag3", new String[]{public_id}, ObjectUtils.emptyMap());
        tags = (List)this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag3"}));
        this.cloudinary.uploader().replaceTag(new String[]{"tag6", "tag7"}, new String[]{public_id}, ObjectUtils.emptyMap());
        tags = (List)this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap()).get((Object)"tags");
        Assert.assertEquals((Object)tags, (Object)ObjectUtils.asArray((Object)new String[]{"tag6", "tag7"}));
        result = this.cloudinary.uploader().removeAllTags(new String[]{public_id, public_id2, "noSuchId"}, ObjectUtils.emptyMap());
        List publicIds = (List)result.get("public_ids");
        Assert.assertThat((Object)publicIds, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{public_id, public_id2}));
        result = this.cloudinary.api().resource(public_id, ObjectUtils.emptyMap());
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"tags")));
    }

    @Test
    public void testAllowedFormats() throws Exception {
        String[] formats = new String[]{"png"};
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"allowed_formats", formats, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals(result.get("format"), (Object)"png");
    }

    @Test
    public void testAllowedFormatsWithIllegalFormat() throws Exception {
        boolean errorFound = false;
        String[] formats = new String[]{"jpg"};
        try {
            this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"allowed_formats", formats, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        }
        catch (Exception e) {
            errorFound = true;
        }
        Assert.assertTrue((boolean)errorFound);
    }

    @Test
    public void testAllowedFormatsWithFormat() throws Exception {
        String[] formats = new String[]{"jpg"};
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"allowed_formats", formats, "format", "jpg", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)"jpg", result.get("format"));
    }

    @Test
    public void testFaceCoordinates() throws Exception {
        Coordinates coordinates = new Coordinates();
        Rectangle rect1 = new Rectangle(121, 31, 110, 51);
        Rectangle rect2 = new Rectangle(120, 30, 109, 51);
        coordinates.addRect(rect1);
        coordinates.addRect(rect2);
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"face_coordinates", coordinates, "faces", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        ArrayList resultFaces = (ArrayList)result.get("faces");
        Assert.assertEquals((long)2L, (long)resultFaces.size());
        Object[] resultCoordinates = ((ArrayList)resultFaces.get(0)).toArray();
        Assert.assertEquals((Object)rect1.x, (Object)resultCoordinates[0]);
        Assert.assertEquals((Object)rect1.y, (Object)resultCoordinates[1]);
        Assert.assertEquals((Object)rect1.width, (Object)resultCoordinates[2]);
        Assert.assertEquals((Object)rect1.height, (Object)resultCoordinates[3]);
        resultCoordinates = ((ArrayList)resultFaces.get(1)).toArray();
        Assert.assertEquals((Object)rect2.x, (Object)resultCoordinates[0]);
        Assert.assertEquals((Object)rect2.y, (Object)resultCoordinates[1]);
        Assert.assertEquals((Object)rect2.width, (Object)resultCoordinates[2]);
        Assert.assertEquals((Object)rect2.height, (Object)resultCoordinates[3]);
        Coordinates differentCoordinates = new Coordinates();
        Rectangle rect3 = new Rectangle(122, 32, 111, 152);
        differentCoordinates.addRect(rect3);
        this.cloudinary.uploader().explicit((String)result.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"face_coordinates", differentCoordinates, "faces", true, "type", "upload"}));
        ApiResponse info = this.cloudinary.api().resource((String)result.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"faces", true}));
        resultFaces = (ArrayList)info.get("faces");
        Assert.assertEquals((long)1L, (long)resultFaces.size());
        resultCoordinates = ((ArrayList)resultFaces.get(0)).toArray();
        Assert.assertEquals((Object)rect3.x, (Object)resultCoordinates[0]);
        Assert.assertEquals((Object)rect3.y, (Object)resultCoordinates[1]);
        Assert.assertEquals((Object)rect3.width, (Object)resultCoordinates[2]);
        Assert.assertEquals((Object)rect3.height, (Object)resultCoordinates[3]);
    }

    @Test
    public void testCustomCoordinates() throws Exception {
        int i;
        Coordinates coordinates = new Coordinates("121,31,300,151");
        Map uploadResult = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"custom_coordinates", coordinates, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        ApiResponse result = this.cloudinary.api().resource(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"coordinates", true}));
        int[] expected = new int[]{121, 31, 241, 51};
        Object[] actual = ((ArrayList)((ArrayList)((Map)result.get("coordinates")).get("custom")).get(0)).toArray();
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        coordinates = new Coordinates(new int[]{122, 32, 341, 151});
        this.cloudinary.uploader().explicit((String)uploadResult.get("public_id"), ObjectUtils.asMap((Object[])new Object[]{"custom_coordinates", coordinates, "coordinates", true, "type", "upload"}));
        result = this.cloudinary.api().resource(uploadResult.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"coordinates", true}));
        expected = new int[]{122, 32, 341, 151};
        actual = ((ArrayList)((ArrayList)((Map)result.get("coordinates")).get("custom")).get(0)).toArray();
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testModerationRequest() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"moderation", "manual", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)"manual", ((Map)((List)result.get("moderation")).get(0)).get("kind"));
        Assert.assertEquals((Object)"pending", ((Map)((List)result.get("moderation")).get(0)).get("status"));
    }

    @Test
    public void testRawConvertRequest() {
        try {
            this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"raw_convert", "illegal", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Raw convert is invalid"));
        }
    }

    @Test
    public void testCategorizationRequest() {
        String errorMessage = "";
        try {
            this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"categorization", "illegal", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        Assert.assertTrue((boolean)errorMessage.contains("Categorization item illegal is not valid"));
    }

    @Test
    public void testDetectionRequest() {
        String message = null;
        try {
            this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"detection", "illegal", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        Assert.assertTrue((boolean)"Detection invalid model 'illegal'".equals(message));
    }

    @Test
    public void testUploadLarge() throws Exception {
        File temp = File.createTempFile("cldupload.test.", "");
        FileOutputStream out = new FileOutputStream(temp);
        int[] header = new int[]{66, 77, 74, 185, 89, 0, 0, 0, 0, 0, 138, 0, 0, 0, 124, 0, 0, 0, 120, 5, 0, 0, 120, 5, 0, 0, 1, 0, 24, 0, 0, 0, 0, 0, 192, 184, 89, 0, 97, 15, 0, 0, 97, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 255, 0, 0, 255, 0, 0, 0, 0, 0, 0, 255, 66, 71, 82, 115, 0, 0, 0, 0, 0, 0, 0, 0, 84, 184, 30, 252, 0, 0, 0, 0, 0, 0, 0, 0, 102, 102, 102, 252, 0, 0, 0, 0, 0, 0, 0, 0, 196, 245, 40, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byteHeader = new byte[138];
        for (int i = 0; i <= 137; ++i) {
            byteHeader[i] = (byte)header[i];
        }
        byte[] piece = new byte[10];
        Arrays.fill(piece, (byte)-1);
        out.write(byteHeader);
        for (int i = 1; i <= 588000; ++i) {
            out.write(piece);
        }
        out.close();
        Assert.assertEquals((long)5880138L, (long)temp.length());
        Object[] tags = new String[]{"upload_large_tag_" + SUFFIX, SDK_TEST_TAG, UPLOADER_TAG};
        Map resource = this.cloudinary.uploader().uploadLarge((Object)temp, ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "resource_type", "raw", "chunk_size", 5243000, "tags", tags}));
        Assert.assertArrayEquals((Object[])tags, (Object[])((ArrayList)resource.get("tags")).toArray());
        Assert.assertEquals((Object)"raw", resource.get("resource_type"));
        Assert.assertTrue((boolean)resource.get("public_id").toString().startsWith("cldupload"));
        resource = this.cloudinary.uploader().uploadLarge((Object)new FileInputStream(temp), ObjectUtils.asMap((Object[])new Object[]{"chunk_size", 5243000, "tags", tags}));
        Assert.assertArrayEquals((Object[])tags, (Object[])((ArrayList)resource.get("tags")).toArray());
        Assert.assertEquals((Object)"image", resource.get("resource_type"));
        Assert.assertEquals((Object)1400, resource.get("width"));
        Assert.assertEquals((Object)1400, resource.get("height"));
        resource = this.cloudinary.uploader().uploadLarge((Object)temp, ObjectUtils.asMap((Object[])new Object[]{"chunk_size", 5880138, "tags", tags}));
        Assert.assertArrayEquals((Object[])tags, (Object[])((ArrayList)resource.get("tags")).toArray());
        Assert.assertEquals((Object)"image", resource.get("resource_type"));
        Assert.assertEquals((Object)1400, resource.get("width"));
        Assert.assertEquals((Object)1400, resource.get("height"));
        resource = this.cloudinary.uploader().uploadLarge((Object)new FileInputStream(temp), ObjectUtils.asMap((Object[])new Object[]{"chunk_size", 5880138, "tags", tags}));
        Assert.assertArrayEquals((Object[])tags, (Object[])((ArrayList)resource.get("tags")).toArray());
        Assert.assertEquals((Object)"image", resource.get("resource_type"));
        Assert.assertEquals((Object)1400, resource.get("width"));
        Assert.assertEquals((Object)1400, resource.get("height"));
    }

    @Test
    public void testUnsignedUpload() throws Exception {
        ApiResponse preset = this.cloudinary.api().createUploadPreset(ObjectUtils.asMap((Object[])new Object[]{"folder", "upload_folder", "unsigned", true}));
        Map result = this.cloudinary.uploader().unsignedUpload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", preset.get("name").toString(), ObjectUtils.asMap((Object[])new Object[]{"tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertTrue((boolean)result.get("public_id").toString().matches("^upload_folder\\/[a-z0-9]+$"));
        this.cloudinary.api().deleteUploadPreset(preset.get("name").toString(), ObjectUtils.emptyMap());
    }

    @Test
    public void testFilenameOption() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"filename", "emanelif", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)"emanelif", result.get("original_filename"));
    }

    @Test
    public void testFilenameOverrideOption() throws Exception {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"filename_override", "overridden", "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertEquals((Object)"overridden", result.get("original_filename"));
    }

    @Test
    public void testResponsiveBreakpoints() throws Exception {
        ResponsiveBreakpoint breakpoint = new ResponsiveBreakpoint().createDerived(true).maxImages(Integer.valueOf(2)).transformation(new Transformation().angle(90)).format("gif");
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"responsive_breakpoints", breakpoint, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        ArrayList breakpointsResponse = (ArrayList)result.get("responsive_breakpoints");
        Map map = (Map)breakpointsResponse.get(0);
        ArrayList breakpoints = (ArrayList)map.get("breakpoints");
        Assert.assertTrue((boolean)((Map)breakpoints.get(0)).get("url").toString().endsWith("gif"));
        Assert.assertEquals((Object)"a_90", map.get("transformation"));
        breakpoint.transformation(new Transformation().effect("sepia"));
        result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"responsive_breakpoints", new ResponsiveBreakpoint[]{breakpoint}, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        breakpointsResponse = (ArrayList)result.get("responsive_breakpoints");
        breakpoints = (ArrayList)((Map)breakpointsResponse.get(0)).get("breakpoints");
        Assert.assertEquals((long)2L, (long)breakpoints.size());
        Assert.assertTrue((boolean)((Map)breakpoints.get(0)).get("url").toString().endsWith("gif"));
        JSONArray array = new JSONArray();
        array.put((Object)breakpoint);
        result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"responsive_breakpoints", array, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        breakpointsResponse = (ArrayList)result.get("responsive_breakpoints");
        breakpoints = (ArrayList)((Map)breakpointsResponse.get(0)).get("breakpoints");
        Assert.assertEquals((long)2L, (long)breakpoints.size());
    }

    @Test
    public void testCreateArchive() throws Exception {
        ArrayList<String> toDelete = new ArrayList<String>(2);
        Map result = this.cloudinary.uploader().createArchive(new ArchiveParams().tags(new String[]{ARCHIVE_TAG}));
        toDelete.add(result.get("public_id").toString());
        Assert.assertEquals((Object)2, result.get("file_count"));
        result = this.cloudinary.uploader().createArchive(new ArchiveParams().tags(new String[]{ARCHIVE_TAG}).transformations(new Transformation[]{new Transformation().width((Object)0.5), new Transformation().width((Object)2.0)}));
        toDelete.add(result.get("public_id").toString());
        Assert.assertEquals((Object)4, result.get("file_count"));
        this.cloudinary.api().deleteResources(toDelete, ObjectUtils.asMap((Object[])new Object[]{"resource_type", "raw"}));
    }

    @Test
    public void testCreateArchiveRaw() throws Exception {
        Map result = this.cloudinary.uploader().createArchive(new ArchiveParams().tags(new String[]{ARCHIVE_TAG}).resourceType("raw"));
        Assert.assertEquals((Object)1, result.get("file_count"));
        this.cloudinary.api().deleteResources(Arrays.asList(result.get("public_id").toString()), ObjectUtils.asMap((Object[])new Object[]{"resource_type", "raw"}));
    }

    @Test
    public void testCreateZipMultipleResourceTypes() throws Exception {
        Map result = this.cloudinary.uploader().createZip(ObjectUtils.asMap((Object[])new Object[]{"fully_qualified_public_ids", new String[]{SRC_FULLY_QUALIFIED_IMAGE, SRC_FULLY_QUALIFIED_VIDEO}, "resource_type", "auto"}));
        Assert.assertEquals((Object)2, result.get("file_count"));
        this.cloudinary.api().deleteResources(Arrays.asList(result.get("public_id").toString()), ObjectUtils.asMap((Object[])new Object[]{"resource_type", "raw"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadArchive() throws Exception {
        String result = this.cloudinary.downloadArchive(new ArchiveParams().tags(new String[]{ARCHIVE_TAG}).targetTags(new String[]{UPLOADER_TAG}));
        URL url = new URL(result);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        int files = 0;
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(urlConnection.getInputStream()));){
            while (in.getNextEntry() != null) {
                ++files;
            }
        }
        Assert.assertEquals((long)2L, (long)files);
    }

    public void testUploadInvalidUrl() {
        try {
            this.cloudinary.uploader().upload((Object)"http://cloudinary.com/images/old_logo.png\n", ObjectUtils.asMap((Object[])new Object[]{"return_error", true}));
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"File not found or unreadable: http://cloudinary.com/images/old_logo.png\n");
        }
    }

    @Test
    public void testAccessControl() throws ParseException, IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Date start = simpleDateFormat.parse("2019-02-22 16:20:57 +0200");
        Date end = simpleDateFormat.parse("2019-03-22 00:00:00 +0200");
        AccessControlRule token = AccessControlRule.token();
        AccessControlRule acl = AccessControlRule.anonymous((Date)start, null);
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"access_control", Arrays.asList(acl, token), "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull((Object)result);
        List accessControlResponse = (List)result.get("access_control");
        Assert.assertNotNull((Object)accessControlResponse);
        Assert.assertEquals((long)2L, (long)accessControlResponse.size());
        Map acr = (Map)accessControlResponse.get(0);
        Assert.assertEquals((Object)"anonymous", acr.get("access_type"));
        Assert.assertEquals((Object)"2019-02-22T14:20:57Z", acr.get("start"));
        Assert.assertThat((Object)acr, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"end")));
        acr = (Map)accessControlResponse.get(1);
        Assert.assertEquals((Object)"token", acr.get("access_type"));
        Assert.assertThat((Object)acr, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"start")));
        Assert.assertThat((Object)acr, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"end")));
        result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"access_control", acl, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull((Object)result);
        accessControlResponse = (List)result.get("access_control");
        Assert.assertNotNull((Object)accessControlResponse);
        acr = (Map)accessControlResponse.get(0);
        Assert.assertEquals((long)1L, (long)accessControlResponse.size());
        Assert.assertEquals((Object)"anonymous", acr.get("access_type"));
        Assert.assertEquals((Object)"2019-02-22T14:20:57Z", acr.get("start"));
        Assert.assertThat((Object)acr, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"end")));
        String aclString = "[{\"access_type\":\"anonymous\",\"start\":\"2019-02-22 16:20:57 +0200\",\"end\":\"2019-03-22 00:00 +0200\"}]";
        result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"access_control", aclString, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull((Object)result);
        accessControlResponse = (List)result.get("access_control");
        Assert.assertNotNull((Object)accessControlResponse);
        Assert.assertTrue((accessControlResponse.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"anonymous", ((Map)accessControlResponse.get(0)).get("access_type"));
        Assert.assertEquals((Object)"2019-02-22T14:20:57Z", ((Map)accessControlResponse.get(0)).get("start"));
        Assert.assertEquals((Object)"2019-03-21T22:00:00Z", ((Map)accessControlResponse.get(0)).get("end"));
    }

    @Test
    public void testQualityAnalysis() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"quality_analysis", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull(result.get("quality_analysis"));
        result = this.cloudinary.uploader().explicit(result.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "quality_analysis", true}));
        Assert.assertNotNull(result.get("quality_analysis"));
    }

    @Test
    public void testCinemagraphAnalysisUpload() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"cinemagraph_analysis", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull(result.get("cinemagraph_analysis"));
        result = this.cloudinary.uploader().explicit(result.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "cinemagraph_analysis", true}));
        Assert.assertNotNull(result.get("cinemagraph_analysis"));
    }

    @Test
    public void testAccessibilityAnalysisUpload() throws IOException {
        Map result = this.cloudinary.uploader().upload((Object)"../cloudinary-test-common/src/main/resources/old_logo.png", ObjectUtils.asMap((Object[])new Object[]{"accessibility_analysis", true, "tags", Arrays.asList(SDK_TEST_TAG, UPLOADER_TAG)}));
        Assert.assertNotNull(result.get("accessibility_analysis"));
        result = this.cloudinary.uploader().explicit(result.get("public_id").toString(), ObjectUtils.asMap((Object[])new Object[]{"type", "upload", "resource_type", "image", "accessibility_analysis", true}));
        Assert.assertNotNull(result.get("accessibility_analysis"));
    }

    private void addToDeleteList(String type, String id) {
        Set<String> ids = toDelete.get(type);
        if (ids == null) {
            ids = new HashSet<String>();
            toDelete.put(type, ids);
        }
        ids.add(id);
    }

    @Test
    public void testUploadFolderDecoupling() {
        Map options = ObjectUtils.asMap((Object[])new Object[]{"use_filename_as_display_name", true, "public_id_prefix", "test_id_prefix", "asset_folder", "asset_folder_test", "display_name", "display_name_test"});
        Map uploadParams = Util.buildUploadParams((Map)options);
        Assert.assertEquals((Object)"test_id_prefix", uploadParams.get("public_id_prefix"));
        Assert.assertEquals((Object)true, uploadParams.get("use_filename_as_display_name"));
        Assert.assertEquals((Object)"asset_folder_test", uploadParams.get("asset_folder"));
        Assert.assertEquals((Object)"display_name_test", uploadParams.get("display_name"));
    }
}

