/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assume;

public class MockableTest {
    public static final String SRC_TEST_IMAGE = "../cloudinary-test-common/src/main/resources/old_logo.png";
    public static final String SRC_TEST_VIDEO = "http://res.cloudinary.com/demo/video/upload/dog.mp4";
    public static final String SRC_TEST_RAW = "../cloudinary-test-common/src/main/resources/docx.docx";
    public static final String REMOTE_TEST_IMAGE = "http://cloudinary.com/images/old_logo.png";
    protected static String SUFFIX = StringUtils.isNotBlank((String)System.getenv("TRAVIS_JOB_ID")) ? System.getenv("TRAVIS_JOB_ID") : String.valueOf(new Random().nextInt(99999));
    protected static final String SDK_TEST_TAG = "cloudinary_java_test_" + SUFFIX;
    protected Cloudinary cloudinary;
    private static final List<String> enabledAddons = MockableTest.getEnabledAddons();

    protected Object getParam(String name) {
        throw new UnsupportedOperationException();
    }

    protected String getURL() {
        throw new UnsupportedOperationException();
    }

    protected String getHttpMethod() {
        throw new UnsupportedOperationException();
    }

    protected Map preloadResource(Map options) throws IOException {
        if (!options.containsKey("tags")) {
            throw new IllegalArgumentException("Must provide unique per-class tags");
        }
        Map combinedOptions = ObjectUtils.asMap((Object[])new Object[]{"transformation", "c_scale,w_100"});
        combinedOptions.putAll(options);
        return this.cloudinary.uploader().upload((Object)"http://res.cloudinary.com/demo/image/upload/sample", combinedOptions);
    }

    protected void assumeAddonEnabled(String addon) throws Exception {
        boolean enabled = enabledAddons.contains(addon.toLowerCase()) || enabledAddons.size() == 1 && enabledAddons.get(0).equalsIgnoreCase("all");
        Assume.assumeTrue((String)String.format("Use CLD_TEST_ADDONS environment variable to enable tests for %s.", addon), (boolean)enabled);
    }

    private static List<String> getEnabledAddons() {
        String envAddons = System.getenv().getOrDefault("CLD_TEST_ADDONS", "").toLowerCase().replaceAll("\\s", "");
        return Arrays.asList(envAddons.split(","));
    }
}

