/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.test.rules;

import java.util.Objects;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule {
    private int retryCount;
    private int delay;

    public RetryRule(int retryCount, int delay) {
        this.retryCount = retryCount;
        this.delay = delay;
    }

    public RetryRule() {
        this.retryCount = 3;
        this.delay = 3;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                for (int i = 0; i < RetryRule.this.retryCount; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        caughtThrowable = t;
                        System.err.println(description.getDisplayName() + ": run " + (i + 1) + " failed.");
                        Thread.sleep(RetryRule.this.delay * 1000);
                        continue;
                    }
                }
                System.err.println(description.getDisplayName() + ": Giving up after " + RetryRule.this.retryCount + " failures.");
                throw Objects.requireNonNull(caughtThrowable);
            }
        };
    }
}

