/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.media_editing.model;

import com.cloudinary.media_editing.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MediaConnectorInstance {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_FWD_KEY = "fwd_key";
    @SerializedName(value="fwd_key")
    private String fwdKey;
    public static final String SERIALIZED_NAME_TEMPLATE_VARIABLES = "template_variables";
    @SerializedName(value="template_variables")
    private Map<String, String> templateVariables = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MediaConnectorInstance id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="123456789", required=true, value="The ID of the media source or target")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MediaConnectorInstance fwdKey(String fwdKey) {
        this.fwdKey = fwdKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sample", required=true, value="An identifier for the media within a media source or target")
    public String getFwdKey() {
        return this.fwdKey;
    }

    public void setFwdKey(String fwdKey) {
        this.fwdKey = fwdKey;
    }

    public MediaConnectorInstance templateVariables(Map<String, String> templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    public MediaConnectorInstance putTemplateVariablesItem(String key, String templateVariablesItem) {
        if (this.templateVariables == null) {
            this.templateVariables = new HashMap<String, String>();
        }
        this.templateVariables.put(key, templateVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(Map<String, String> templateVariables) {
        this.templateVariables = templateVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaConnectorInstance mediaConnectorInstance = (MediaConnectorInstance)o;
        return Objects.equals(this.id, mediaConnectorInstance.id) && Objects.equals(this.fwdKey, mediaConnectorInstance.fwdKey) && Objects.equals(this.templateVariables, mediaConnectorInstance.templateVariables);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fwdKey, this.templateVariables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaConnectorInstance {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    fwdKey: ").append(this.toIndentedString(this.fwdKey)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MediaConnectorInstance is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MediaConnectorInstance` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FWD_KEY) != null && !jsonObj.get(SERIALIZED_NAME_FWD_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fwd_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FWD_KEY).toString()));
        }
    }

    public static MediaConnectorInstance fromJson(String jsonString) throws IOException {
        return (MediaConnectorInstance)JSON.getGson().fromJson(jsonString, MediaConnectorInstance.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_FWD_KEY);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE_VARIABLES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FWD_KEY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MediaConnectorInstance.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MediaConnectorInstance.class));
            return new TypeAdapter<MediaConnectorInstance>(){

                public void write(JsonWriter out, MediaConnectorInstance value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MediaConnectorInstance read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MediaConnectorInstance.validateJsonObject(jsonObj);
                    return (MediaConnectorInstance)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

