/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.media_editing.model;

import com.cloudinary.media_editing.JSON;
import com.cloudinary.media_editing.model.MediaConnectorInstance;
import com.cloudinary.media_editing.model.TransformationDescriptor;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TransformRequest {
    public static final String SERIALIZED_NAME_INPUT_TYPE = "input_type";
    @SerializedName(value="input_type")
    private InputTypeEnum inputType;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resource_type";
    @SerializedName(value="resource_type")
    private ResourceTypeEnum resourceType;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URI url;
    public static final String SERIALIZED_NAME_MEDIA_SOURCE = "media_source";
    @SerializedName(value="media_source")
    private MediaConnectorInstance mediaSource;
    public static final String SERIALIZED_NAME_TRANSFORMATION_DESCRIPTOR = "transformation_descriptor";
    @SerializedName(value="transformation_descriptor")
    private TransformationDescriptor transformationDescriptor;
    public static final String SERIALIZED_NAME_ASYNC = "async";
    @SerializedName(value="async")
    private Boolean async;
    public static final String SERIALIZED_NAME_NOTIFICATION_URL = "notification_url";
    @SerializedName(value="notification_url")
    private URI notificationUrl;
    public static final String SERIALIZED_NAME_MEDIA_TARGET = "media_target";
    @SerializedName(value="media_target")
    private MediaConnectorInstance mediaTarget;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransformRequest inputType(InputTypeEnum inputType) {
        this.inputType = inputType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="url", required=true, value="The media input type")
    public InputTypeEnum getInputType() {
        return this.inputType;
    }

    public void setInputType(InputTypeEnum inputType) {
        this.inputType = inputType;
    }

    public TransformRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="image", value="The resource type to be processed")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public TransformRequest url(URI url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://res.cloudinary.com/demo/image/upload/demo.jpg", value="URL of the asset to be transformed")
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public TransformRequest mediaSource(MediaConnectorInstance mediaSource) {
        this.mediaSource = mediaSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MediaConnectorInstance getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaConnectorInstance mediaSource) {
        this.mediaSource = mediaSource;
    }

    public TransformRequest transformationDescriptor(TransformationDescriptor transformationDescriptor) {
        this.transformationDescriptor = transformationDescriptor;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TransformationDescriptor getTransformationDescriptor() {
        return this.transformationDescriptor;
    }

    public void setTransformationDescriptor(TransformationDescriptor transformationDescriptor) {
        this.transformationDescriptor = transformationDescriptor;
    }

    public TransformRequest async(Boolean async) {
        this.async = async;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether to perform the request asynchronously. Use a notification URL to be notified once the transformation has completed")
    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public TransformRequest notificationUrl(URI notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://mywebhook.com/webhook", value="The URL to send notifications once a transformation has completed")
    public URI getNotificationUrl() {
        return this.notificationUrl;
    }

    public void setNotificationUrl(URI notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public TransformRequest mediaTarget(MediaConnectorInstance mediaTarget) {
        this.mediaTarget = mediaTarget;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MediaConnectorInstance getMediaTarget() {
        return this.mediaTarget;
    }

    public void setMediaTarget(MediaConnectorInstance mediaTarget) {
        this.mediaTarget = mediaTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformRequest transformRequest = (TransformRequest)o;
        return Objects.equals((Object)this.inputType, (Object)transformRequest.inputType) && Objects.equals((Object)this.resourceType, (Object)transformRequest.resourceType) && Objects.equals(this.url, transformRequest.url) && Objects.equals(this.mediaSource, transformRequest.mediaSource) && Objects.equals(this.transformationDescriptor, transformRequest.transformationDescriptor) && Objects.equals(this.async, transformRequest.async) && Objects.equals(this.notificationUrl, transformRequest.notificationUrl) && Objects.equals(this.mediaTarget, transformRequest.mediaTarget);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputType, this.resourceType, this.url, this.mediaSource, this.transformationDescriptor, this.async, this.notificationUrl, this.mediaTarget});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransformRequest {\n");
        sb.append("    inputType: ").append(this.toIndentedString((Object)this.inputType)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mediaSource: ").append(this.toIndentedString(this.mediaSource)).append("\n");
        sb.append("    transformationDescriptor: ").append(this.toIndentedString(this.transformationDescriptor)).append("\n");
        sb.append("    async: ").append(this.toIndentedString(this.async)).append("\n");
        sb.append("    notificationUrl: ").append(this.toIndentedString(this.notificationUrl)).append("\n");
        sb.append("    mediaTarget: ").append(this.toIndentedString(this.mediaTarget)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransformRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransformRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INPUT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_INPUT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `input_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INPUT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA_SOURCE) != null) {
            MediaConnectorInstance.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA_SOURCE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSFORMATION_DESCRIPTOR) != null) {
            TransformationDescriptor.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSFORMATION_DESCRIPTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFICATION_URL) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFICATION_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `notification_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFICATION_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA_TARGET) != null) {
            MediaConnectorInstance.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA_TARGET));
        }
    }

    public static TransformRequest fromJson(String jsonString) throws IOException {
        return (TransformRequest)JSON.getGson().fromJson(jsonString, TransformRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INPUT_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_MEDIA_SOURCE);
        openapiFields.add(SERIALIZED_NAME_TRANSFORMATION_DESCRIPTOR);
        openapiFields.add(SERIALIZED_NAME_ASYNC);
        openapiFields.add(SERIALIZED_NAME_NOTIFICATION_URL);
        openapiFields.add(SERIALIZED_NAME_MEDIA_TARGET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_INPUT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSFORMATION_DESCRIPTOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransformRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransformRequest.class));
            return new TypeAdapter<TransformRequest>(){

                public void write(JsonWriter out, TransformRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransformRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransformRequest.validateJsonObject(jsonObj);
                    return (TransformRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        IMAGE("image"),
        VIDEO("video");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InputTypeEnum {
        URL("url"),
        MEDIA_SOURCE("media_source");

        private String value;

        private InputTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InputTypeEnum fromValue(String value) {
            for (InputTypeEnum b : InputTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<InputTypeEnum> {
            public void write(JsonWriter jsonWriter, InputTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InputTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InputTypeEnum.fromValue(value);
            }
        }
    }
}

