/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.media_editing.model;

import com.cloudinary.media_editing.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class TransformResult {
    public static final String SERIALIZED_NAME_MEDIA_TYPE = "media_type";
    @SerializedName(value="media_type")
    private String mediaType;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    private String format;
    public static final String SERIALIZED_NAME_MEDIA_BYTE_SIZE = "media_byte_size";
    @SerializedName(value="media_byte_size")
    private Integer mediaByteSize;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private Integer width;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransformResult mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="image", value="The type of the transformed media asset")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public TransformResult format(String format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="png", value="The format of the transformed media asset")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public TransformResult mediaByteSize(Integer mediaByteSize) {
        this.mediaByteSize = mediaByteSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="39999", value="The size of the transformed media in bytes")
    public Integer getMediaByteSize() {
        return this.mediaByteSize;
    }

    public void setMediaByteSize(Integer mediaByteSize) {
        this.mediaByteSize = mediaByteSize;
    }

    public TransformResult height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500", value="The height of the transformed media")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public TransformResult width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500", value="The width of the transformed media")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformResult transformResult = (TransformResult)o;
        return Objects.equals(this.mediaType, transformResult.mediaType) && Objects.equals(this.format, transformResult.format) && Objects.equals(this.mediaByteSize, transformResult.mediaByteSize) && Objects.equals(this.height, transformResult.height) && Objects.equals(this.width, transformResult.width);
    }

    public int hashCode() {
        return Objects.hash(this.mediaType, this.format, this.mediaByteSize, this.height, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransformResult {\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    mediaByteSize: ").append(this.toIndentedString(this.mediaByteSize)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransformResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransformResult` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `media_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
    }

    public static TransformResult fromJson(String jsonString) throws IOException {
        return (TransformResult)JSON.getGson().fromJson(jsonString, TransformResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MEDIA_TYPE);
        openapiFields.add(SERIALIZED_NAME_FORMAT);
        openapiFields.add(SERIALIZED_NAME_MEDIA_BYTE_SIZE);
        openapiFields.add(SERIALIZED_NAME_HEIGHT);
        openapiFields.add(SERIALIZED_NAME_WIDTH);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransformResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransformResult.class));
            return new TypeAdapter<TransformResult>(){

                public void write(JsonWriter out, TransformResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransformResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransformResult.validateJsonObject(jsonObj);
                    return (TransformResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

