/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.media_editing.model;

import com.cloudinary.media_editing.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TransformationDescriptor {
    public static final String SERIALIZED_NAME_DESCRIPTOR_TYPE = "descriptor_type";
    @SerializedName(value="descriptor_type")
    private DescriptorTypeEnum descriptorType;
    public static final String SERIALIZED_NAME_NAMED_TRANSFORMATION = "named_transformation";
    @SerializedName(value="named_transformation")
    private String namedTransformation;
    public static final String SERIALIZED_NAME_CANONICAL_TRANSFORMATION = "canonical_transformation";
    @SerializedName(value="canonical_transformation")
    private String canonicalTransformation;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransformationDescriptor descriptorType(DescriptorTypeEnum descriptorType) {
        this.descriptorType = descriptorType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="canonical", required=true, value="The type of transformation to use")
    public DescriptorTypeEnum getDescriptorType() {
        return this.descriptorType;
    }

    public void setDescriptorType(DescriptorTypeEnum descriptorType) {
        this.descriptorType = descriptorType;
    }

    public TransformationDescriptor namedTransformation(String namedTransformation) {
        this.namedTransformation = namedTransformation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my_transformation", value="The name of a previously saved transformation")
    public String getNamedTransformation() {
        return this.namedTransformation;
    }

    public void setNamedTransformation(String namedTransformation) {
        this.namedTransformation = namedTransformation;
    }

    public TransformationDescriptor canonicalTransformation(String canonicalTransformation) {
        this.canonicalTransformation = canonicalTransformation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="c_scale/w_500", value="A set of transformation parameters defined using Cloudinary URL syntax")
    public String getCanonicalTransformation() {
        return this.canonicalTransformation;
    }

    public void setCanonicalTransformation(String canonicalTransformation) {
        this.canonicalTransformation = canonicalTransformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationDescriptor transformationDescriptor = (TransformationDescriptor)o;
        return Objects.equals((Object)this.descriptorType, (Object)transformationDescriptor.descriptorType) && Objects.equals(this.namedTransformation, transformationDescriptor.namedTransformation) && Objects.equals(this.canonicalTransformation, transformationDescriptor.canonicalTransformation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.descriptorType, this.namedTransformation, this.canonicalTransformation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransformationDescriptor {\n");
        sb.append("    descriptorType: ").append(this.toIndentedString((Object)this.descriptorType)).append("\n");
        sb.append("    namedTransformation: ").append(this.toIndentedString(this.namedTransformation)).append("\n");
        sb.append("    canonicalTransformation: ").append(this.toIndentedString(this.canonicalTransformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransformationDescriptor is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransformationDescriptor` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTOR_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTOR_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `descriptor_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTOR_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMED_TRANSFORMATION) != null && !jsonObj.get(SERIALIZED_NAME_NAMED_TRANSFORMATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `named_transformation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMED_TRANSFORMATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CANONICAL_TRANSFORMATION) != null && !jsonObj.get(SERIALIZED_NAME_CANONICAL_TRANSFORMATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `canonical_transformation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CANONICAL_TRANSFORMATION).toString()));
        }
    }

    public static TransformationDescriptor fromJson(String jsonString) throws IOException {
        return (TransformationDescriptor)JSON.getGson().fromJson(jsonString, TransformationDescriptor.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIPTOR_TYPE);
        openapiFields.add(SERIALIZED_NAME_NAMED_TRANSFORMATION);
        openapiFields.add(SERIALIZED_NAME_CANONICAL_TRANSFORMATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTOR_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransformationDescriptor.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransformationDescriptor.class));
            return new TypeAdapter<TransformationDescriptor>(){

                public void write(JsonWriter out, TransformationDescriptor value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransformationDescriptor read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransformationDescriptor.validateJsonObject(jsonObj);
                    return (TransformationDescriptor)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DescriptorTypeEnum {
        CANONICAL("canonical"),
        NAMED("named");

        private String value;

        private DescriptorTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DescriptorTypeEnum fromValue(String value) {
            for (DescriptorTypeEnum b : DescriptorTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DescriptorTypeEnum> {
            public void write(JsonWriter jsonWriter, DescriptorTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DescriptorTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DescriptorTypeEnum.fromValue(value);
            }
        }
    }
}

