/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getOrderId orderId}</li>
 * <li>{@link #getPaymentId paymentId}</li>
 * <li>{@link #getRefundId refundId}</li>
 * <li>{@link #getCreditId creditId}</li>
 * <li>{@link #getDisablePrinting disablePrinting}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DisplayReceiptOptionsRequest extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier of a Clover order
   */
  public java.lang.String getOrderId() {
    return genClient.cacheGet(CacheKey.orderId);
  }

  /**
   * Unique identifier of the payment associated with an order
   */
  public java.lang.String getPaymentId() {
    return genClient.cacheGet(CacheKey.paymentId);
  }

  /**
   * Unique identifier of the refund associated with an order
   */
  public java.lang.String getRefundId() {
    return genClient.cacheGet(CacheKey.refundId);
  }

  /**
   * Unique identifier of a credit (manual refund) given to a customer
   */
  public java.lang.String getCreditId() {
    return genClient.cacheGet(CacheKey.creditId);
  }

  public java.lang.Boolean getDisablePrinting() {
    return genClient.cacheGet(CacheKey.disablePrinting);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    orderId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    paymentId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    refundId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    creditId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    disablePrinting
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DisplayReceiptOptionsRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DisplayReceiptOptionsRequest() {
    genClient = new GenericClient<DisplayReceiptOptionsRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DisplayReceiptOptionsRequest(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DisplayReceiptOptionsRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DisplayReceiptOptionsRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DisplayReceiptOptionsRequest(DisplayReceiptOptionsRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.orderId, getOrderId());

    genClient.validateCloverId(CacheKey.paymentId, getPaymentId());

    genClient.validateCloverId(CacheKey.refundId, getRefundId());

    genClient.validateCloverId(CacheKey.creditId, getCreditId());
  }

  /** Checks whether the 'orderId' field is set and is not null */
  public boolean isNotNullOrderId() {
    return genClient.cacheValueIsNotNull(CacheKey.orderId);
  }

  /** Checks whether the 'paymentId' field is set and is not null */
  public boolean isNotNullPaymentId() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentId);
  }

  /** Checks whether the 'refundId' field is set and is not null */
  public boolean isNotNullRefundId() {
    return genClient.cacheValueIsNotNull(CacheKey.refundId);
  }

  /** Checks whether the 'creditId' field is set and is not null */
  public boolean isNotNullCreditId() {
    return genClient.cacheValueIsNotNull(CacheKey.creditId);
  }

  /** Checks whether the 'disablePrinting' field is set and is not null */
  public boolean isNotNullDisablePrinting() {
    return genClient.cacheValueIsNotNull(CacheKey.disablePrinting);
  }



  /** Checks whether the 'orderId' field has been set, however the value could be null */
  public boolean hasOrderId() {
    return genClient.cacheHasKey(CacheKey.orderId);
  }

  /** Checks whether the 'paymentId' field has been set, however the value could be null */
  public boolean hasPaymentId() {
    return genClient.cacheHasKey(CacheKey.paymentId);
  }

  /** Checks whether the 'refundId' field has been set, however the value could be null */
  public boolean hasRefundId() {
    return genClient.cacheHasKey(CacheKey.refundId);
  }

  /** Checks whether the 'creditId' field has been set, however the value could be null */
  public boolean hasCreditId() {
    return genClient.cacheHasKey(CacheKey.creditId);
  }

  /** Checks whether the 'disablePrinting' field has been set, however the value could be null */
  public boolean hasDisablePrinting() {
    return genClient.cacheHasKey(CacheKey.disablePrinting);
  }


  /**
   * Sets the field 'orderId'.
   */
  public DisplayReceiptOptionsRequest setOrderId(java.lang.String orderId) {
    return genClient.setOther(orderId, CacheKey.orderId);
  }

  /**
   * Sets the field 'paymentId'.
   */
  public DisplayReceiptOptionsRequest setPaymentId(java.lang.String paymentId) {
    return genClient.setOther(paymentId, CacheKey.paymentId);
  }

  /**
   * Sets the field 'refundId'.
   */
  public DisplayReceiptOptionsRequest setRefundId(java.lang.String refundId) {
    return genClient.setOther(refundId, CacheKey.refundId);
  }

  /**
   * Sets the field 'creditId'.
   */
  public DisplayReceiptOptionsRequest setCreditId(java.lang.String creditId) {
    return genClient.setOther(creditId, CacheKey.creditId);
  }

  /**
   * Sets the field 'disablePrinting'.
   */
  public DisplayReceiptOptionsRequest setDisablePrinting(java.lang.Boolean disablePrinting) {
    return genClient.setOther(disablePrinting, CacheKey.disablePrinting);
  }


  /** Clears the 'orderId' field, the 'has' method for this field will now return false */
  public void clearOrderId() {
    genClient.clear(CacheKey.orderId);
  }
  /** Clears the 'paymentId' field, the 'has' method for this field will now return false */
  public void clearPaymentId() {
    genClient.clear(CacheKey.paymentId);
  }
  /** Clears the 'refundId' field, the 'has' method for this field will now return false */
  public void clearRefundId() {
    genClient.clear(CacheKey.refundId);
  }
  /** Clears the 'creditId' field, the 'has' method for this field will now return false */
  public void clearCreditId() {
    genClient.clear(CacheKey.creditId);
  }
  /** Clears the 'disablePrinting' field, the 'has' method for this field will now return false */
  public void clearDisablePrinting() {
    genClient.clear(CacheKey.disablePrinting);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DisplayReceiptOptionsRequest copyChanges() {
    DisplayReceiptOptionsRequest copy = new DisplayReceiptOptionsRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DisplayReceiptOptionsRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DisplayReceiptOptionsRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DisplayReceiptOptionsRequest> CREATOR = new android.os.Parcelable.Creator<DisplayReceiptOptionsRequest>() {
    @Override
    public DisplayReceiptOptionsRequest createFromParcel(android.os.Parcel in) {
      DisplayReceiptOptionsRequest instance = new DisplayReceiptOptionsRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DisplayReceiptOptionsRequest[] newArray(int size) {
      return new DisplayReceiptOptionsRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DisplayReceiptOptionsRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DisplayReceiptOptionsRequest>() {
    public Class<DisplayReceiptOptionsRequest> getCreatedClass() {
      return DisplayReceiptOptionsRequest.class;
    }

    @Override
    public DisplayReceiptOptionsRequest create(org.json.JSONObject jsonObject) {
      return new DisplayReceiptOptionsRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ORDERID_IS_REQUIRED = false;
    public static final long ORDERID_MAX_LEN = 13;
    public static final boolean PAYMENTID_IS_REQUIRED = false;
    public static final long PAYMENTID_MAX_LEN = 13;
    public static final boolean REFUNDID_IS_REQUIRED = false;
    public static final long REFUNDID_MAX_LEN = 13;
    public static final boolean CREDITID_IS_REQUIRED = false;
    public static final long CREDITID_MAX_LEN = 13;
    public static final boolean DISABLEPRINTING_IS_REQUIRED = false;
  }

}
