/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMerchantID merchantID}</li>
 * <li>{@link #getMerchantMID merchantMID}</li>
 * <li>{@link #getMerchantName merchantName}</li>
 * <li>{@link #getSupportsAuths supportsAuths}</li>
 * <li>{@link #getSupportsPreAuths supportsPreAuths}</li>
 * <li>{@link #getSupportsSales supportsSales}</li>
 * <li>{@link #getSupportsVaultCards supportsVaultCards}</li>
 * <li>{@link #getSupportsManualRefunds supportsManualRefunds}</li>
 * <li>{@link #getSupportsTipAdjust supportsTipAdjust}</li>
 * <li>{@link #getDeviceInfo deviceInfo}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getMerchantID() {
    return genClient.cacheGet(CacheKey.merchantID);
  }

  public java.lang.String getMerchantMID() {
    return genClient.cacheGet(CacheKey.merchantMID);
  }

  /**
   * Name of the merchant
   */
  public java.lang.String getMerchantName() {
    return genClient.cacheGet(CacheKey.merchantName);
  }

  public java.lang.Boolean getSupportsAuths() {
    return genClient.cacheGet(CacheKey.supportsAuths);
  }

  public java.lang.Boolean getSupportsPreAuths() {
    return genClient.cacheGet(CacheKey.supportsPreAuths);
  }

  public java.lang.Boolean getSupportsSales() {
    return genClient.cacheGet(CacheKey.supportsSales);
  }

  public java.lang.Boolean getSupportsVaultCards() {
    return genClient.cacheGet(CacheKey.supportsVaultCards);
  }

  public java.lang.Boolean getSupportsManualRefunds() {
    return genClient.cacheGet(CacheKey.supportsManualRefunds);
  }

  public java.lang.Boolean getSupportsTipAdjust() {
    return genClient.cacheGet(CacheKey.supportsTipAdjust);
  }

  public com.clover.sdk.v3.remotepay.DeviceInfo getDeviceInfo() {
    return genClient.cacheGet(CacheKey.deviceInfo);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    merchantID
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchantMID
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchantName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    supportsAuths
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    supportsPreAuths
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    supportsSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    supportsVaultCards
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    supportsManualRefunds
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    supportsTipAdjust
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    deviceInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.remotepay.DeviceInfo.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantInfo() {
    genClient = new GenericClient<MerchantInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantInfo(MerchantInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.merchantID, getMerchantID());

    genClient.validateLength(CacheKey.merchantName, getMerchantName(), 127);
  }

  /** Checks whether the 'merchantID' field is set and is not null */
  public boolean isNotNullMerchantID() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantID);
  }

  /** Checks whether the 'merchantMID' field is set and is not null */
  public boolean isNotNullMerchantMID() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantMID);
  }

  /** Checks whether the 'merchantName' field is set and is not null */
  public boolean isNotNullMerchantName() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantName);
  }

  /** Checks whether the 'supportsAuths' field is set and is not null */
  public boolean isNotNullSupportsAuths() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsAuths);
  }

  /** Checks whether the 'supportsPreAuths' field is set and is not null */
  public boolean isNotNullSupportsPreAuths() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsPreAuths);
  }

  /** Checks whether the 'supportsSales' field is set and is not null */
  public boolean isNotNullSupportsSales() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsSales);
  }

  /** Checks whether the 'supportsVaultCards' field is set and is not null */
  public boolean isNotNullSupportsVaultCards() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsVaultCards);
  }

  /** Checks whether the 'supportsManualRefunds' field is set and is not null */
  public boolean isNotNullSupportsManualRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsManualRefunds);
  }

  /** Checks whether the 'supportsTipAdjust' field is set and is not null */
  public boolean isNotNullSupportsTipAdjust() {
    return genClient.cacheValueIsNotNull(CacheKey.supportsTipAdjust);
  }

  /** Checks whether the 'deviceInfo' field is set and is not null */
  public boolean isNotNullDeviceInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceInfo);
  }



  /** Checks whether the 'merchantID' field has been set, however the value could be null */
  public boolean hasMerchantID() {
    return genClient.cacheHasKey(CacheKey.merchantID);
  }

  /** Checks whether the 'merchantMID' field has been set, however the value could be null */
  public boolean hasMerchantMID() {
    return genClient.cacheHasKey(CacheKey.merchantMID);
  }

  /** Checks whether the 'merchantName' field has been set, however the value could be null */
  public boolean hasMerchantName() {
    return genClient.cacheHasKey(CacheKey.merchantName);
  }

  /** Checks whether the 'supportsAuths' field has been set, however the value could be null */
  public boolean hasSupportsAuths() {
    return genClient.cacheHasKey(CacheKey.supportsAuths);
  }

  /** Checks whether the 'supportsPreAuths' field has been set, however the value could be null */
  public boolean hasSupportsPreAuths() {
    return genClient.cacheHasKey(CacheKey.supportsPreAuths);
  }

  /** Checks whether the 'supportsSales' field has been set, however the value could be null */
  public boolean hasSupportsSales() {
    return genClient.cacheHasKey(CacheKey.supportsSales);
  }

  /** Checks whether the 'supportsVaultCards' field has been set, however the value could be null */
  public boolean hasSupportsVaultCards() {
    return genClient.cacheHasKey(CacheKey.supportsVaultCards);
  }

  /** Checks whether the 'supportsManualRefunds' field has been set, however the value could be null */
  public boolean hasSupportsManualRefunds() {
    return genClient.cacheHasKey(CacheKey.supportsManualRefunds);
  }

  /** Checks whether the 'supportsTipAdjust' field has been set, however the value could be null */
  public boolean hasSupportsTipAdjust() {
    return genClient.cacheHasKey(CacheKey.supportsTipAdjust);
  }

  /** Checks whether the 'deviceInfo' field has been set, however the value could be null */
  public boolean hasDeviceInfo() {
    return genClient.cacheHasKey(CacheKey.deviceInfo);
  }


  /**
   * Sets the field 'merchantID'.
   */
  public MerchantInfo setMerchantID(java.lang.String merchantID) {
    return genClient.setOther(merchantID, CacheKey.merchantID);
  }

  /**
   * Sets the field 'merchantMID'.
   */
  public MerchantInfo setMerchantMID(java.lang.String merchantMID) {
    return genClient.setOther(merchantMID, CacheKey.merchantMID);
  }

  /**
   * Sets the field 'merchantName'.
   */
  public MerchantInfo setMerchantName(java.lang.String merchantName) {
    return genClient.setOther(merchantName, CacheKey.merchantName);
  }

  /**
   * Sets the field 'supportsAuths'.
   */
  public MerchantInfo setSupportsAuths(java.lang.Boolean supportsAuths) {
    return genClient.setOther(supportsAuths, CacheKey.supportsAuths);
  }

  /**
   * Sets the field 'supportsPreAuths'.
   */
  public MerchantInfo setSupportsPreAuths(java.lang.Boolean supportsPreAuths) {
    return genClient.setOther(supportsPreAuths, CacheKey.supportsPreAuths);
  }

  /**
   * Sets the field 'supportsSales'.
   */
  public MerchantInfo setSupportsSales(java.lang.Boolean supportsSales) {
    return genClient.setOther(supportsSales, CacheKey.supportsSales);
  }

  /**
   * Sets the field 'supportsVaultCards'.
   */
  public MerchantInfo setSupportsVaultCards(java.lang.Boolean supportsVaultCards) {
    return genClient.setOther(supportsVaultCards, CacheKey.supportsVaultCards);
  }

  /**
   * Sets the field 'supportsManualRefunds'.
   */
  public MerchantInfo setSupportsManualRefunds(java.lang.Boolean supportsManualRefunds) {
    return genClient.setOther(supportsManualRefunds, CacheKey.supportsManualRefunds);
  }

  /**
   * Sets the field 'supportsTipAdjust'.
   */
  public MerchantInfo setSupportsTipAdjust(java.lang.Boolean supportsTipAdjust) {
    return genClient.setOther(supportsTipAdjust, CacheKey.supportsTipAdjust);
  }

  /**
   * Sets the field 'deviceInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantInfo setDeviceInfo(com.clover.sdk.v3.remotepay.DeviceInfo deviceInfo) {
    return genClient.setRecord(deviceInfo, CacheKey.deviceInfo);
  }


  /** Clears the 'merchantID' field, the 'has' method for this field will now return false */
  public void clearMerchantID() {
    genClient.clear(CacheKey.merchantID);
  }
  /** Clears the 'merchantMID' field, the 'has' method for this field will now return false */
  public void clearMerchantMID() {
    genClient.clear(CacheKey.merchantMID);
  }
  /** Clears the 'merchantName' field, the 'has' method for this field will now return false */
  public void clearMerchantName() {
    genClient.clear(CacheKey.merchantName);
  }
  /** Clears the 'supportsAuths' field, the 'has' method for this field will now return false */
  public void clearSupportsAuths() {
    genClient.clear(CacheKey.supportsAuths);
  }
  /** Clears the 'supportsPreAuths' field, the 'has' method for this field will now return false */
  public void clearSupportsPreAuths() {
    genClient.clear(CacheKey.supportsPreAuths);
  }
  /** Clears the 'supportsSales' field, the 'has' method for this field will now return false */
  public void clearSupportsSales() {
    genClient.clear(CacheKey.supportsSales);
  }
  /** Clears the 'supportsVaultCards' field, the 'has' method for this field will now return false */
  public void clearSupportsVaultCards() {
    genClient.clear(CacheKey.supportsVaultCards);
  }
  /** Clears the 'supportsManualRefunds' field, the 'has' method for this field will now return false */
  public void clearSupportsManualRefunds() {
    genClient.clear(CacheKey.supportsManualRefunds);
  }
  /** Clears the 'supportsTipAdjust' field, the 'has' method for this field will now return false */
  public void clearSupportsTipAdjust() {
    genClient.clear(CacheKey.supportsTipAdjust);
  }
  /** Clears the 'deviceInfo' field, the 'has' method for this field will now return false */
  public void clearDeviceInfo() {
    genClient.clear(CacheKey.deviceInfo);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantInfo copyChanges() {
    MerchantInfo copy = new MerchantInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantInfo> CREATOR = new android.os.Parcelable.Creator<MerchantInfo>() {
    @Override
    public MerchantInfo createFromParcel(android.os.Parcel in) {
      MerchantInfo instance = new MerchantInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantInfo[] newArray(int size) {
      return new MerchantInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantInfo>() {
    public Class<MerchantInfo> getCreatedClass() {
      return MerchantInfo.class;
    }

    @Override
    public MerchantInfo create(org.json.JSONObject jsonObject) {
      return new MerchantInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MERCHANTID_IS_REQUIRED = false;
    public static final long MERCHANTID_MAX_LEN = 13;
    public static final boolean MERCHANTMID_IS_REQUIRED = false;
    public static final boolean MERCHANTNAME_IS_REQUIRED = false;
    public static final long MERCHANTNAME_MAX_LEN = 127;
    public static final boolean SUPPORTSAUTHS_IS_REQUIRED = false;
    public static final boolean SUPPORTSPREAUTHS_IS_REQUIRED = false;
    public static final boolean SUPPORTSSALES_IS_REQUIRED = false;
    public static final boolean SUPPORTSVAULTCARDS_IS_REQUIRED = false;
    public static final boolean SUPPORTSMANUALREFUNDS_IS_REQUIRED = false;
    public static final boolean SUPPORTSTIPADJUST_IS_REQUIRED = false;
    public static final boolean DEVICEINFO_IS_REQUIRED = false;
  }

}
