/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Request to print an image, text, or an image from a URL. Current intention is to only have one.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getImage image}</li>
 * <li>{@link #getText text}</li>
 * <li>{@link #getImageUrl imageUrl}</li>
 * <li>{@link #getPrintRequestId printRequestId}</li>
 * <li>{@link #getPrintDeviceId printDeviceId}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PrintRequest extends com.clover.sdk.v3.remotepay.BaseRequest {

  /**
   * The image to be printed (put in an array for future extensibility).
   */
  public java.util.List<com.clover.sdk.v3.remotepay.Img> getImage() {
    return genClient.cacheGet(CacheKey.image);
  }

  /**
   * The text to be printed.
   */
  public java.util.List<java.lang.String> getText() {
    return genClient.cacheGet(CacheKey.text);
  }

  /**
   * The image URLs to be printed (put in an array for future extensibility).
   */
  public java.util.List<java.lang.String> getImageUrl() {
    return genClient.cacheGet(CacheKey.imageUrl);
  }

  /**
   * The ID associated with the request (for Status checks and similar use).
   */
  public java.lang.String getPrintRequestId() {
    return genClient.cacheGet(CacheKey.printRequestId);
  }

  /**
   * The ID of the device the print job should print from.
   */
  public java.lang.String getPrintDeviceId() {
    return genClient.cacheGet(CacheKey.printDeviceId);
  }

  /**
   * Identifier for the request
   */
  @Override
  public java.lang.String getRequestId() {
    return genClient.cacheGet(CacheKey.requestId);
  }

  /**
   * Identifier for the version
   */
  @Override
  public java.lang.Integer getVersion() {
    return genClient.cacheGet(CacheKey.version);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    image
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.remotepay.Img.JSON_CREATOR)),
    text
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    imageUrl
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    printRequestId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    printDeviceId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    requestId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    version
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PrintRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PrintRequest() {
    super(false);
    genClient = new GenericClient<PrintRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PrintRequest(boolean noInit) {
    super(false);
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PrintRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PrintRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PrintRequest(PrintRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.requestId, getRequestId());
  }

  /** Checks whether the 'image' field is set and is not null */
  public boolean isNotNullImage() {
    return genClient.cacheValueIsNotNull(CacheKey.image);
  }

  /** Checks whether the 'image' field is set and is not null and is not empty */
  public boolean isNotEmptyImage() { return isNotNullImage() && !getImage().isEmpty(); }

  /** Checks whether the 'text' field is set and is not null */
  public boolean isNotNullText() {
    return genClient.cacheValueIsNotNull(CacheKey.text);
  }

  /** Checks whether the 'text' field is set and is not null and is not empty */
  public boolean isNotEmptyText() { return isNotNullText() && !getText().isEmpty(); }

  /** Checks whether the 'imageUrl' field is set and is not null */
  public boolean isNotNullImageUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.imageUrl);
  }

  /** Checks whether the 'imageUrl' field is set and is not null and is not empty */
  public boolean isNotEmptyImageUrl() { return isNotNullImageUrl() && !getImageUrl().isEmpty(); }

  /** Checks whether the 'printRequestId' field is set and is not null */
  public boolean isNotNullPrintRequestId() {
    return genClient.cacheValueIsNotNull(CacheKey.printRequestId);
  }

  /** Checks whether the 'printDeviceId' field is set and is not null */
  public boolean isNotNullPrintDeviceId() {
    return genClient.cacheValueIsNotNull(CacheKey.printDeviceId);
  }

  /** Checks whether the 'requestId' field is set and is not null */
  @Override
  public boolean isNotNullRequestId() {
    return genClient.cacheValueIsNotNull(CacheKey.requestId);
  }

  /** Checks whether the 'version' field is set and is not null */
  @Override
  public boolean isNotNullVersion() {
    return genClient.cacheValueIsNotNull(CacheKey.version);
  }



  /** Checks whether the 'image' field has been set, however the value could be null */
  public boolean hasImage() {
    return genClient.cacheHasKey(CacheKey.image);
  }

  /** Checks whether the 'text' field has been set, however the value could be null */
  public boolean hasText() {
    return genClient.cacheHasKey(CacheKey.text);
  }

  /** Checks whether the 'imageUrl' field has been set, however the value could be null */
  public boolean hasImageUrl() {
    return genClient.cacheHasKey(CacheKey.imageUrl);
  }

  /** Checks whether the 'printRequestId' field has been set, however the value could be null */
  public boolean hasPrintRequestId() {
    return genClient.cacheHasKey(CacheKey.printRequestId);
  }

  /** Checks whether the 'printDeviceId' field has been set, however the value could be null */
  public boolean hasPrintDeviceId() {
    return genClient.cacheHasKey(CacheKey.printDeviceId);
  }

  /** Checks whether the 'requestId' field has been set, however the value could be null */
  @Override
  public boolean hasRequestId() {
    return genClient.cacheHasKey(CacheKey.requestId);
  }

  /** Checks whether the 'version' field has been set, however the value could be null */
  @Override
  public boolean hasVersion() {
    return genClient.cacheHasKey(CacheKey.version);
  }


  /**
   * Sets the field 'image'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public PrintRequest setImage(java.util.List<com.clover.sdk.v3.remotepay.Img> image) {
    return genClient.setArrayRecord(image, CacheKey.image);
  }

  /**
   * Sets the field 'text'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public PrintRequest setText(java.util.List<java.lang.String> text) {
    return genClient.setArrayOther(text, CacheKey.text);
  }

  /**
   * Sets the field 'imageUrl'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public PrintRequest setImageUrl(java.util.List<java.lang.String> imageUrl) {
    return genClient.setArrayOther(imageUrl, CacheKey.imageUrl);
  }

  /**
   * Sets the field 'printRequestId'.
   */
  public PrintRequest setPrintRequestId(java.lang.String printRequestId) {
    return genClient.setOther(printRequestId, CacheKey.printRequestId);
  }

  /**
   * Sets the field 'printDeviceId'.
   */
  public PrintRequest setPrintDeviceId(java.lang.String printDeviceId) {
    return genClient.setOther(printDeviceId, CacheKey.printDeviceId);
  }

  /**
   * Sets the field 'requestId'.
   */
  @Override
  public BaseRequest setRequestId(java.lang.String requestId) {
    return genClient.setOther(requestId, CacheKey.requestId);
  }

  /**
   * Sets the field 'version'.
   */
  @Override
  public BaseRequest setVersion(java.lang.Integer version) {
    return genClient.setOther(version, CacheKey.version);
  }


  /** Clears the 'image' field, the 'has' method for this field will now return false */
  public void clearImage() {
    genClient.clear(CacheKey.image);
  }
  /** Clears the 'text' field, the 'has' method for this field will now return false */
  public void clearText() {
    genClient.clear(CacheKey.text);
  }
  /** Clears the 'imageUrl' field, the 'has' method for this field will now return false */
  public void clearImageUrl() {
    genClient.clear(CacheKey.imageUrl);
  }
  /** Clears the 'printRequestId' field, the 'has' method for this field will now return false */
  public void clearPrintRequestId() {
    genClient.clear(CacheKey.printRequestId);
  }
  /** Clears the 'printDeviceId' field, the 'has' method for this field will now return false */
  public void clearPrintDeviceId() {
    genClient.clear(CacheKey.printDeviceId);
  }
  /** Clears the 'requestId' field, the 'has' method for this field will now return false */
  @Override
  public void clearRequestId() {
    genClient.clear(CacheKey.requestId);
  }
  /** Clears the 'version' field, the 'has' method for this field will now return false */
  @Override
  public void clearVersion() {
    genClient.clear(CacheKey.version);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PrintRequest copyChanges() {
    PrintRequest copy = new PrintRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PrintRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PrintRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PrintRequest> CREATOR = new android.os.Parcelable.Creator<PrintRequest>() {
    @Override
    public PrintRequest createFromParcel(android.os.Parcel in) {
      PrintRequest instance = new PrintRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PrintRequest[] newArray(int size) {
      return new PrintRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PrintRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PrintRequest>() {
    public Class<PrintRequest> getCreatedClass() {
      return PrintRequest.class;
    }

    @Override
    public PrintRequest create(org.json.JSONObject jsonObject) {
      return new PrintRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean IMAGE_IS_REQUIRED = false;
    public static final boolean TEXT_IS_REQUIRED = false;
    public static final boolean PRINTREQUESTID_IS_REQUIRED = false;
    public static final boolean PRINTDEVICEID_IS_REQUIRED = false;
    public static final boolean REQUESTID_IS_REQUIRED = false;
    public static final long REQUESTID_MAX_LEN = 13;
    public static final boolean VERSION_IS_REQUIRED = false;
  }

}
