/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getCard card}</li>
 * <li>{@link #getCardDetails cardDetails}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class VaultCardResponse extends BaseResponse {

  /**
   * The card that was vaulted.
   */
  public com.clover.sdk.v3.payments.VaultedCard getCard() {
    return genClient.cacheGet(CacheKey.card);
  }

  /**
   * Payment Card Data
   */
  public com.clover.sdk.v3.pay.PaymentRequestCardDetails getCardDetails() {
    return genClient.cacheGet(CacheKey.cardDetails);
  }

  /**
   * If true then the requested operation succeeded
   */
  @Override
  public Boolean getSuccess() {
    return genClient.cacheGet(CacheKey.success);
  }

  /**
   * The result of the requested operation.
   */
  @Override
  public ResponseCode getResult() {
    return genClient.cacheGet(CacheKey.result);
  }

  /**
   * Optional information about result.
   */
  @Override
  public String getReason() {
    return genClient.cacheGet(CacheKey.reason);
  }

  /**
   * Detailed information about result.
   */
  @Override
  public String getMessage() {
    return genClient.cacheGet(CacheKey.message);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    card
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.VaultedCard.JSON_CREATOR)),
    cardDetails
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.pay.PaymentRequestCardDetails.JSON_CREATOR)),
    success
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
    result
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(ResponseCode.class)),
    reason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    message
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<VaultCardResponse> genClient;

  /**
   * Constructs a new empty instance.
   */
  public VaultCardResponse() {
    super(false);
    genClient = new GenericClient<VaultCardResponse>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected VaultCardResponse(boolean noInit) {
    super(false);
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public VaultCardResponse(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public VaultCardResponse(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public VaultCardResponse(VaultCardResponse src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'card' field is set and is not null */
  public boolean isNotNullCard() {
    return genClient.cacheValueIsNotNull(CacheKey.card);
  }

  /** Checks whether the 'cardDetails' field is set and is not null */
  public boolean isNotNullCardDetails() {
    return genClient.cacheValueIsNotNull(CacheKey.cardDetails);
  }

  /** Checks whether the 'success' field is set and is not null */
  @Override
  public boolean isNotNullSuccess() {
    return genClient.cacheValueIsNotNull(CacheKey.success);
  }

  /** Checks whether the 'result' field is set and is not null */
  @Override
  public boolean isNotNullResult() {
    return genClient.cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'reason' field is set and is not null */
  @Override
  public boolean isNotNullReason() {
    return genClient.cacheValueIsNotNull(CacheKey.reason);
  }

  /** Checks whether the 'message' field is set and is not null */
  @Override
  public boolean isNotNullMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.message);
  }



  /** Checks whether the 'card' field has been set, however the value could be null */
  public boolean hasCard() {
    return genClient.cacheHasKey(CacheKey.card);
  }

  /** Checks whether the 'cardDetails' field has been set, however the value could be null */
  public boolean hasCardDetails() {
    return genClient.cacheHasKey(CacheKey.cardDetails);
  }

  /** Checks whether the 'success' field has been set, however the value could be null */
  @Override
  public boolean hasSuccess() {
    return genClient.cacheHasKey(CacheKey.success);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  @Override
  public boolean hasResult() {
    return genClient.cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'reason' field has been set, however the value could be null */
  @Override
  public boolean hasReason() {
    return genClient.cacheHasKey(CacheKey.reason);
  }

  /** Checks whether the 'message' field has been set, however the value could be null */
  @Override
  public boolean hasMessage() {
    return genClient.cacheHasKey(CacheKey.message);
  }


  /**
   * Sets the field 'card'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VaultCardResponse setCard(com.clover.sdk.v3.payments.VaultedCard card) {
    return genClient.setRecord(card, CacheKey.card);
  }

  /**
   * Sets the field 'cardDetails'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VaultCardResponse setCardDetails(com.clover.sdk.v3.pay.PaymentRequestCardDetails cardDetails) {
    return genClient.setRecord(cardDetails, CacheKey.cardDetails);
  }

  /**
   * Sets the field 'success'.
   */
  @Override
  public BaseResponse setSuccess(Boolean success) {
    return genClient.setOther(success, CacheKey.success);
  }

  /**
   * Sets the field 'result'.
   */
  @Override
  public BaseResponse setResult(ResponseCode result) {
    return genClient.setOther(result, CacheKey.result);
  }

  /**
   * Sets the field 'reason'.
   */
  @Override
  public BaseResponse setReason(String reason) {
    return genClient.setOther(reason, CacheKey.reason);
  }

  /**
   * Sets the field 'message'.
   */
  @Override
  public BaseResponse setMessage(String message) {
    return genClient.setOther(message, CacheKey.message);
  }


  /** Clears the 'card' field, the 'has' method for this field will now return false */
  public void clearCard() {
    genClient.clear(CacheKey.card);
  }
  /** Clears the 'cardDetails' field, the 'has' method for this field will now return false */
  public void clearCardDetails() {
    genClient.clear(CacheKey.cardDetails);
  }
  /** Clears the 'success' field, the 'has' method for this field will now return false */
  @Override
  public void clearSuccess() {
    genClient.clear(CacheKey.success);
  }
  /** Clears the 'result' field, the 'has' method for this field will now return false */
  @Override
  public void clearResult() {
    genClient.clear(CacheKey.result);
  }
  /** Clears the 'reason' field, the 'has' method for this field will now return false */
  @Override
  public void clearReason() {
    genClient.clear(CacheKey.reason);
  }
  /** Clears the 'message' field, the 'has' method for this field will now return false */
  @Override
  public void clearMessage() {
    genClient.clear(CacheKey.message);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public VaultCardResponse copyChanges() {
    VaultCardResponse copy = new VaultCardResponse();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(VaultCardResponse src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new VaultCardResponse(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<VaultCardResponse> CREATOR = new android.os.Parcelable.Creator<VaultCardResponse>() {
    @Override
    public VaultCardResponse createFromParcel(android.os.Parcel in) {
      VaultCardResponse instance = new VaultCardResponse(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public VaultCardResponse[] newArray(int size) {
      return new VaultCardResponse[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<VaultCardResponse> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<VaultCardResponse>() {
    public Class<VaultCardResponse> getCreatedClass() {
      return VaultCardResponse.class;
    }

    @Override
    public VaultCardResponse create(org.json.JSONObject jsonObject) {
      return new VaultCardResponse(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean CARD_IS_REQUIRED = false;
    public static final boolean CARDDETAILS_IS_REQUIRED = false;
    public static final boolean SUCCESS_IS_REQUIRED = false;
    public static final boolean RESULT_IS_REQUIRED = false;
    public static final boolean REASON_IS_REQUIRED = false;
    public static final boolean MESSAGE_IS_REQUIRED = false;
  }

}
