/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * The response to an authorization request
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * </ul>
 */
@SuppressWarnings("all")
public class AuthResponse extends com.clover.sdk.v3.remotepay.PaymentResponse {

  /**
   * The payment from the sale
   */
  @Override
  public com.clover.sdk.v3.payments.Payment getPayment() {
    return genClient.cacheGet(CacheKey.payment);
  }

  @Override
  public java.lang.Boolean getIsSale() {
    return genClient.cacheGet(CacheKey.isSale);
  }

  @Override
  public java.lang.Boolean getIsPreAuth() {
    return genClient.cacheGet(CacheKey.isPreAuth);
  }

  @Override
  public java.lang.Boolean getIsAuth() {
    return genClient.cacheGet(CacheKey.isAuth);
  }

  @Override
  public com.clover.sdk.v3.base.Signature getSignature() {
    return genClient.cacheGet(CacheKey.signature);
  }

  /**
   * If true then the requested operation succeeded
   */
  @Override
  public java.lang.Boolean getSuccess() {
    return genClient.cacheGet(CacheKey.success);
  }

  /**
   * The result of the requested operation.
   */
  @Override
  public com.clover.sdk.v3.remotepay.ResponseCode getResult() {
    return genClient.cacheGet(CacheKey.result);
  }

  /**
   * Optional information about result.
   */
  @Override
  public java.lang.String getReason() {
    return genClient.cacheGet(CacheKey.reason);
  }

  /**
   * Detailed information about result.
   */
  @Override
  public java.lang.String getMessage() {
    return genClient.cacheGet(CacheKey.message);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    payment
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.Payment.JSON_CREATOR)),
    isSale
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    isPreAuth
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    isAuth
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    signature
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Signature.JSON_CREATOR)),
    success
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    result
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.remotepay.ResponseCode.class)),
    reason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    message
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AuthResponse> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AuthResponse() {
    super(false);
    genClient = new GenericClient<AuthResponse>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AuthResponse(boolean noInit) {
    super(false);
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AuthResponse(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AuthResponse(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AuthResponse(AuthResponse src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'payment' field is set and is not null */
  @Override
  public boolean isNotNullPayment() {
    return genClient.cacheValueIsNotNull(CacheKey.payment);
  }

  /** Checks whether the 'isSale' field is set and is not null */
  @Override
  public boolean isNotNullIsSale() {
    return genClient.cacheValueIsNotNull(CacheKey.isSale);
  }

  /** Checks whether the 'isPreAuth' field is set and is not null */
  @Override
  public boolean isNotNullIsPreAuth() {
    return genClient.cacheValueIsNotNull(CacheKey.isPreAuth);
  }

  /** Checks whether the 'isAuth' field is set and is not null */
  @Override
  public boolean isNotNullIsAuth() {
    return genClient.cacheValueIsNotNull(CacheKey.isAuth);
  }

  /** Checks whether the 'signature' field is set and is not null */
  @Override
  public boolean isNotNullSignature() {
    return genClient.cacheValueIsNotNull(CacheKey.signature);
  }

  /** Checks whether the 'success' field is set and is not null */
  @Override
  public boolean isNotNullSuccess() {
    return genClient.cacheValueIsNotNull(CacheKey.success);
  }

  /** Checks whether the 'result' field is set and is not null */
  @Override
  public boolean isNotNullResult() {
    return genClient.cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'reason' field is set and is not null */
  @Override
  public boolean isNotNullReason() {
    return genClient.cacheValueIsNotNull(CacheKey.reason);
  }

  /** Checks whether the 'message' field is set and is not null */
  @Override
  public boolean isNotNullMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.message);
  }



  /** Checks whether the 'payment' field has been set, however the value could be null */
  @Override
  public boolean hasPayment() {
    return genClient.cacheHasKey(CacheKey.payment);
  }

  /** Checks whether the 'isSale' field has been set, however the value could be null */
  @Override
  public boolean hasIsSale() {
    return genClient.cacheHasKey(CacheKey.isSale);
  }

  /** Checks whether the 'isPreAuth' field has been set, however the value could be null */
  @Override
  public boolean hasIsPreAuth() {
    return genClient.cacheHasKey(CacheKey.isPreAuth);
  }

  /** Checks whether the 'isAuth' field has been set, however the value could be null */
  @Override
  public boolean hasIsAuth() {
    return genClient.cacheHasKey(CacheKey.isAuth);
  }

  /** Checks whether the 'signature' field has been set, however the value could be null */
  @Override
  public boolean hasSignature() {
    return genClient.cacheHasKey(CacheKey.signature);
  }

  /** Checks whether the 'success' field has been set, however the value could be null */
  @Override
  public boolean hasSuccess() {
    return genClient.cacheHasKey(CacheKey.success);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  @Override
  public boolean hasResult() {
    return genClient.cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'reason' field has been set, however the value could be null */
  @Override
  public boolean hasReason() {
    return genClient.cacheHasKey(CacheKey.reason);
  }

  /** Checks whether the 'message' field has been set, however the value could be null */
  @Override
  public boolean hasMessage() {
    return genClient.cacheHasKey(CacheKey.message);
  }


  /**
   * Sets the field 'payment'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  @Override
  public PaymentResponse setPayment(com.clover.sdk.v3.payments.Payment payment) {
    return genClient.setRecord(payment, CacheKey.payment);
  }

  /**
   * Sets the field 'isSale'.
   */
  @Override
  public PaymentResponse setIsSale(java.lang.Boolean isSale) {
    return genClient.setOther(isSale, CacheKey.isSale);
  }

  /**
   * Sets the field 'isPreAuth'.
   */
  @Override
  public PaymentResponse setIsPreAuth(java.lang.Boolean isPreAuth) {
    return genClient.setOther(isPreAuth, CacheKey.isPreAuth);
  }

  /**
   * Sets the field 'isAuth'.
   */
  @Override
  public PaymentResponse setIsAuth(java.lang.Boolean isAuth) {
    return genClient.setOther(isAuth, CacheKey.isAuth);
  }

  /**
   * Sets the field 'signature'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  @Override
  public PaymentResponse setSignature(com.clover.sdk.v3.base.Signature signature) {
    return genClient.setRecord(signature, CacheKey.signature);
  }

  /**
   * Sets the field 'success'.
   */
  @Override
  public BaseResponse setSuccess(java.lang.Boolean success) {
    return genClient.setOther(success, CacheKey.success);
  }

  /**
   * Sets the field 'result'.
   */
  @Override
  public BaseResponse setResult(com.clover.sdk.v3.remotepay.ResponseCode result) {
    return genClient.setOther(result, CacheKey.result);
  }

  /**
   * Sets the field 'reason'.
   */
  @Override
  public BaseResponse setReason(java.lang.String reason) {
    return genClient.setOther(reason, CacheKey.reason);
  }

  /**
   * Sets the field 'message'.
   */
  @Override
  public BaseResponse setMessage(java.lang.String message) {
    return genClient.setOther(message, CacheKey.message);
  }


  /** Clears the 'payment' field, the 'has' method for this field will now return false */
  @Override
  public void clearPayment() {
    genClient.clear(CacheKey.payment);
  }
  /** Clears the 'isSale' field, the 'has' method for this field will now return false */
  @Override
  public void clearIsSale() {
    genClient.clear(CacheKey.isSale);
  }
  /** Clears the 'isPreAuth' field, the 'has' method for this field will now return false */
  @Override
  public void clearIsPreAuth() {
    genClient.clear(CacheKey.isPreAuth);
  }
  /** Clears the 'isAuth' field, the 'has' method for this field will now return false */
  @Override
  public void clearIsAuth() {
    genClient.clear(CacheKey.isAuth);
  }
  /** Clears the 'signature' field, the 'has' method for this field will now return false */
  @Override
  public void clearSignature() {
    genClient.clear(CacheKey.signature);
  }
  /** Clears the 'success' field, the 'has' method for this field will now return false */
  @Override
  public void clearSuccess() {
    genClient.clear(CacheKey.success);
  }
  /** Clears the 'result' field, the 'has' method for this field will now return false */
  @Override
  public void clearResult() {
    genClient.clear(CacheKey.result);
  }
  /** Clears the 'reason' field, the 'has' method for this field will now return false */
  @Override
  public void clearReason() {
    genClient.clear(CacheKey.reason);
  }
  /** Clears the 'message' field, the 'has' method for this field will now return false */
  @Override
  public void clearMessage() {
    genClient.clear(CacheKey.message);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AuthResponse copyChanges() {
    AuthResponse copy = new AuthResponse();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AuthResponse src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AuthResponse(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AuthResponse> CREATOR = new android.os.Parcelable.Creator<AuthResponse>() {
    @Override
    public AuthResponse createFromParcel(android.os.Parcel in) {
      AuthResponse instance = new AuthResponse(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AuthResponse[] newArray(int size) {
      return new AuthResponse[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AuthResponse> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AuthResponse>() {
    public Class<AuthResponse> getCreatedClass() {
      return AuthResponse.class;
    }

    @Override
    public AuthResponse create(org.json.JSONObject jsonObject) {
      return new AuthResponse(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean PAYMENT_IS_REQUIRED = false;
    public static final boolean ISSALE_IS_REQUIRED = false;
    public static final boolean ISPREAUTH_IS_REQUIRED = false;
    public static final boolean ISAUTH_IS_REQUIRED = false;
    public static final boolean SIGNATURE_IS_REQUIRED = false;
    public static final boolean SUCCESS_IS_REQUIRED = false;
    public static final boolean RESULT_IS_REQUIRED = false;
    public static final boolean REASON_IS_REQUIRED = false;
    public static final boolean MESSAGE_IS_REQUIRED = false;
  }

}
