/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.remotepay;

import com.clover.sdk.GenericClient;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Request to start a custom activity on a device.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getAction action}</li>
 * <li>{@link #getPayload payload}</li>
 * <li>{@link #getNonBlocking nonBlocking}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CustomActivityRequest extends com.clover.sdk.v3.remotepay.BaseRequest {

  /**
   * The name of the action for this activity
   */
  public java.lang.String getAction() {
    return genClient.cacheGet(CacheKey.action);
  }

  /**
   * Data for this activity
   */
  public java.lang.String getPayload() {
    return genClient.cacheGet(CacheKey.payload);
  }

  /**
   * If true, then the activity can be stopped in regular execution.
   */
  public java.lang.Boolean getNonBlocking() {
    return genClient.cacheGet(CacheKey.nonBlocking);
  }

  /**
   * Identifier for the request
   */
  @Override
  public java.lang.String getRequestId() {
    return genClient.cacheGet(CacheKey.requestId);
  }

  /**
   * Identifier for the version
   */
  @Override
  public java.lang.Integer getVersion() {
    return genClient.cacheGet(CacheKey.version);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    action
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    payload
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    nonBlocking
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    requestId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    version
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CustomActivityRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CustomActivityRequest() {
    super(false);
    genClient = new GenericClient<CustomActivityRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CustomActivityRequest(boolean noInit) {
    super(false);
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CustomActivityRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CustomActivityRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CustomActivityRequest(CustomActivityRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.requestId, getRequestId());
  }

  /** Checks whether the 'action' field is set and is not null */
  public boolean isNotNullAction() {
    return genClient.cacheValueIsNotNull(CacheKey.action);
  }

  /** Checks whether the 'payload' field is set and is not null */
  public boolean isNotNullPayload() {
    return genClient.cacheValueIsNotNull(CacheKey.payload);
  }

  /** Checks whether the 'nonBlocking' field is set and is not null */
  public boolean isNotNullNonBlocking() {
    return genClient.cacheValueIsNotNull(CacheKey.nonBlocking);
  }

  /** Checks whether the 'requestId' field is set and is not null */
  @Override
  public boolean isNotNullRequestId() {
    return genClient.cacheValueIsNotNull(CacheKey.requestId);
  }

  /** Checks whether the 'version' field is set and is not null */
  @Override
  public boolean isNotNullVersion() {
    return genClient.cacheValueIsNotNull(CacheKey.version);
  }



  /** Checks whether the 'action' field has been set, however the value could be null */
  public boolean hasAction() {
    return genClient.cacheHasKey(CacheKey.action);
  }

  /** Checks whether the 'payload' field has been set, however the value could be null */
  public boolean hasPayload() {
    return genClient.cacheHasKey(CacheKey.payload);
  }

  /** Checks whether the 'nonBlocking' field has been set, however the value could be null */
  public boolean hasNonBlocking() {
    return genClient.cacheHasKey(CacheKey.nonBlocking);
  }

  /** Checks whether the 'requestId' field has been set, however the value could be null */
  @Override
  public boolean hasRequestId() {
    return genClient.cacheHasKey(CacheKey.requestId);
  }

  /** Checks whether the 'version' field has been set, however the value could be null */
  @Override
  public boolean hasVersion() {
    return genClient.cacheHasKey(CacheKey.version);
  }


  /**
   * Sets the field 'action'.
   */
  public CustomActivityRequest setAction(java.lang.String action) {
    return genClient.setOther(action, CacheKey.action);
  }

  /**
   * Sets the field 'payload'.
   */
  public CustomActivityRequest setPayload(java.lang.String payload) {
    return genClient.setOther(payload, CacheKey.payload);
  }

  /**
   * Sets the field 'nonBlocking'.
   */
  public CustomActivityRequest setNonBlocking(java.lang.Boolean nonBlocking) {
    return genClient.setOther(nonBlocking, CacheKey.nonBlocking);
  }

  /**
   * Sets the field 'requestId'.
   */
  @Override
  public BaseRequest setRequestId(java.lang.String requestId) {
    return genClient.setOther(requestId, CacheKey.requestId);
  }

  /**
   * Sets the field 'version'.
   */
  @Override
  public BaseRequest setVersion(java.lang.Integer version) {
    return genClient.setOther(version, CacheKey.version);
  }


  /** Clears the 'action' field, the 'has' method for this field will now return false */
  public void clearAction() {
    genClient.clear(CacheKey.action);
  }
  /** Clears the 'payload' field, the 'has' method for this field will now return false */
  public void clearPayload() {
    genClient.clear(CacheKey.payload);
  }
  /** Clears the 'nonBlocking' field, the 'has' method for this field will now return false */
  public void clearNonBlocking() {
    genClient.clear(CacheKey.nonBlocking);
  }
  /** Clears the 'requestId' field, the 'has' method for this field will now return false */
  @Override
  public void clearRequestId() {
    genClient.clear(CacheKey.requestId);
  }
  /** Clears the 'version' field, the 'has' method for this field will now return false */
  @Override
  public void clearVersion() {
    genClient.clear(CacheKey.version);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CustomActivityRequest copyChanges() {
    CustomActivityRequest copy = new CustomActivityRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CustomActivityRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CustomActivityRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CustomActivityRequest> CREATOR = new android.os.Parcelable.Creator<CustomActivityRequest>() {
    @Override
    public CustomActivityRequest createFromParcel(android.os.Parcel in) {
      CustomActivityRequest instance = new CustomActivityRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CustomActivityRequest[] newArray(int size) {
      return new CustomActivityRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CustomActivityRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CustomActivityRequest>() {
    public Class<CustomActivityRequest> getCreatedClass() {
      return CustomActivityRequest.class;
    }

    @Override
    public CustomActivityRequest create(org.json.JSONObject jsonObject) {
      return new CustomActivityRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ACTION_IS_REQUIRED = false;
    public static final boolean PAYLOAD_IS_REQUIRED = false;
    public static final boolean NONBLOCKING_IS_REQUIRED = false;
    public static final boolean REQUESTID_IS_REQUIRED = false;
    public static final long REQUESTID_MAX_LEN = 13;
    public static final boolean VERSION_IS_REQUIRED = false;
  }

}
