/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.analytics;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getUuid uuid}</li>
 * <li>{@link #getMerchantId merchantId}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class RefundAnalytic extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getUuid() {
    return genClient.cacheGet(CacheKey.uuid);
  }

  public java.lang.Long getMerchantId() {
    return genClient.cacheGet(CacheKey.merchantId);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<RefundAnalytic> {
    uuid {
      @Override
      public Object extractValue(RefundAnalytic instance) {
        return instance.genClient.extractOther("uuid", java.lang.String.class);
      }
    },
    merchantId {
      @Override
      public Object extractValue(RefundAnalytic instance) {
        return instance.genClient.extractOther("merchantId", java.lang.Long.class);
      }
    },
      ;
  }

  private GenericClient<RefundAnalytic> genClient;

  /**
  * Constructs a new empty instance.
  */
  public RefundAnalytic() {
    genClient = new GenericClient<RefundAnalytic>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected RefundAnalytic(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public RefundAnalytic(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public RefundAnalytic(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public RefundAnalytic(RefundAnalytic src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getUuid(), 13);
  }

  /** Checks whether the 'uuid' field is set and is not null */
  public boolean isNotNullUuid() {
    return genClient.cacheValueIsNotNull(CacheKey.uuid);
  }

  /** Checks whether the 'merchantId' field is set and is not null */
  public boolean isNotNullMerchantId() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantId);
  }



  /** Checks whether the 'uuid' field has been set, however the value could be null */
  public boolean hasUuid() {
    return genClient.cacheHasKey(CacheKey.uuid);
  }

  /** Checks whether the 'merchantId' field has been set, however the value could be null */
  public boolean hasMerchantId() {
    return genClient.cacheHasKey(CacheKey.merchantId);
  }


  /**
   * Sets the field 'uuid'.
   */
  public RefundAnalytic setUuid(java.lang.String uuid) {
    return genClient.setOther(uuid, CacheKey.uuid);
  }

  /**
   * Sets the field 'merchantId'.
   */
  public RefundAnalytic setMerchantId(java.lang.Long merchantId) {
    return genClient.setOther(merchantId, CacheKey.merchantId);
  }


  /** Clears the 'uuid' field, the 'has' method for this field will now return false */
  public void clearUuid() {
    genClient.clear(CacheKey.uuid);
  }
  /** Clears the 'merchantId' field, the 'has' method for this field will now return false */
  public void clearMerchantId() {
    genClient.clear(CacheKey.merchantId);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public RefundAnalytic copyChanges() {
    RefundAnalytic copy = new RefundAnalytic();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(RefundAnalytic src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new RefundAnalytic(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<RefundAnalytic> CREATOR = new android.os.Parcelable.Creator<RefundAnalytic>() {
    @Override
    public RefundAnalytic createFromParcel(android.os.Parcel in) {
      RefundAnalytic instance = new RefundAnalytic(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public RefundAnalytic[] newArray(int size) {
      return new RefundAnalytic[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<RefundAnalytic> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<RefundAnalytic>() {
    @Override
    public RefundAnalytic create(org.json.JSONObject jsonObject) {
      return new RefundAnalytic(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean UUID_IS_REQUIRED = false;
    public static final long UUID_MAX_LEN = 13;
    public static final boolean MERCHANTID_IS_REQUIRED = false;

  }

}
